from jdsu.evm import *
from jdsu.diag import *
from jdsu.cal.calib import *
from jdsu.mts.blockutils import mount_cal, umount_cal
import os
from shutil import rmtree

global cal

@RESOURCE("calibration")
def load_calibration(mode):
    global cal
    if mode:
        Log("Load current calibration")
        cal = cal_get_base_calibration()
    else:
        Log("Save current calibration")
        cal_set_base_calibration(cal)


@DIAG("cal", depends=["calibration"])
def cal(cmd):
    global cal
    import datetime
    if len(cmd.split()) == 1:
        print(cal)
        return True
    params = cmd.split()[1:]
    params[0] = params[0].lower()
    try:
        if params[0] == "init":
            cal_init_platform(cal)

        elif params[0] == "print":
            print(cal)

        elif params[0] == "save":
            cal_set_base_calibration(cal)
            oldcrc = cal.data["Common"].data["First"].data["Crc"].value()
            newcal = cal_get_base_calibration()
            newcrc = newcal.data["Common"].data["First"].data["Crc"].value()
            return (newcrc == oldcrc)

        elif params[0] == "reload":
            cal = cal_get_base_calibration()

        elif params[0] == "vhard":
            if len(params) > 1:
                cal_set_header(cal, "Hdw_Release", int(params[1]))
            else:
                print_info("# %s"%cal.data["Common"].data["Header"].data["Hdw_Release"])

        elif params[0] == "nmod":
            if len(params) > 1:
                cal_set_header(cal, "Serial_Number", " ".join(params[1:]))
            else:
                print_info("# %s"%cal.data["Common"].data["Header"].data["Serial_Number"])

        elif params[0] == "name":
            if len(params) > 1:
                cal_set_header(cal, "Module_Name", " ".join(params[1:]))
            else:
                print_info("# %s"%cal.data["Common"].data["Header"].data["Module_Name"])

        elif params[0] == "dfab":
            if len(params) > 1:
                cal_set_header(cal, "Date_Fab", datetime.datetime(int(params[1]), int(params[2]), int(params[3]), 0, 0, 0))
            else:
                print_info("# %s"%cal.data["Common"].data["Header"].data["Date_Fab"])

        elif params[0] == "dcal":
            print_info("# %s"%cal.data["Common"].data["Header"].data["Date_Calib"])

        elif params[0] == "calib":
            if len(params) > 1:
                cal_set_header(cal, "Calibrated", params[1].lower()[0] == "y")
            else:
                print_info("# %s"%cal.data["Common"].data["Header"].data["Calibrated"])

        elif params[0] == "barc":
            if len(params) > 1:
                cal_set_header(cal, "Bar_Code", " ".join(params[1:]))
            else:
                print_info("# %s"%cal.data["Common"].data["Header"].data["Bar_Code"])

        elif params[0] == "serial":
                print_info("# Serial_Number: %s%s"%(cal.data["Common"].data["Header"].data["Prefix"].value(),cal.data["Common"].data["Header"].data["Serial_Number"].value()))

        elif params[0] == "prod":
            if len(params) > 2:
                cal.data["Prod"].data["Prod_Parametres"].item(int(params[1])).value(int(params[2]))
            elif len(params) > 1:
                print_info("# %s"%cal.data["Prod"].data["Prod_Parametres"].item(int(params[1])).value())

        elif params[0] == "prefix":
            if len(params) > 1:
                cal_set_header(cal, "Prefix", " ".join(params[1:]))
            else:
                print_info("# %s"%cal.data["Common"].data["Header"].data["Prefix"])

        elif params[0] == "pbuf":
            if len(params) > 1:
                buf = params[1]
                if buf[0] == "#":
                    buf_size_size = int(buf[1])
                    buf_size = int(buf[2:2+buf_size_size+4]) # +4 : For 2 bytes offset
                    buf = buf[6 + buf_size_size:6 + buf_size_size + buf_size]
                cal.data["Prod"].data["Prod"].value(buf)
            else:
                data = cal.data["Prod"].data["Prod"].value()
                head =  "#4%04d"%len(data)
                print_info("# %s%s"%(head,data))

        elif params[0] == "purge":
            if os.path.exists("/dev/mmcblk1p2"):
                # remove everything from /cal
                mount_cal()
                folder = '/cal'
                for file in os.listdir(folder):
                    file_path = os.path.join(folder, file)
                    try:
                        if os.path.isfile(file_path):
                            os.unlink(file_path)
                    except Exception as e:
                        print(e)
                        umount_cal(1)
                        return False
                umount_cal(1)
        else:
            print_error("Unknown command %s"%params[0])
            return False
        return True
    except Exception as err:
        print_error("%s"%err)
        return False
