from jdsu.evm import *
import os.path
import traceback
import sys


def DIAG(text, depends=[]):
    def decorator(fc):
        def dfunc(session, event=None):
            print_default("# %s" % text)
            for d in depends:
                if d in __builtins__["resources"].keys():
                    __builtins__["resources"][d](True)
            try:
                res = fc(session)
            except Exception as err:
                exc_type, exc_obj, exc_tb = sys.exc_info()
                print_error("## Error: \"%s\"" % (str(err)))
                print_error("## \tfunc: %s" % (fc.__name__))
                print_error("##")
                exc_tb = exc_tb.tb_next
                while(exc_tb):
                    print_error("## \tfile: %s" % (exc_tb.tb_frame.f_code.co_filename))
                    print_error("## \tline: %s" % (exc_tb.tb_lineno))
                    with open(exc_tb.tb_frame.f_code.co_filename) as f:
                        for i in range(int(exc_tb.tb_lineno) - 3):
                            f.readline()
                        print_default("## \tcode:")
                        print_default("## \t\t%s"%f.readline().strip("\n"))
                        print_default("## \t\t%s"%f.readline().strip("\n"))
                        print_default("## \t\t\033[31m%s\033[0m"%f.readline().strip("\n"))
                        print_default("## \t\t%s"%f.readline().strip("\n"))
                        print_default("## \t\t%s"%f.readline().strip("\n"))
                        print_default("##\t_____________________________")
                        print_error("##")
                    exc_tb = exc_tb.tb_next
                res = False
            if res is None:
                print_ok("OK")
            elif res is True:
                print_ok("PASSED")
            else:
                print_error("FAILED")
        __builtins__["cinput"].add_command(fc.__name__, dfunc)
        dfunc.parameters = {}
        dfunc.diag = True
        return fc
    return decorator


def RESOURCE(resname, depends=[]):
    if "resources" not in __builtins__:
        __builtins__["resources"] = {}

    def decorator(fc):
        def dfunc(mode):
            if mode is True:
                for d in depends:
                    if d in __builtins__["resources"].keys():
                        __builtins__["resources"][d](True)
                if not dfunc.enabled:
                    fc(mode)
                    dfunc.enabled = True
            else:
                if dfunc.enabled:
                    fc(False)
                    dfunc.enabled = False
        dfunc.enabled = False
        __builtins__["resources"][resname] = dfunc
        return fc
    return decorator


def CHECK(name, value, vmin=None, vmax=None, need=None, acc=None, hexval=None):
    if hexval != None:
        if value == hexval:
            print_ok("# Test %s OK (0x%x)" % (name, int(value)))
            return True
        else:
            print_error("# Error, %s = 0x%x (expect 0x%x)" % (name, int(value), int(hexval)))
            return False
    if vmin is None:
        vmin = float(need) - float(acc)
    if vmax is None:
        vmax = float(need) + float(acc)
    if value < vmin:
        print_error("# Error, %s = %f < %f" % (name, value, vmin))
        return False
    if value > vmax:
        print_error("# Error, %s = %f > %f" % (name, value, vmax))
        return False
    print_ok("# Test %s OK %f in [%f,%f]" % (name, value, vmin, vmax))
    return True


def sysfs_write(path, value):
    v = "%s\n" % str(value).strip()
    if not os.path.isfile(path):
        print_error("Can't access %s" % path)
        return
    with open(path, "w") as f:
        f.write(v)
        f.flush()



def sysfs_read(path):
    with open(path, "r") as f:
        v = f.read(255)
        if "x" in v:
            return int(v,0)
        return float(v)

def sysfs_read_string(path):
    with open(path, "r") as f:
        v = f.read(255)
        v = v.replace("\n"," ")
        return (v)


def sysfs_check(path, name, vmin=None, vmax=None, need=None, acc=None, hexval=None):
    v = sysfs_read(path)
    return CHECK(name, v, vmin, vmax, need, acc, hexval)
