#!/bin/bash

#   This is a simple script that check if some processes are running based on their 'PID' file in /var/run/
#   If the PID file doesn't exist, then the script returns an error. Though a grace period is allowed after
#   the system booted up to give the applications time to startup (ie : create their PID file).



RET=0
UPGRADE_IN_PROGRESS_FILE=/var/lib/release-manager/upgrade_status
PID_FILE_LIST="otu.pid"
WATCHDOG_DISABLE_FILE="/var/run/stop_watchdog"
#the GRACE_PERIOD is the period (in sec.) allowed for the starting the processes. When it's expired, all processes should be running otherwise the test fails
GRACE_PERIOD=240
ON_OFF_PRESSED=/tmp/OnOff_Button_Pressed
RESCUE_MODE="NO"

DATE=$(date)

IS_SMART_RUNNING=0
[ $(ps aux | grep -v grep | grep -c /usr/bin/smart) -gt 1 ] && IS_SMART_RUNNING=1
[ -f /proc/device-tree/board/rescue-mode ] && [ "$(cat /proc/device-tree/board/rescue-mode)" != "no" ] && RESCUE_MODE="YES"

function check_process() {
    RET=0
    PID_FILE=/var/run/$1

    if [ ! -e $PID_FILE ] ; then
        #A process is missing. Maybe we're still booting. Check uptime to know wheter consider it as an error
        UPTIME=$(cat /proc/uptime | /usr/bin/awk -F. '{print $1}')
        if [ $UPTIME -gt $GRACE_PERIOD ] ; then
            echo $DATE " grace period expired ($UPTIME > $GRACE_PERIOD) and PID file $PID_FILE still doesn't exist."
                RET=1
        fi
    else
        PS_RESULT=
        PID=$(cat $PID_FILE)
        [ ! -z $PID ] && PS_RESULT=$(ps -p $PID | grep $PID)
        DEFUNCT=$(echo $PS_RESULT | grep 'defunct')
        if [ -z "$DEFUNCT" -a ! -z "$PS_RESULT" ] ; then
                RET=0
        else
                RET=1
        fi
    fi
    return $RET
}

function PID_test() {   
    #do not test (and fail)  if an upgrade is in progress (because the upgrade process kills the applications)
    if [ -e $UPGRADE_IN_PROGRESS_FILE ] ; then
        if [ $(cat $UPGRADE_IN_PROGRESS_FILE) == "Started" ]
        then
            return 0
        fi
    fi
    # Do not test if smart is running (rpm operation in progress)
    if [ $IS_SMART_RUNNING -eq 1 ] ; then
        return 0
    fi

    #do not test (and fail)  if a shutdown is in progress
    if [ -e $ON_OFF_PRESSED ] ; then
        return 0
    fi

    # Do not test if in rescue-mode
    if [ "$RESCUE_MODE" == "YES" ] ; then
        return 0
    fi

    RET=0
    for p in $PID_FILE_LIST ; do
        check_process "$p"
        if [ "$?" != "0" ] ; then
            echo $DATE " $p : not running!"
            RET=3
            break
        fi
        done
        return $RET
}

function PID_repair() {
    #repair : if the file $WATCHDOG_DISABLE_FILE exist we consider that everything is fine
    if [ -e $WATCHDOG_DISABLE_FILE ] ; then
        echo $DATE " no reboot triggered because of $WATCHDOG_DISABLE_FILE exists."
        return 0
    else
        return $2
    fi
}

case $1 in
    "test" ) PID_test;;
    "repair" ) PID_repair;;
esac
RET=$?


exit $RET

