import QtQuick 1.1
import "Viavi_Colors.js" as VColor

Item {
    id: id_item
    property int sens: 0
    property int angle : 0
    property int  border_width : 0
    property string color_triangle : "white"
    property string color_rectangle : VColor.cViaviColorGray

    Rectangle
    {
        id: id_rec_parent_triangle
        color: id_item.color_rectangle
        anchors.fill: parent
        smooth: true;

        transform: Rotation{
            id: rotateImagePhoto
            angle: id_item.angle
            origin.x: id_item.width/2
            origin.y: id_item.height/2
        }

        Rectangle {
            id: id_triangle
            anchors.centerIn: parent
            color: id_item.color_triangle
//            rotation:0
//            gradient: Gradient {
//                GradientStop { position: 0.0; color: id_item.color_triangle }
//                GradientStop { position: 0.5; color: "white"  }
//                GradientStop { position: 1.0; color: id_item.color_triangle }

//            }

            border.width: id_item.border_width
            width: id_rec_parent_triangle.width   - 6;
            height: id_rec_parent_triangle.height - 6 ;
            smooth: true;

            transform: Rotation{
                angle: 45
                origin.x: id_triangle.width/2
                origin.y: id_triangle.height/2
            }


        }

        Rectangle {
            id: id_rec_foreground
            y: (id_item.sens == 0) ?  id_rec_parent_triangle.height/2 : 0
            color:  id_rec_parent_triangle.color
            width:  id_rec_parent_triangle.width;
            height: id_rec_parent_triangle.height/2;
            smooth: true;
        }

    }
}

