import QtQuick 1.1
import "Viavi_Colors.js" as VColor

Rectangle {
    id: container

    width: IsMultiEvtGroup ? SxSize + 10 : SxSize
    height: parent.height
    
    color: "transparent"
    
    // return alarm color due to AlarmStatus value
    function getAlarmColor( AlarmStatus ) 
    {
      var alarm_color = VColor.cViaviColorSlmPurple
      
      switch( AlarmStatus )
      {
      case -2:
         alarm_color = VColor.cViaviColorYellow;
         break;
      case -1:
         alarm_color = VColor.cViaviColorRed;
         break;
      case 1:
         alarm_color = VColor.cViaviColorGreen;
         break;
      default:
         alarm_color = VColor.cViaviColorSlmPurple;
         break;
      }
      
      return alarm_color;
    }

    Row{
        anchors.fill: parent

        anchors.topMargin: 10
        anchors.leftMargin: IsMultiEvtGroup ? 5 : 0
        anchors.rightMargin: IsMultiEvtGroup ? 5 : 0

        Repeater {
            id: listDescription

            model: EvtModel
            delegate: Schematic_View_Event_Description_Item { height: container.height }
        }
    }

    Rectangle {
        anchors.horizontalCenter: parent.horizontalCenter
        anchors.top: parent.top
        anchors.topMargin: 23
        
        visible: IsMultiEvtGroup

        radius: 10

        border.color: getAlarmColor(AlarmStatus)
        border.width: 2

        color: "transparent"

        width: parent.width - 2
        height: 54
    }
}
