import QtQuick 1.1
import "Viavi_Colors.js" as VColor
import libpopup 1.0
    
Rectangle {
	id: container
	
	width: 600
	height: 200
	
	clip: true
    
    border.color: VColor.cViaviRealBlack
    border.width: 2
	
	MouseArea {
		id: warningMouseArea
		anchors.fill: parent
        onClicked: pop_up_manager.Close_PopUp_Box()
	}
	
    function get_status_icon( status )
	{
	  var icon = "";
	  
	  if ( status == 1 )
	  {
	    icon = "/acterna/storage/fo/report/Wizard_Pass.png";
	  }
	  else if ( status == (-1) )
	  {
	    icon = "/acterna/storage/fo/report/Wizard_Fail.png";
	  }
	  
	  return icon;
	}
	
    function get_status_txt_color( status )
	{
	  var color = VColor.cViaviRealBlack;
	  
	  if ( status == 1 )
	  {
	    color = VColor.cViaviColorGreen;
	  }
	  else if ( status == (-1) )
	  {
	    color = VColor.cViaviColorRed;
	  }
	  
	  return color;
	}
	
	Image {
		id: infoIcon
		visible: true
		source: get_status_icon( pop_up_manager.status )
		
		anchors.top: container.top
		anchors.topMargin: 20
		
		anchors.left: container.left
		anchors.leftMargin: 20
	}
	
	Text {
		id: statusText
		
		anchors.left: infoIcon.right
		anchors.leftMargin: 10
		anchors.verticalCenter: infoIcon.verticalCenter
	
		wrapMode: Text.Wrap
		text: pop_up_manager.txtStatus
		color: get_status_txt_color( pop_up_manager.status )
		font.pixelSize: 25
		font.bold: true
		font.family: "DejaVu LGC Sans"
		horizontalAlignment: Text.AlignLeft
	}
	
	Text {
		id: textStatusFail
		
		anchors.left: statusText.right
		anchors.leftMargin: 20
		anchors.verticalCenter: infoIcon.verticalCenter
	
		wrapMode: Text.Wrap
		text: pop_up_manager.txtStatusFail
		font.pixelSize: 22
		font.family: "DejaVu LGC Sans"
		horizontalAlignment: Text.AlignLeft
		
		visible: ( pop_up_manager.status == (-1) )
	}
	
	Column {
		anchors.left: container.left
		anchors.leftMargin: 20
		anchors.right: container.right
		anchors.rightMargin: 20
		anchors.top: infoIcon.bottom
		anchors.topMargin: 20
	
		Text {
			id: mainText
			
			anchors.left: parent.left
			anchors.right: parent.right
		
			wrapMode: Text.Wrap
			text: pop_up_manager.txtDisplay
			font.pixelSize: 22
			font.bold: false
			font.family: "DejaVu LGC Sans"
			horizontalAlignment: Text.AlignLeft
		}
		
		
		Text {
			id: subText
			
			anchors.left: parent.left
			anchors.right: parent.right	
			
		
			wrapMode: Text.Wrap
			text: pop_up_manager.subTxtDisplay
			font.pixelSize: 22
			font.bold: false
			font.family: "DejaVu LGC Sans"
			horizontalAlignment: Text.AlignLeft
		}
	}
	
	Text {
		id: exitText
		visible: numberOfButtons == 0
		
		anchors.bottom: parent.bottom
		anchors.bottomMargin: 5
		anchors.left: parent.left
		anchors.leftMargin: 10
		
		font.pixelSize: 16
		color: VColor.cViaviColorBlack
		
		text: pop_up_manager.txtExit
	}
}