<?php
// *********************************************************
// NOTICE: All rights reserved. This material contains the
// trade secrets and confidential information of VIAVI Solutions
// which embody substantial creative effort,
// ideas and expressions. No part of this material may be
// reproduced or transmitted in any form or by any means,
// electronic, mechanical, optical or otherwise, including
// photocopying and recording or in connection with any
// information storage or retrieval system, without
// specific written permission from VIAVI Solutions
// Copyright JDSU 2018. All rights reserved.
// *********************************************************
namespace app\services\maintenance;

use app\util\SMTDto;

/**
 * Otu license list dto
 * 
 * @author Sylvain Desplat
 */
class SMTLicenseListDto extends SMTDto
{
    /**
     * @SMTAttributeInfosAnnotation(classname='app\services\maintenance\SMTLicenseDto',islist='true')
     * @var array app\services\maintenance\SMTLicenseDto
     */    
	protected $licenseList = array();
        
    /**
     * Isu list of software options
     * @var string
     */
    protected $softwareOptions;
    
    /**
     * Set the list of licenses.
     *
     * @param array $licenses
     */
    public function setLicenseList( array &$licenses )
    {
    	$this->licenseList= $licenses;
    }  
    
    /**
     * @param app\services\setup\SMTOnmsiServerDto
     */
    public function addLicense( SMTLicenseDto $licenses)
    {
    	array_push( $this->licenseList, $licenses);
    }
    
    /**
     * Set the software options string.
     *
     * @param string $options
     */
    public function setSoftwareOptions( $options )
    {
    	$this->softwareOptions= $options;
    }  
    
    /**
     * Serialize as Json data the object.<br>
     *
     * @return $objectProperties the object properties serialized as a Json array.
     */
    function getJsonData()
    {
    	$objectProperties = get_object_vars($this);
    	$this->serializeObjectAsJsonData( $objectProperties );
    	return $objectProperties;
    }
    
    /**
     * Returns Dto class name.
     *
     * @return string the dtop class name
     */
    function getDtoClassName()
    {
    	return get_class();
    }   
}
?>