<?php
// *********************************************************
// NOTICE: All rights reserved. This material contains the
// trade secrets and confidential information of JDSU
// which embody substantial creative effort,
// ideas and expressions. No part of this material may be
// reproduced or transmitted in any form or by any means,
// electronic, mechanical, optical or otherwise, including
// photocopying and recording or in connection with any
// information storage or retrieval system, without
// specific written permission from JDSU
// Copyright JDSU 2013. All rights reserved.
// *********************************************************
namespace app\services\autotest;

use app\util\SMTDto;

/**
 * Otu autotest setup dto
 * 
 * @author Sylvain Desplat
 */
class SMTAutotestListDto extends SMTDto
{
    /**
     * @SMTAttributeInfosAnnotation(classname='app\services\autotest\SMTAutotestSetupDto')
     * @var array app\services\autotest\SMTAutotestSetupDto
     */
    protected $autotestSetup;
    
    /**
     * @SMTAttributeInfosAnnotation(classname='app\services\autotest\SMTAutotestDto',islist='true')
     * @var array app\services\autotest\SMTAutotestDto
     */    
    protected $autotestList;        
        
    /**
     * Set the list of autotests.
     *
     * @param array $autotests
     */
    public function setAutotestList( array &$autotests )
    {
    	$this->autotestList = $autotests;
    }
    
    /**
     * Set the list of autotests.
     *
     * @param array $autotests
     */
    public function setAutotestSetup( SMTAutotestSetupDto $autotestSetup )
    {
    	$this->autotestSetup = $autotestSetup;
    }   
    
    /**
     * Serialize as Json data the object.<br>
     *
     * @return $objectProperties the object properties serialized as a Json array.
     */
    function getJsonData()
    {
    	$objectProperties = get_object_vars($this);
    	$this->serializeObjectAsJsonData( $objectProperties );
    	return $objectProperties;
    }
    
    /**
     * Returns Dto class name.
     *
     * @return string the dtop class name
     */
    function getDtoClassName()
    {
    	return get_class();
    }   
}
?>