<?php
// *********************************************************
// NOTICE: All rights reserved. This material contains the
// trade secrets and confidential information of JDSU
// which embody substantial creative effort=
// ideas and expressions. No part of this material may be
// reproduced or transmitted in any form or by any means=
// electronic= mechanical= optical or otherwise= including
// photocopying and recording or in connection with any
// information storage or retrieval system= without
// specific written permission from JDSU
// Copyright JDSU 2013. All rights reserved.
// *********************************************************
namespace app\services\activity;

/**
 * OTU Activity state possible values and methods to handle those states.
 * 
 * @author Sylvain Desplat
 */
class SMTActivityState
{
    /** Unknown */
    const UNKNOWN="UNKNOWN";
    const UNKNOWN_OTU_CODE="UNKNOWN";
    /** None */
    const NONE="NONE";
    const NONE_OTU_CODE="NONE";
    /** Initialization */
    const INITIALIZATION="INITIALIZATION";
    const INITIALIZATION_OTU_CODE="INITIALIZATION";
    /** Tuning */
    const TUNING="TUNING";
    const TUNING_OTU_CODE="TUNING";
    /** Acquisition */
    const ACQUISITION="ACQUISITION";
    const ACQUISITION_OTU_CODE="ACQUISITION";
    /** Localization Acquisition 1 */
    const ACQUISITION_LOC_1="ACQUISITION_LOC_1";
    const ACQUISITION_LOC_1_OTU_CODE="ACQ_Localisation1";
    /** Localization Acquisition 2 */
    const ACQUISITION_LOC_2="ACQUISITION_LOC_2";
    const ACQUISITION_LOC_2_OTU_CODE="ACQ_Localisation2";
    /** Localization Acquisition 3 */
    const ACQUISITION_LOC_3="ACQUISITION_LOC_3";
    const ACQUISITION_LOC_3_OTU_CODE="ACQ_Localisation3";
    /** Analysis */
    const ANALYSIS="ANALYSIS";
    const ANALYSIS_OTU_CODE="ANALYSIS";
    /** Finalization */
    const FINALIZATION="FINALIZATION";
    const FINALIZATION_OTU_CODE="FINALIZATION";
    /** ACquisition Error */
    const ERROR="ERROR";
    const ERROR_OTU_CODE="ERROR";
    /** Completed */
    const COMPLETED="COMPLETED";
    const COMPLETED_OTU_CODE="COMPLETED";
    /** Localization Acquisition using Detection conditions */
    const ACQUISITION_LOC_DET="ACQUISITION_LOC_DET";
    const ACQUISITION_LOC_DET_OTU_CODE="ACQ_LocalisationDetection";
    
    
    /**
     * Whether the given string is an initialization activity state.
     *
     * @param string $activityType
     * @return Whether the given string is an initialization activity state.
     */
    public static function isInitializationState( $activityState )
    {
        return self::INITIALIZATION_OTU_CODE == $activityState;
    }
    
    /**
     * Whether the given string is an acquisition activity state.
     *
     * @param string $activityType
     * @return Whether the given string is an acquisition activity state.
     */
    public static function isAcquisitionState( $activityState )
    {
    	return self::ACQUISITION_OTU_CODE == $activityState || self::ACQUISITION_LOC_DET_OTU_CODE == $activityState;
    }
    
    /**
     * Whether the given string is a finalization activity state.
     *
     * @param string $activityType
     * @return Whether the given string is an analysing activity state.
     */
    public static function isFinalizationState( $activityState )
    {
    	return self::FINALIZATION_OTU_CODE == $activityState;
    }
    
    /**
     * Whether the given string is an analysing activity state.
     *
     * @param string $activityType
     * @return Whether the given string is an analysing activity state.
     */
    public static function isAnalysisState( $activityState )
    {
    	return self::ANALYSIS_OTU_CODE == $activityState;
    }
    
    /**
     * Whether the given string is a complete activity state.
     *
     * @param string $activityType
     * @return Whether the given string is a complete activity state.
     */
    public static function isCompletedState( $activityState )
    {
    	return self::COMPLETED_OTU_CODE == $activityState;
    }
    
    /**
     * Whether the given string is an activity state completed or not set.
     *
     * @param string $activityType
     * @return Whether the given string is a complete activity state or not set.
     */
    public static function isNotRunningState( $activityState )
    {
    	return self::COMPLETED_OTU_CODE == $activityState || self::NONE == $activityState;
    }
    
    /**
     * Whether the given string is an activity type.
     *
     * @param string $activityType
     * @return boolean
     */
    public static function isValidActivityState( $activityState )
    {
    	switch ( $activityState )
    	{
            case self::UNKNOWN:
            case self::NONE:
            case self::ERROR:
        	case self::INITIALIZATION:
    		case self::TUNING:
			case self::ACQUISITION:
			case self::ACQUISITION_LOC_1:
			case self::ACQUISITION_LOC_2:
			case self::ACQUISITION_LOC_3:
			case self::ANALYSIS:
			case self::FINALIZATION:
			case self::COMPLETED:
			case self::ACQUISITION_LOC_DET:
    			return TRUE;
    			break;
    		default:
    			return FALSE;
    			break;
    	}
    }
    
    /**
     * Decode otu activity state codes
     * 
     * @param number $otuCode
     * @return string
     */
    public static function decodeOtuCode( $otuCode )
    {
        switch ( $otuCode )
        {
            case self::UNKNOWN_OTU_CODE:
                return self::UNKNOWN;
                break;
            case self::ERROR_OTU_CODE:
            	return self::ERROR;
            	break;                
            case self::NONE_OTU_CODE:
            	return self::NONE;
            	break;
        	case self::INITIALIZATION_OTU_CODE:
        		return self::INITIALIZATION;
        		break;
    		case self::TUNING_OTU_CODE:
    			return self::TUNING;
    			break;
			case self::ACQUISITION_OTU_CODE:
				return self::ACQUISITION;
				break;
			case self::ACQUISITION_LOC_1_OTU_CODE:
				return self::ACQUISITION_LOC_1;
				break;
			case self::ACQUISITION_LOC_2_OTU_CODE:
				return self::ACQUISITION_LOC_2;
				break;
			case self::ACQUISITION_LOC_3_OTU_CODE:
				return self::ACQUISITION_LOC_3;
				break;				
			case self::ANALYSIS_OTU_CODE:
				return self::ANALYSIS;
				break;
			case self::FINALIZATION_OTU_CODE:
				return self::FINALIZATION;
				break;
			case self::COMPLETED_OTU_CODE:
				return self::COMPLETED;
				break;
			case self::ACQUISITION_LOC_DET_OTU_CODE:
				return self::ACQUISITION_LOC_DET;
				break;				
			default:
			    return self::UNKNOWN;
			break;                								
        }
    }
}
?>
