<?php
// *********************************************************
// NOTICE: All rights reserved. This material contains the
// trade secrets and confidential information of JDSU
// which embody substantial creative effort,
// ideas and expressions. No part of this material may be
// reproduced or transmitted in any form or by any means,
// electronic, mechanical, optical or otherwise, including
// photocopying and recording or in connection with any
// information storage or retrieval system, without
// specific written permission from JDSU
// Copyright JDSU 2012. All rights reserved.
// *********************************************************
namespace app\database;

use app\util\SMTException;

/**
 * Database exceptions
 * 
 * @author Sylvain Desplat
 *
 */
class SMTDatabaseException extends SMTException
{       
    const OPEN_DATABASE_FAILURE = "OPEN_DATABASE_FAILURE";
    const CREATE_DATABASE_MODEL_FAILURE = "CREATE_DATABASE_MODEL_FAILURE";
    const ERROR_APPLY_DATABASE_PATCH_FAILURE = "ERROR_APPLY_DATABASE_PATCH_FAILURE";
    const OPEN_TRANSACTION_FAILURE = "OPEN_TRANSACTION_FAILURE";
    const COMMIT_TRANSACTION_FAILURE = "COMMIT_TRANSACTION_FAILURE";
    const ROLLBACK_TRANSACTION_FAILURE = "ROLLBACK_TRANSACTION_FAILURE";
    const TABLE_NOT_FOUND = "TABLE_NOT_FOUND";
    const DTO_NOT_MAPPED = "DTO_NOT_MAPPED";
    const EXECUTE_STATEMENT_FAILURE = "EXECUTE_STATEMENT_FAILURE";
    
    /**
     *
     * @param string $code error code
     * @param string $message detailed message
     */    
    function __construct( $code = NULL, $message = NULL )
    {
    	parent::__construct( $code, $message );
    }
    
    /**
     * Get error codes label for tracing without error codes.
     *
     * @return string
     */
    public function getErrorLabel()
    {
    	return $this->getErrorCode();
    }
        
    /**
     * Translates status code. If the code is not found, returns an empty string.
     *
     * @param string $code The status code to translate
     *
     * @return string the status message or an empty string if the status couldn't be found.
     */
    public function decodeMessage( $code )
    {
    	$message = MSG_ERROR_OPENING_DATABASE.$code;
    
    	switch( $code )
    	{
    	    case self::OPEN_DATABASE_FAILURE:
    	    	$message = MSG_ERROR_OPENING_DATABASE;
    	    	break;
	    	case self::OPEN_TRANSACTION_FAILURE:
	    		$message = MSG_ERROR_OPENING_TRANSACTION;
	    		break;
    		case self::COMMIT_TRANSACTION_FAILURE:
    			$message = MSG_ERROR_COMMIT_TRANSACTION;
    			break;	    			
			case self::ROLLBACK_TRANSACTION_FAILURE:
				$message = MSG_ERROR_ROLLBACK_TRANSACTION;
				break;
			case self::DTO_NOT_MAPPED:
				$message = MSG_ERROR_DTO_NOT_MAPPED;
				break;    				 
    		case self::TABLE_NOT_FOUND:
    			$message = MSG_ERROR_TABLE_NOT_FOUND;
    			break;
			case self::EXECUTE_STATEMENT_FAILURE:
				$message = MSG_ERROR_EXECUTE_STATEMENT;
				break;
			case self::CREATE_DATABASE_MODEL_FAILURE:
				$message = MSG_ERROR_CREATE_DATABASE_MODEL_FAILURE;
				break;
			case self::ERROR_APPLY_DATABASE_PATCH_FAILURE:
				$message = MSG_ERROR_APPLY_DATABASE_PATCH_FAILURE;
				break;						
					
	    	default:
	    		break;
    	}
    	return $message;
    }
}

?>