#!/bin/bash
# ORE OTU 8KV2 19/12/11
# usage: get-snapshot {<mode [usb/sys/ftp/hd(default)]> {<ftp-ip-addr> {<ftp-username> {<ftp-password>}}}}


RC=0

# test base type
if [ `hexdump -e '1/4 "%d\n"'  /proc/device-tree/board/info-otu-board` == 0 ]
then
    OTU=no
else
    OTU=yes
fi

MODE=$1
/usr/bin/test -z $MODE && MODE=hd

FTP_IPADDR=$2
/usr/bin/test -z $FTP_IPADDR && FTP_IPADDR=10.10.52.31

FTP_USER=$3
/usr/bin/test -z $FTP_USER && FTP_USER=upgrader

FTP_PASSWORD=$4
/usr/bin/test -z $FTP_PASSWORD && FTP_PASSWORD=password

ADD_LOG_FILE="/var/log/get-snapshot.log"


#from etc/init.d/otu_rfs_sync.sh
WATCHED_FILES_LIST="
/etc/shadow
/etc/passwd
/etc/password_removed
/etc/shadow_removed
/etc/hostname
/etc/aliases
/etc/group
/root/.ssh/authorized_keys
/etc/sysconfig/iptables
/etc/sysconfig/ip6tables
/acterna/storage/share/ssu.conf
/acterna/storage/otu/calibration/otu.cal
/acterna/storage/otu/communication/media.cfg
/acterna/storage/otu/communication/webservice.cfg
/acterna/storage/otu/communication/port.cfg
/acterna/storage/otu/communication/superv.cfg
/acterna/storage/otu/communication/snmp.cfg
/acterna/storage/otu/communication/modem.cfg
/acterna/storage/otu/communication/sms.cfg
/acterna/storage/otu/communication/tsc.cfg
/acterna/storage/otu/communication/alerte.cfg
/acterna/storage/otu/communication/interface.cfg
/acterna/storage/otu/communication/topaz.cfg
/acterna/storage/isu/config/cotu_license.xml
/etc/pki/tls/private/smartotu-private.key
/etc/pki/tls/certs/smartotu-certificate.crt
/etc/pki/tls/certs/smartotu-certificate-chain.crt"


# Create a get-snapshot log with various tidbits of information...
echo "--      Base `hostname` (`/sbin/getserialnb`) snapshot (`date`)      --" >  $ADD_LOG_FILE
echo " "                               >> $ADD_LOG_FILE
echo "CMD : ifconfig"                  >> $ADD_LOG_FILE
/sbin/ifconfig				           >> $ADD_LOG_FILE
echo "----------------"                >> $ADD_LOG_FILE
echo "CMD : netstat -natp"             >> $ADD_LOG_FILE
/bin/netstat -natp                     >> $ADD_LOG_FILE
echo "----------------"                >> $ADD_LOG_FILE
echo "CMD : runlevel `/sbin/runlevel`" >> $ADD_LOG_FILE
echo "----------------"                >> $ADD_LOG_FILE
echo "CMD : ps -axfl"		           >> $ADD_LOG_FILE
ps -axfl	                           >> $ADD_LOG_FILE
echo "----------------"                >> $ADD_LOG_FILE
echo "CMD : set"                       >> $ADD_LOG_FILE
set                                    >> $ADD_LOG_FILE
echo "----------------"                >> $ADD_LOG_FILE
echo "CMD : fw_printenv" 			   >> $ADD_LOG_FILE
fw_printenv 			               >> $ADD_LOG_FILE
echo "----------------"                >> $ADD_LOG_FILE
echo "CMD : df"                        >> $ADD_LOG_FILE
/bin/df                                >> $ADD_LOG_FILE
echo "----------------"                >> $ADD_LOG_FILE
echo "CMD : mount"                     >> $ADD_LOG_FILE
mount                                  >> $ADD_LOG_FILE
echo "----------------"                >> $ADD_LOG_FILE
echo "CMD : uptime"                    >> $ADD_LOG_FILE
/usr/bin/uptime   			           >> $ADD_LOG_FILE
if [ $OTU = "yes" ]
then
	echo "----------------"            		>> $ADD_LOG_FILE
	echo "CMD : ls /otu/alarm/ |wc -w" 		>> $ADD_LOG_FILE
	ls /otu/alarm/ |wc -w		       		>> $ADD_LOG_FILE

	echo "----------------"            		>> $ADD_LOG_FILE
	echo "CMD : memory info"		 		>> $ADD_LOG_FILE
	DATE=`date`
	MEM_FREE=`cat /proc/meminfo |grep "MemFree:"|awk '{ print $2 }'`
	MEM_CACHED=`cat /proc/meminfo |grep "^Cached:"|awk '{ print $2 }'`
	MEM_X=`ps -axfl|grep "X :0"|grep -v "grep"|awk '{ print $7 }'`
	echo $DATE" - MEM:"$MEM_FREE" "$MEM_CACHED" - X:"$MEM_X >> $ADD_LOG_FILE

	echo "----------------"            		>> $ADD_LOG_FILE
	echo "CMD : CRC check"			 		>> $ADD_LOG_FILE
	#/sbin/create_crcfile.sh /otu/crcfile.cur
	#/sbin/compare_crcfile.sh /etc/acterna/crcfile /otu/crcfile.cur /otu/cmpfile
	#cat /otu/cmpfile | grep -v 8.4 			>> $ADD_LOG_FILE
	echo "Not yet implemented !"			>> $ADD_LOG_FILE

	echo "----------------"            				>> $ADD_LOG_FILE
	echo "CMD : cat /sys/platform/uts_scan/scan"	>> $ADD_LOG_FILE
	cat /sys/platform/uts_scan/scan    				>> $ADD_LOG_FILE

	echo "----------------"            	>> $ADD_LOG_FILE
	echo "CMD : getinfoversion Otu"		>> $ADD_LOG_FILE
	/sbin/getinfoversion Otu	       	>> $ADD_LOG_FILE
	echo " "                            >> $ADD_LOG_FILE
	echo "CMD : getinfoversion -r Otu"	>> $ADD_LOG_FILE
	/sbin/getinfoversion -r Otu	   		>> $ADD_LOG_FILE
	echo "" 	>> $ADD_LOG_FILE
	
	echo "---------------- options"            				    >> $ADD_LOG_FILE
	echo "CMD : upg_environment g Enhanced_Security"	>> $ADD_LOG_FILE
	upg_environment g Enhanced_Security   		        >> $ADD_LOG_FILE
	echo "CMD : upg_environment g rescue_mode"	        >> $ADD_LOG_FILE
	upg_environment g rescue_mode   		            >> $ADD_LOG_FILE
	echo "CMD : upg_environment g upgUpgradeType"	    >> $ADD_LOG_FILE
	upg_environment g upgUpgradeType   		            >> $ADD_LOG_FILE
	echo "CMD : upg_environment g sysStartupForced"	    >> $ADD_LOG_FILE
	upg_environment g sysStartupForced   		        >> $ADD_LOG_FILE
	echo "CMD : upg_environment g use_both_fs"	        >> $ADD_LOG_FILE
	upg_environment g use_both_fs   		            >> $ADD_LOG_FILE
	echo "" 	>> $ADD_LOG_FILE
	
	echo "---------------- uptime loadavg"              >> $ADD_LOG_FILE
	# uptime Uptimes.Up1Min Uptimes.Up5Min Uptimes.Up15Min
	echo "CMD : cat /proc/loadavg"	                        >> $ADD_LOG_FILE
	cat /proc/loadavg    				                >> $ADD_LOG_FILE
	echo "" 	>> $ADD_LOG_FILE
	
    echo "---------------- fds"     >> $ADD_LOG_FILE
    # all open fds
	echo "CMD : lsof | wc -l" 		>> $ADD_LOG_FILE
	lsof | wc -l		       		>> $ADD_LOG_FILE
	# fds in Kernel
	echo "CMD : sysctl fs.file-nr" 	>> $ADD_LOG_FILE
	sysctl fs.file-nr		       	>> $ADD_LOG_FILE
	echo "" 	>> $ADD_LOG_FILE
	
	echo "---------------- temp"            				>> $ADD_LOG_FILE
	# Cpu_Temperature 
	echo "CMD : cat /sys/class/hwmon/hwmon0/temp1_input"	>> $ADD_LOG_FILE
	cat /sys/class/hwmon/hwmon0/temp1_input    				>> $ADD_LOG_FILE
    # Board_Temperature
    echo "CMD : cat /sys/class/hwmon/hwmon1/temp1_input"	>> $ADD_LOG_FILE
	cat /sys/class/hwmon/hwmon1/temp1_input    				>> $ADD_LOG_FILE
    # EOTDR_Temperature
    echo "CMD : cat /sys/platform/adc_temp_ana/value"	    >> $ADD_LOG_FILE
	cat /sys/platform/adc_temp_ana/value    				>> $ADD_LOG_FILE
	echo "" 	>> $ADD_LOG_FILE
	
	echo "---------------- local mode?"            				            >> $ADD_LOG_FILE
	if [ -f "/var/run/dhcpd_otu_local.pid" ]
    then
        echo "/var/run/dhcpd_otu_local.pid found --> Local mode"            >> $ADD_LOG_FILE
    else
        echo "/var/run/dhcpd_otu_local.pid not found --> Not in local mode" >> $ADD_LOG_FILE
    fi
    echo "" 	>> $ADD_LOG_FILE
	
    echo "---------------- LEDs"            				        >> $ADD_LOG_FILE
	for i in "/sys/class/leds/led_"*
    do
    echo "CMD : cat $i/brightness"	        >> $ADD_LOG_FILE
    cat $i/brightness    				    >> $ADD_LOG_FILE
    done
    echo "" 	>> $ADD_LOG_FILE
	
    echo "---------------- board"            				        >> $ADD_LOG_FILE
	echo "CMD : hexdump  /proc/device-tree/board/info-otu-board"    >> $ADD_LOG_FILE
	hexdump  /proc/device-tree/board/info-otu-board      	        >> $ADD_LOG_FILE
	echo "CMD : hexdump  /proc/device-tree/board/board-version"     >> $ADD_LOG_FILE
	hexdump  /proc/device-tree/board/board-version      	        >> $ADD_LOG_FILE
	echo "CMD : hexdump  /proc/device-tree/board/backplane-id"      >> $ADD_LOG_FILE
	hexdump  /proc/device-tree/board/backplane-id      	            >> $ADD_LOG_FILE
	echo "" 	>> $ADD_LOG_FILE
	
    echo "---------------- platform"            		    >> $ADD_LOG_FILE
	# other stuff
	echo "CMD : cat /sys/platform/board_fpga/reg_version"	>> $ADD_LOG_FILE
	cat /sys/platform/board_fpga/reg_version    			>> $ADD_LOG_FILE
	echo "CMD : cat /sys/platform/board_fpga/reg_date"	    >> $ADD_LOG_FILE
	cat /sys/platform/board_fpga/reg_date    				>> $ADD_LOG_FILE
	echo "CMD : cat /sys/platform/board_fpga/hw_ver"	    >> $ADD_LOG_FILE
	cat /sys/platform/board_fpga/hw_ver    				    >> $ADD_LOG_FILE
	echo "CMD : cat /sys/platform/hwrev/value"	            >> $ADD_LOG_FILE
	cat /sys/platform/hwrev/value    				        >> $ADD_LOG_FILE
	echo "CMD : cat /sys/platform/pwr_front_left/value"	    >> $ADD_LOG_FILE
	cat /sys/platform/pwr_front_left/value    				>> $ADD_LOG_FILE
	echo "CMD : cat /sys/platform/pwr_front_right/value"	>> $ADD_LOG_FILE
	cat /sys/platform/pwr_front_right/value    				>> $ADD_LOG_FILE
	echo "CMD : cat /sys/platform/pwr_rear_left/value"	    >> $ADD_LOG_FILE
	cat /sys/platform/pwr_rear_left/value    				>> $ADD_LOG_FILE
	echo "CMD : cat /sys/platform/pwr_rear_right/value"	    >> $ADD_LOG_FILE
	cat /sys/platform/pwr_rear_right/value    				>> $ADD_LOG_FILE
	echo "CMD : cat /sys/platform/pwr_otu_valid/value"	    >> $ADD_LOG_FILE
    cat /sys/platform/pwr_otu_valid/value    				>> $ADD_LOG_FILE
	echo "CMD : cat /sys/platform/pwr_usb_valid/value"	    >> $ADD_LOG_FILE
	cat /sys/platform/pwr_usb_valid/value    				>> $ADD_LOG_FILE
	echo "" 	>> $ADD_LOG_FILE
	
    echo "---------------- eth0 stats"          >> $ADD_LOG_FILE
    for i in "/sys/class/net/eth0/statistics/"*
    do
    echo "CMD : cat $i"	        >> $ADD_LOG_FILE
    cat $i    				    >> $ADD_LOG_FILE
    done
    echo "" 	>> $ADD_LOG_FILE
    
    echo "------------- rpm list"	    >> $ADD_LOG_FILE
	rpm -qa | sort     				>> $ADD_LOG_FILE
	echo "" 	>> $ADD_LOG_FILE
	
	echo "------------- top"	    >> $ADD_LOG_FILE
	top -n 1     				>> $ADD_LOG_FILE
	echo "" 	>> $ADD_LOG_FILE
	
	echo "------------- list /dev/JD*"	    >> $ADD_LOG_FILE
	ls -al /dev/JD*     				    >> $ADD_LOG_FILE
	echo "" 	>> $ADD_LOG_FILE
    
    echo "------------- CMD: fdisk -l /dev/mmcblk0"	    >> $ADD_LOG_FILE
	fdisk -l /dev/mmcblk0     				            >> $ADD_LOG_FILE
	echo "" 	>> $ADD_LOG_FILE
     
    echo "------------- CMD: /usr/lib/jdsu/scripts/Internal_Memory_Mngt.sh CHECKHD"	    >> $ADD_LOG_FILE
	/usr/lib/jdsu/scripts/Internal_Memory_Mngt.sh CHECKHD     				            >> $ADD_LOG_FILE
	echo "" 	>> $ADD_LOG_FILE
	

	echo "------------- CMD: cat /etc/release/backup/*"	    >> $ADD_LOG_FILE
	cat /etc/release/backup/*     				            >> $ADD_LOG_FILE
	echo "" 	>> $ADD_LOG_FILE


	
    echo "---------------- Check File Synch"            		   >> $ADD_LOG_FILE
	for i in $WATCHED_FILES_LIST
    do
        if [ ! -f /mnt/fs/unused_part$i ]
        then
            echo "File /mnt/fs/unused_part$i does not exist"	    >> $ADD_LOG_FILE
        else
            echo "CMD: diff -u $i /mnt/fs/unused_part$i"	        >> $ADD_LOG_FILE
            diff -u $i /mnt/fs/unused_part$i                        >> $ADD_LOG_FILE
        fi
    done
    echo "" 	>> $ADD_LOG_FILE

	
fi


echo "Creating MTS snapshot for unit #`/sbin/getserialnb`"
TAR_FILE=get-snapshot.`/sbin/getserialnb`.$(date +%Y%m%d%H%M).tar.gz

logger "MTS/TB8000: get "$TAR_FILE" ("%MODE")"

if [ $MODE != "sys" ]
then
   LOGINRAM=`df | grep ram0 | wc -l`
else
   LOGINRAM=1
fi

if [ $LOGINRAM = 1 ]
then
   tar -hzcvf /tmp/$TAR_FILE /etc/acterna/*.ver /acterna/release/bin/*.ver /acterna/storage/isu/*.cfg /var/log /acterna/storage/share 2>&1 | grep -v "Removing leading"
   if [ `/bin/df | grep harddisk |wc -l` != 0 ]
   then
      DF=`/bin/df | grep harddisk | awk '{ print $5 }' | cut -f1 -d '%'`
   else
      DF=0
   fi
   if [ ! -f /tmp/$TAR_FILE ]
   then
     	RC=1
   fi
else
   if [ $OTU = "yes" ]
   then
      tar -hzcvf /acterna/user/harddisk/$TAR_FILE /etc/acterna/*.ver /acterna/release/bin/*.ver /acterna/storage/isu/*.cfg /var/log /acterna/storage/share /otu/config/measure /otu/log /otu/autotest /acterna/storage/otu /mnt/fs/unused_part/acterna/release/bin/*.ver /mnt/fs/unused_part/acterna/storage/isu/*.cfg /mnt/fs/unused_part/acterna/storage/share  /mnt/fs/unused_part/acterna/storage/otu --exclude='*.xsvf' --exclude='*.jbc' --exclude='*.bin' --exclude='*.png' --exclude='*.xpm' 2>&1 | grep -v "Removing leading"
#      tar -hzcvf /acterna/user/harddisk/$TAR_FILE /etc/acterna/*.ver /acterna/release/bin/*.ver /acterna/storage/isu/*.cfg /var/log /acterna/storage/share /otu/config/measure /otu/log /acterna/storage/otu
   else
      tar -hzcvf /acterna/user/harddisk/$TAR_FILE /etc/acterna/*.ver /acterna/release/bin/*.ver /acterna/storage/isu/*.cfg /var/log /acterna/storage/share 2>&1 | grep -v "Removing leading"
   fi
   if [ ! -f /acterna/user/harddisk/$TAR_FILE ]
   then
    	RC=1
   fi
   DF=`/bin/df | grep -w "/tmp" | awk '{ print $5 }' | cut -f1 -d '%'`
fi

if [ "$DF" = "100" ]
then
   echo "no space left"
   RC=1
else
   if [ "$MODE" = "usb" ]
   then
      if [ $LOGINRAM = 1 ]
      then
         echo "Copy snapshot to usb flash memory"
         cp /tmp/$TAR_FILE /acterna/user/usbflash/.
		 let RC=RC+$?
      else
         echo "Copy snapshot to usb flash memory"
         cp /acterna/user/harddisk/$TAR_FILE /acterna/user/usbflash/.
		 let RC=RC+$?
      fi
   fi

   if [ $MODE = "hd" ]
   then
      if [ $LOGINRAM = 1 ]
      then
         echo "Copy snapshot to harddisk"
         cp /tmp/$TAR_FILE /acterna/user/harddisk/.
		 let RC=RC+$?
      fi
   fi

   if [ $MODE = "ftp" ]
   then
      echo "Uploading snapshot to IP address '$FTP_IPADDR' with username '$FTP_USER' and password '$FTP_PASSWORD'"
      echo "with username '$FTP_USER' and password '$FTP_PASSWORD'"
      echo user                          > /tmp/ftpLogin
      echo $FTP_USER $FTP_PASSWORD      >> /tmp/ftpLogin
      echo binary                       >> /tmp/ftpLogin
      if [ $LOGINRAM = 1 ]
      then
         echo put /tmp/$TAR_FILE $TAR_FILE >> /tmp/ftpLogin
      else
         echo put /acterna/user/harddisk/$TAR_FILE $TAR_FILE >> /tmp/ftpLogin
      fi
      ftp -n -v $FTP_IPADDR < /tmp/ftpLogin
      let RC=RC+$?
   fi

   # Cleanup temporary files
   rm -f /tmp/ftpLogin
   if [ $MODE != "sys" ]
   then
      rm -rf /tmp/$TAR_FILE
   else
      mv /tmp/$TAR_FILE /tmp/snapshot
   fi
   rm -f $ADD_LOG_FILE
fi

# return 0 if success, positive value otherwise
exit $RC
