import os
from lxml import etree

def filter(release):
    for f in os.listdir("/acterna/storage/isu/config/"):
        if f.endswith("_license.xml"):
            licence = etree.parse("/acterna/storage/isu/config/" + f)
            if len(licence.xpath("//key[@name='CHINESE']")) > 0:
                print("Find CHINESE Licence")
                if int(release.xpath("content/item[@name='File System']/@version")[0].split(".")[0].replace("V","")) < 10:
                    if int(release.xpath("content/item[@name='File System']/@version")[0].split(".")[1]) < 80:
                        print("Downgrade to version File System < V10.80 Forbiden")
                        return False
    return True
