<?php
// *********************************************************
// NOTICE: All rights reserved. This material contains the
// trade secrets and confidential information of VIAVI Solutions
// which embody substantial creative effort,
// ideas and expressions. No part of this material may be
// reproduced or transmitted in any form or by any means,
// electronic, mechanical, optical or otherwise, including
// photocopying and recording or in connection with any
// information storage or retrieval system, without
// specific written permission from VIAVI Solutions
// Copyright VIAVI Solutions 2019. All rights reserved.
// *********************************************************
namespace app\services\setup;

use app\http\SMTISerializable;

/**
 * Dto with Rotau infos
 * 
 * @author Sylvain Desplat
 */
class SMTRotauDto extends SMTSwitchDto implements SMTISerializable
{
    /**
     * @var string
     */
    protected $rotauIp;
    /**
     * @var string
     */
	protected $device;

	public function setDevice($device)
	{
		$this->device= $device;
	}
	
	public function setRotauIp($rotauIp)
	{
		$this->rotauIp= $rotauIp;
	}
	
	public function getDevice()
	{
		return $this->device;
	}
	
	public function getRotauIp()
	{
		return $this->rotauIp;
	}
	
    /**
     * Serialize as Json data the user object.<br>
     *
     * @return $objectProperties the object properties serialized as a Json string.
     */
    function getJsonData()
    {
    	$objectProperties = get_object_vars($this);
    	$this->serializeObjectAsJsonData( $objectProperties );
    	return $objectProperties;
    }
    
    /**
     * Returns Dto class name.
     *
     * @return string the dtop class name
     */
    function getDtoClassName()
    {
    	return get_class();
    }
    
    /**
     * Create the Dto from a Json Dto in an array
     *
     * @param array $json_array json data in an array
     *
     * @return \app\services\setup\SMTSwitchDto
     */
    static function getInstance( array &$json_array )
    {
    	return self::forge( get_class(), $json_array );
    }
    
    /**
     * Serialize object stored in session
     *
     * @return multitype:string
     */
    public function __sleep()
    {
    	return $this->getSerializableProperties();
    }
    
    /**
     * Returns the serializable properties of the object.
     *
     * @see \app\http\SMTISerializable::getSerializableProperties()
     */
    public function getSerializableProperties()
    {
    	$objectProperties = get_object_vars($this);
    	return array_keys( $objectProperties );
    }
    
    /**
     * Deserialize object.
     */
    public function __wakeup()
    {
    }    
}
?>