<?php
// *********************************************************
// NOTICE: All rights reserved. This material contains the
// trade secrets and confidential information of JDSU
// which embody substantial creative effort,
// ideas and expressions. No part of this material may be
// reproduced or transmitted in any form or by any means,
// electronic, mechanical, optical or otherwise, including
// photocopying and recording or in connection with any
// information storage or retrieval system, without
// specific written permission from JDSU
// Copyright JDSU 2013. All rights reserved.
// *********************************************************
namespace app\events\alarms;



use app\services\alarm\SMTAttenuationOpticalAlarmDto;



use app\events\SMTEventDto;
use app\services\alarm\SMTPeakOpticalAlarmDto;

/**
 * Optical Alarm event: limited to attenuation alarm. If ORL, fiber length were monitored, new properties alarmORL, alarmFiberLength should be added.
 * 
 * @author Sylvain Desplat
 */
class SMTOpticalAlarmMessageEventDto extends SMTEventDto
{           
    
    /**
     * ALARM_UPDATE event key
     * 
     * @var string
     */
    const OPTICAL_ALARM_UPDATE="OPTICAL_ALARM_UPDATE";
    
    /**
     * If attenuation optical alarm dto is NULL, notify that a refresh of all optical alarms should be performed.
     * 
     * @SMTAttributeInfosAnnotation(classname='app\services\alarm\SMTAttenuationOpticalAlarmDto')
     * @var SMTAttenuationOpticalAlarmDto
     */
    protected $attenuationAlarm = NULL; 
    
    
    /**
     * @SMTAttributeInfosAnnotation(classname='app\services\alarm\SMTPeakOpticalAlarmDto',islist='true')
     * @var array app\services\alarm\SMTPeakOpticalAlarmDto
     */
    protected $peakOpticalAlarm = array();
    
    /**
     * 
     * @return SMTAttenuationOpticalAlarmDto
     */
    function getAttenuationAlarm()
    {
    	return $this->attenuationAlarm;
    }    
    
    /**
     * Update optical alarm texts according to current user langage.
     */
    function updateTranslations()
    {
        if ( $this->attenuationAlarm != NULL )
        {
            $this->attenuationAlarm->updateSpecificProblemText();
        }
    }
    
    /**
     * 
     * @param SMTAttenuationOpticalAlarmDto $alarm
     */
    function setAttenuationAlarm( SMTAttenuationOpticalAlarmDto $attenuationAlarm )
    {
    	if ($attenuationAlarm != NULL)
    	{
	    	$this->attenuationAlarm = $attenuationAlarm;
    		$this->setId( $attenuationAlarm->getId() );
    	}
    }    
    
    /**
     * @param SMTPeakOpticalAlarmDto $peakAlarm
     */
    public function addPeakOpticalAlarm( SMTPeakOpticalAlarmDto $peakAlarm )
    {
    	if ( $peakAlarm != NULL)
    	{
    		array_push( $this->peakOpticalAlarm, $peakAlarm);
    		$this->setId( empty($this->id)? $peakAlarm->getId() : $this->id."@@".$peakAlarm->getId());
    	}
    }
    
    /**
     * @param SMTPeakOpticalAlarmDto $peakAlarm
     */
    public function getPeakOpticalAlarms()
    {
    	return $this->peakOpticalAlarm;
    }  
    
    /**
     * Serialize as Json data the user object.<br>
     *
     * @return $objectProperties the object properties serialized as a Json string.
     */
    function getJsonData()
    {
    	$objectProperties = get_object_vars($this);
    	$this->serializeObjectAsJsonData( $objectProperties );
    	return $objectProperties;
    }
    
    /**
     * Returns Dto class name.
     *
     * @return string the dtop class name
     */
    function getDtoClassName()
    {
    	return get_class();
    }        
    
    /**
     * Create the Dto from a Json Dto in an array
     *
     * @param array $json_array json data in an array
     *
     * @return \app\services\monitoring\SMTLinkTestDto
     */
    static function getInstance( array &$json_array )
    {
    	return self::forge( get_class(), $json_array );
    }
}

?>