<?php
// *********************************************************
// NOTICE: All rights reserved. This material contains the
// trade secrets and confidential information of JDSU
// which embody substantial creative effort,
// ideas and expressions. No part of this material may be
// reproduced or transmitted in any form or by any means,
// electronic, mechanical, optical or otherwise, including
// photocopying and recording or in connection with any
// information storage or retrieval system, without
// specific written permission from JDSU
// Copyright JDSU 2013. All rights reserved.
// *********************************************************
namespace app\database;

use app\util\SMTIOException;
use app\util\SMTLogger;

/**
 * Utility class for database
 * 
 * @author Sylvain Desplat
 */
class SMTDatabaseUtil
{
    /**
     * Directory for database file
     * @var string
     */
    const CUSTOM_SMARTOTU_DATABASE_DIR = "/otu/smartOTU/database";
    
    /**
     * OTDR default file name on session directory
     * 
     * @param $portNumber
     * @param $operationId 
     * @var string
     */
    const DEFAULT_DATABASE_FILE_NAME = "smartotu.db";
    
    
    /**
     * Returns the smartOTU database file name
     * @return string
     */
    public static function getDatabaseFileName()
    {
        return self::CUSTOM_SMARTOTU_DATABASE_DIR."/".self::DEFAULT_DATABASE_FILE_NAME;        
    }

    /**
     * Create the database file and its directory if it doesn't exist.
     * Returns whether a new empty database file was created.
     *
     * @return boolean whether a new empty database file was created.
     */
    public static function createDatabaseFileIfNeeded()
    {
        $createDatabaseFile = FALSE;
        $databaseDirectory = self::CUSTOM_SMARTOTU_DATABASE_DIR;
        if ( !is_dir( $databaseDirectory ) )
        {
            mkdir( $databaseDirectory, 0777);
        }
        $databaseFilename = $databaseDirectory."/".self::DEFAULT_DATABASE_FILE_NAME;
        
        if ( !is_file( $databaseFilename ) )
        {
            SMTLogger::getInstance()->trace( sprintf("Create new database: %s.", $databaseFilename ), SMTLogger::INFO );
            $handle = fopen( $databaseFilename, "x+");            
            if ( $handle === FALSE )
            {
                SMTLogger::getInstance()->trace( sprintf("Failed to create new database: %s.", $databaseFilename ), SMTLogger::ERROR, __FILE__,__METHOD__,__LINE__);
		        throw new SMTIOException( SMTIOException::COULD_NOT_CREATE_FILE, $databaseFilename );
            }
            else
            {
                $createDatabaseFile = TRUE;
                fclose($handle);
            }
        }
        else
        {
            SMTLogger::getInstance()->trace( sprintf("Database file %s exists.", $databaseFilename ),SMTLogger::DEBUG, __FILE__,__METHOD__,__LINE__ );
        }
        return $createDatabaseFile;
    }    
}

?>