<?php
// *********************************************************
// NOTICE: All rights reserved. This material contains the
// trade secrets and confidential information of JDSU
// which embody substantial creative effort,
// ideas and expressions. No part of this material may be
// reproduced or transmitted in any form or by any means,
// electronic, mechanical, optical or otherwise, including
// photocopying and recording or in connection with any
// information storage or retrieval system, without
// specific written permission from JDSU
// Copyright JDSU 2012. All rights reserved.
// *********************************************************
namespace app;

use app\services\SMTIService;

use app\http\SMTHttpResponse;
use app\http\SMTContext;
use app\parser\SMTOtuSocketManager;

/**
 * include autoloader
 */
require_once 'lib/restler.php';

/**
 * Application main class
 * 
 * 
 * 
 * @author sdesplat
 */
class SMTApplication
{
    /**
     * HTTP request context
     * @var SMTContext
     */
    protected $context = NULL;
        	
	/**
	 * Start processing of the request
	 */
	public function runRouter()
	{
		$controller = $this->createController();
		$controller->initRouter();
		$controller->runRouter();
	}
	
	/**
	 *
	 * @return \app\http\SMTContext
	 */
	public function getContext()
	{
		return $this->context;
	}	
	
	/**
	 *
	 * @return \app\SMTController
	 */
	private function createController()
	{
		return new SMTController( $this->context );
	}	
	
	/**
	 * Init or restore the session and init the context.
	 * Check the socket connection to the Otu parser if needed.
	 * 
	 * @param $checkOtuAvailable boolean TRUE by default: whether the connection to the OTU parser can be verified. Never check OTU connection when GWT client application is not yet initialized (json error messages must be displayed by the GWT client)
	 * @see index.php, app.php
	 */
	public function init( $checkOtuAvailable = TRUE )
	{	    	    	    	    
        //init context and session
        $this->context = new SMTContext();

        //Check the connection to the OTU parser. 
        //WARNING: Never check OTU connection when GWT client application is not yet initialized (json error messages must be displayed by the GWT client)        
        if ( $checkOtuAvailable  )
        {
            try 
            {
        	    SMTOtuSocketManager::checkOTUAvailable( $this->context);
            }
        	catch( \Exception $e )
        	{
        	    //OTU not availble => degraded mode
        	    //In degraded mode: only allow access to security and maintenance services,
        	    //Accept also alarms sent by OTU before the end of its startup.
        	    //In all other cases, return immediatly the error
        	    if ( !self::acceptRequestInDegradedMode() && !self::acceptSendAlarmRequest() )
        	    {
                	//handle exception and send back exception directly to client: no connection to OTU application
                	//WARNING: die on exception if a problem occurs:
                	SMTHttpResponse::handleException( $e, $this->context );
        	    }
        	}
        }                
	}	
	
	/**
	 * In degraded mode, requests are allowed to access the security service and the maintenance service,
     * 
	 * @return boolean whether the request is allowed to be processed in degraded mode.
	 */
	static function acceptRequestInDegradedMode()
	{
	    $accepRequest = FALSE;
	    if (  strpos( $_SERVER["REQUEST_URI"], "/".SMTIService::SECURITY_SERVICE ) !== FALSE || strpos( $_SERVER["REQUEST_URI"], "/".SMTIService::MAINTENANCE_SERVICE ) !== FALSE )
	    {
	        $accepRequest = TRUE;
	    }
	    return $accepRequest;
	}
	
	/**
	 * Always accept sendalarm request coming from OTU
	 *
	 * @return boolean whether the sendalarm request is allowed to be processed whatever the mode.
	 */
	static function acceptSendAlarmRequest()
	{
		$accepRequest = FALSE;
		if ( ( strpos( $_SERVER["REQUEST_URI"], "/".SMTIService::ALARM_SERVICE ) !== FALSE ) && $_SERVER["REQUEST_METHOD"] == 'POST')
		{
			$accepRequest = TRUE;
		}
		return $accepRequest;
	}
	
	
	/**
	 * Set OTU reboot flag and close the current session.
	 * 
	 * @param SMTContext $context
	 */
	public static function handleOTUReboot( SMTContext $context )
	{
	    //set reboot flag
	    $context->setOTUReboot();
	    
	    //close the user session
	    $context->closeSession();
	}

}
?>