from jdsu.evm import *
from jdsu.diag import *
import jdsu.mts as mts
import hashlib
import os
import os.path

eMMC_Blk = {
    "mts4000ng": 0,
    "mts2000ng": 0,
    "mts1000":   0,
    "eotdrv2":   1
}

@DIAG("Test eMMC")
def t_emmc(cmd):
    blk = eMMC_Blk[mts.getMachineName()]

    md5buf  = -1
    md5buf2 = 0

    with open("/dev/urandom","rb") as f:
        buf = f.read(16*1024)

    md5buf = hashlib.md5(buf).hexdigest()
    print_info("# write and re-read random 16kB buffer in eMMC MD5=%s"%(md5buf))

    if(os.path.exists("/dev/mmcblk%ip7"%blk)):
        with open("/dev/mmcblk%ip7"%blk,"wb") as f:
            f.write(buf)
    else:
        if(os.path.exists("/dev/mmcblk%i"%blk)):
            with open("/dev/mmcblk%i"%blk,"wb") as f:
                # skip to end of eMMC
                f.seek(1777*1024*1024)
                f.write(buf)
        else:
            print_error("# eMMC not detected")
            return False

    if(os.path.exists("/dev/mmcblk%ip7"%blk)):
        with open("/dev/mmcblk%ip7"%blk,"rb") as f:
            buf2 = f.read(16*1024)
    else:
        with open("/dev/mmcblk%i"%blk,"rb") as f:
            # skip to end of eMMC
            f.seek(1777*1024*1024)
            buf2 = f.read(16*1024)

    md5buf2 = hashlib.md5(buf).hexdigest()
    print_info("# Verified MD5=%s"%(md5buf2))

    if (md5buf2 != md5buf):
        print_error("# eMMC Read/Write failed")
        return False

    return True
