#!/bin/bash

usage () {
        echo "usage:  $0 <<file_path>> <<[ssl_cert, ssl_chain-cert, ssl_key, license] >>"
        exit 1
}

echo "copy file $1 for $2" 

success=1

if [[ -s "$1" ]]; then
   case "$2" in
      ssl_cert)
      file="/etc/pki/tls/certs/smartotu-certificate.crt" ;;
   
      ssl_chain-cert)
      file="/etc/pki/tls/certs/smartotu-certificate-chain.crt" ;;
      
      ssl_key)
      file="/etc/pki/tls/private/smartotu-private.key" ;;
      
      license)
      file="/acterna/user/harddisk/Licence.lic" ;;
               
      *)
      echo "bad option: $2"
      usage ;;
   
   esac
      
  echo "copy file $1 into $file"
  
  cp -rf "$1" $file 
  success=`echo $?`
  
  chmod 644 $file     

  [[ -f "$1" ]] && rm -f "$1"
  
else
  echo "file not found: $1"
  usage
fi

echo "result: $success"

exit $success
