#!/bin/bash
#set -x

function Disconnect
{
   # on supprime la mmorisation de la connexion avant de faire tomber la connexion ssh afin que le processus dtach qui surveille 
   # la connexion n'envoie pas un message d"erreur erron indiquant un problme rseau
   $uboot_environment_set MtsAnywhere
   rm -f /tmp/param_mts*
   
   # deconnexion, on essaye les diffrents chemins jusqu' aboutir
   kill $(ps aux | grep ssh | grep MAW_Connection | grep param_mts | tr -s " " | cut -d " " -f 2)

   RetCode=255
   # port 443 via proxy
   if [ "$ViaProxy" != "" ]
      then
      $ssh -i /root/.ssh/kpriv_mts -o StrictHostKeyChecking=no -o UserKnownHostsFile=/dev/null  -o "ProxyCommand=$basedir/ssh-proxy.sh -s $ssh $ViaProxy %h %p" MAW_Authentication@$SP_SSH1 -p 443 AskConnectionMTS DISCONNECT $TypCnx $MtsIdent $MtsLic $Media
      RetCode=$?
   fi

   # port 443 direct
   if [ "$RetCode" != 0 ]
      then
      $ssh -i /root/.ssh/kpriv_mts -o StrictHostKeyChecking=no -o UserKnownHostsFile=/dev/null  -o "ProxyCommand=$basedir/ssh-proxy.sh -s $ssh %h %p" MAW_Authentication@$SP_SSH1 -p 443 AskConnectionMTS DISCONNECT $TypCnx $MtsIdent $MtsLic $Media
      RetCode=$?
   fi
   
   # port 22 direct
   if [ "$RetCode" != 0 ]
      then
      $ssh -i /root/.ssh/kpriv_mts -o StrictHostKeyChecking=no -o UserKnownHostsFile=/dev/null  -o "ProxyCommand=$basedir/ssh-proxy.sh -s $ssh %h %p" MAW_Authentication@$SP_SSH1 -p 22 AskConnectionMTS DISCONNECT $TypCnx $MtsIdent $MtsLic $Media
      RetCode=$?
   fi
   
}

function Warning_Connection_Failed
{
   ethernet=$(nmcli -f general.devices  c show "JDSU WIRED")
   wifi=$(nmcli -f general.devices  c show "JDSU WIFI")
   usb3g=$(nmcli -f general.devices  c show "MTS ANYWHERE")

   if [ "$ethernet" == "" -a "$wifi" == "" -a "$usb3g" == "" ]
      then
      # affichage warning indiquant echec connexion du  l'absence de connectivit
      echo -en "*rem\nproc:warn \"\",\"Connection failed\nno IP address anymore. Check Ethernet cable, wifi or tethering state\",error,0,\"\",\"\",\"Hit any key to continue\"\n" >/dev/tcp/127.0.0.1/8000
   else   
      # affichage warning gnrique indiquant echec connexion
      echo -en "*rem\nprocess:warning \"\",\"Connection failed\", ERROR, 0,\"\",\"\",\"Hit any key to continue\"\n" >/dev/tcp/127.0.0.1/8000
   fi   
}

# Fermeture des fd de ce processus, fd hrits du process parent Isu,  de faon  pouvoir faire un restart_Isu sans tout bloquer 
for fd in $(ls /proc/$$/fd)
   do
   if [ $fd -gt 2 -a $fd -lt 255 ]
      then
      eval "exec $fd<&-"
   fi
   done

#SP_SSH1='10.33.17.59' #eni-intranet3
SP_SSH1='mtsanywhere.updatemyunit.net' #OVH

IS_OTU="no"
[ -f /proc/device-tree/board/info-otu-board ] && [ $(hexdump /proc/device-tree/board/info-otu-board -n 4 -e '"%d"') -eq "3" ] && IS_OTU="yes"

source /etc/platform.conf

PATH=/usr/local/sbin:/usr/local/bin:$PATH:/usr/lib/busybox/bin:/sbin

basedir=$(dirname $0)

# if "uboot_environment" not found, use "fw_printenv" & "fw_setenv"
uboot_environment=uboot_environment
if ! type -p $uboot_environment >/dev/null 2>&1; then
  uboot_environment_get="fw_printenv -n"
  uboot_environment_set=fw_setenv
  vnc_server="/etc/init.d/x11vnc start nopasswd"
  vnc_id="/var/run/x11vnc.pid"
else
  uboot_environment_get="$uboot_environment g"
  uboot_environment_set="$uboot_environment s"
  vnc_server="/sbin/vnc_server 0"
  vnc_id="/tmp/VNC_Type.txt"
fi


if [ "$IS_OTU" == "no" ]
   then
   MtsIdent=$(echo "*rem;*idn?" | nc -w2 127.0.0.1 8000  | tr -d " " )
   MtsLic="MTSLIC:"$(echo "*rem;PROC:LIC:VAL? " | nc -w2 127.0.0.1 8000  | tr -d " " )
   AskConnect="CONNECTV2"
else
   if [ "$MODEL" == "otu8000v2" ]
      then
      RESCUE_MODE=`hexdump -e '1/4 "%d\n"'  /proc/device-tree/board/rescue-mode`
      IDENTITY="OTU8000E"
   else
      [ "$(cat /proc/device-tree/board/rescue-mode)" == "yes" ] && RESCUE_MODE=1 || RESCUE_MODE=0
      IDENTITY="OTU5000"
   fi
   AskConnect="OTUCONNECT"
   if [ "$RESCUE_MODE" != "1" ]
      then
      MtsIdent=$(echo "*rem;*idn?" | nc -w2 127.0.0.1 8000  | tr -d " " )
      MtsLic="MTSLIC:"$(echo "*rem;PROC:LIC:VAL? " | nc -w2 127.0.0.1 8000  | tr -d " " )
   else
      #Demarrage serveur ftp
      if [ "$1" == "DISCONNECT" ]
         then
         /etc/init.d/vsftpd stop
      else
         /etc/init.d/vsftpd start
      fi
      MtsIdent="JDSU,${IDENTITY},"`getserialnb`",ISU,`getinfoversion Isu | cut -f4 -d';' | cut -f2 -d'V'`"
      MtsLic="MTSLIC:"
   fi
fi

echo "MtsIdent="$MtsIdent
echo "MtsLic="$MtsLic

TypCnx="AnyWhereV1.0"

#Savoir par quel media on passe
Media=$(route | grep default | head -n1 | awk '{print $8}' | sed "s/[0-9]//g")

ProxyPac=""
ViaProxy=""

#Obtenir la configuration du Proxy dans System Setup sauf dans le cas usb o ce n'est pas utile (connexion directe internet 3G)
#Pas de gestion du proxy pour l'OTU
if [ "$Media" != "usbg" ] && [ "$IS_OTU" == "no" ]
   then
   UseProxy=$(echo "*rem;SYST:PROXY:USE?" | nc -w2 127.0.0.1 8000)
   
   case $UseProxy in
      MAN)
         Proxy=$(echo "*rem;SYST:PROXY:ADDR?" | nc -w2 127.0.0.1 8000)
         if [ "$Proxy" != "" ]
            then
            ViaProxy="-p $Proxy"
         fi
         ;;
      
      PAC)
         ProxyPac=$(echo "*rem;SYST:PROXY:PAC?" | nc -w2 127.0.0.1 8000)
         if [ "$ProxyPac" != "" ]
            then
            Proxy=$(get_proxy_from_pac $ProxyPac http://$SP_SSH1 $SP_SSH1 | cut -f2 -d "=")
            if [ "$Proxy" != "" ]
               then
               ViaProxy="-p $Proxy"
            fi
         fi
         ;;
      
      *)  ;;
   esac
fi

# if "ssh-weak" not found, try "ssh"
ssh=ssh-weak
if ! type -p $ssh >/dev/null 2>&1; then
  ssh=ssh
fi

if [ "$1" == "CONNECT" -o "$1" == "RECONNECT" ]
   then
   # On teste les 3 "chemins" possibles ( port 22 direct, port 443 direct et port 443 via proxy) pour choisir le plus "efficace"
   # temps en 1/100 de seconde
   set -o pipefail
   time_22=$(/usr/bin/time 2>&1 -p $ssh -i /root/.ssh/kpriv_mts -o StrictHostKeyChecking=no -o UserKnownHostsFile=/dev/null -o "ProxyCommand=$basedir/ssh-proxy.sh -s $ssh %h %p" MAW_Authentication@$SP_SSH1 -p 22 AskConnectionMTS CHECKTIMEFROMMTS | tail -n 3 | head -n 1 | awk '{print $2}' | sed 's/^0*\([0-9]*\)\.\([0-9]*\)/\1\2/')
   RetCode_22=$?
   
   time_443=$(/usr/bin/time 2>&1 -p $ssh -i /root/.ssh/kpriv_mts -o StrictHostKeyChecking=no -o UserKnownHostsFile=/dev/null -o "ProxyCommand=$basedir/ssh-proxy.sh -s $ssh %h %p" MAW_Authentication@$SP_SSH1 -p 443 AskConnectionMTS CHECKTIMEFROMMTS | tail -n 3 |  head -n 1 | awk '{print $2}' | sed 's/^0*\([0-9]*\)\.\([0-9]*\)/\1\2/')
   RetCode_443=$?
   
   if [ "$ViaProxy" != "" ]
      then
      time_443_proxy=$(/usr/bin/time 2>&1 -p $ssh -i /root/.ssh/kpriv_mts -o StrictHostKeyChecking=no -o UserKnownHostsFile=/dev/null -o "ProxyCommand=$basedir/ssh-proxy.sh -s $ssh $ViaProxy %h %p" MAW_Authentication@$SP_SSH1 -p 443 AskConnectionMTS CHECKTIMEFROMMTS | tail -n 3 |  head -n 1 | awk '{print $2}' | sed 's/^0*\([0-9]*\)\.\([0-9]*\)/\1\2/')
      RetCode_443_Proxy=$?
   else
      time_443_proxy=9999
      RetCode_443_Proxy=255
   fi
   set +o pipefail
   
   # On choisit le chemin le plus rapide parmi ceux ayant aboutis
   Chemin=$(echo -e "$RetCode_22 $time_22 P22\n$RetCode_443 $time_443 P443\n$RetCode_443_Proxy $time_443_proxy P443P" | grep '^0' | cut -f2-3 -d ' ' | sort -n | head -n 1 | awk '{print $2}')
   
   case $Chemin in
      P22)
         $ssh -i /root/.ssh/kpriv_mts -o StrictHostKeyChecking=no -o UserKnownHostsFile=/dev/null -o "ProxyCommand=$basedir/ssh-proxy.sh -s $ssh %h %p" MAW_Authentication@$SP_SSH1 -p 22 AskConnectionMTS $AskConnect $TypCnx $MtsIdent $MtsLic $Media >/tmp/param_mts
         RetCode=$?
         PortUsed=22
         ViaProxy=
         ;;
      
      P443)
         $ssh -i /root/.ssh/kpriv_mts -o StrictHostKeyChecking=no -o UserKnownHostsFile=/dev/null -o "ProxyCommand=$basedir/ssh-proxy.sh -s $ssh %h %p" MAW_Authentication@$SP_SSH1 -p 443 AskConnectionMTS $AskConnect $TypCnx $MtsIdent $MtsLic $Media >/tmp/param_mts
         RetCode=$?
         PortUsed=443
         ViaProxy=
         ;;
         
      P443P)
         $ssh -i /root/.ssh/kpriv_mts -o StrictHostKeyChecking=no -o UserKnownHostsFile=/dev/null -o "ProxyCommand=$basedir/ssh-proxy.sh -s $ssh $ViaProxy %h %p" MAW_Authentication@$SP_SSH1 -p 443 AskConnectionMTS $AskConnect $TypCnx $MtsIdent $MtsLic $Media >/tmp/param_mts
         RetCode=$?
         PortUsed=443
         ;;
      
      *)
         RetCode=255
         ;;
   esac
   
   
   if [ "$RetCode" == 0 ]
      then
      chmod 400 /tmp/param_mts
      
      #Extraction des ports a forwarder "Remote"
      ChampPort=2
      PortSrc=$(cat /tmp/param_mts  | grep cnx_device_port_remote_forwarded_origine | awk -F "[:,]" '{print $'$ChampPort'}')
      PortDst=$(cat /tmp/param_mts  | grep cnx_device_port_remote_forwarded_destination | awk -F "[:,]" '{print $'$ChampPort'}')
      while [ "$PortDst" != "" ]
         do
         RemoteForwardPorts="$RemoteForwardPorts -R$PortSrc:localhost:$PortDst"
         ((ChampPort++))
         PortSrc=$(cat /tmp/param_mts  | grep cnx_device_port_remote_forwarded_origine | awk -F "[:,]" '{print $'$ChampPort'}')
         PortDst=$(cat /tmp/param_mts  | grep cnx_device_port_remote_forwarded_destination | awk -F "[:,]" '{print $'$ChampPort'}')
         done
         
      #Extraction des ports a forwarder "Local"
      ChampPort=2
      PortSrc=$(cat /tmp/param_mts  | grep cnx_device_port_local_forwarded_origine | awk -F "[:,]" '{print $'$ChampPort'}')
      PortDst=$(cat /tmp/param_mts  | grep cnx_device_port_local_forwarded_destination | awk -F "[:,]" '{print $'$ChampPort'}')
      while [ "$PortDst" != "" ]
         do
         LocalForwardPorts="$LocalForwardPorts -L$PortSrc:localhost:$PortDst"
         ((ChampPort++))
         PortSrc=$(cat /tmp/param_mts  | grep cnx_device_port_local_forwarded_origine | awk -F "[:,]" '{print $'$ChampPort'}')
         PortDst=$(cat /tmp/param_mts  | grep cnx_device_port_local_forwarded_destination | awk -F "[:,]" '{print $'$ChampPort'}')
         done
   
      # Extraction du timeout (au bout duquel la connexion ssh "sautera" si personne ne s'est connect au produit
      Max_sleep=$(cat /tmp/param_mts  | grep cnx_device_max_sleep | cut -d ":" -f 2)
         
      #Extraction et affichage si necessaire du "Magic Number"
      MagicNumber=$(cat /tmp/param_mts  | grep cnx_magic_number | cut -d ":" -f 2)
      echo "MagicNumber: $MagicNumber"
      echo $MagicNumber > /tmp/anywhere.nbr
      if [ "$1" == "CONNECT" ] && [ "$IS_OTU" == "no" ]
         then
         echo -en "*rem\nprocess:warning \"\",\"Access Code: $MagicNumber\", INFO, 1,\"OK\",\"\",\"Record this code\n(Licence required for non-Viavi remote access)\"\n" >/dev/tcp/127.0.0.1/8000
      fi
   
      #Extraction de l'adresse IP du serveur  utiliser
      ServerIp=$(cat /tmp/param_mts  | grep cnx_server_ip | cut -d ":" -f 2)
      
      #Dans le cas config automatique du proxy avec un fichier .pac, il faut rechercher le proxy avec
      #cette nouvelle adresse IP si on a dcid de passer par le proxy
      if [ "$ViaProxy" != "" -a "$ProxyPac" != "" ]
         then
         Proxy=$(get_proxy_from_pac $ProxyPac http://$ServerIp $ServerIp | cut -f2 -d "=")
         if [ "$Proxy" != "" ]
            then
            ViaProxy="-p $Proxy"
         else
            ViaProxy=""
         fi
      fi

      # Si il i y a deja une connexion active, il ne faut pas en lancer une deuxieme
      Prev_Ssh_Pid=$(ps ax | grep ssh | grep MAW_Connection | grep param_mts |  head -n 1 | awk '{ print $1 }')
      if [ "$Prev_Ssh_Pid" == "" ]
         then    
         $ssh -i /tmp/param_mts -o StrictHostKeyChecking=no  -o ExitOnForwardFailure=yes -o UserKnownHostsFile=/dev/null -o "ProxyCommand=$basedir/ssh-proxy.sh -s $ssh $ViaProxy %h %p" MAW_Connection@$ServerIp $RemoteForwardPorts $LocalForwardPorts -p $PortUsed -f $Max_sleep >/dev/null 2>/tmp/MAW_Connection
      fi
      RetCode=$?
      echo RETCODE:$RetCode    
      if [ "$RetCode" != 0 ]
         then
         echo $RetCode
         if [ "$1" == "CONNECT" ] && [ "$IS_OTU" == "no" ]
            then
            if [ "$(grep 'forwarding failed' /tmp/MAW_Connection)" != "" ]
            # Avec OpenSSH 6.7 et contrairement  ce qui se passait avec OpenSSH 5.2, le code de retour est 255 (au lieu de 0) quand il y a
            # un chec de Remote port forwarding
               then
               # affichage warning indiquant qu'il faut attendre que les ports se librent sur le serveur
               echo -en "*rem\nprocess:warning \"\",\"Server ports not available\nRetry in some minutes\", WARNING, 0,\"\",\"\",\"Hit any key to continue\"\n" >/dev/tcp/127.0.0.1/8000
            else
               # affichage warning indiquant echec connexion 
               Warning_Connection_Failed
            fi
         fi
      else
         # tout semble bien se passer mais on verifie quand mme que le tunnel est tabli (par exemple il n'y a pas de retour d'erreur si  un port forwarding choue)
         Ssh_Pid=$(ps ax | grep ssh | grep MAW_Connection | grep param_mts |  head -n 1 | awk '{ print $1 }')
         if [ "$Ssh_Pid" != "" ]
            then
            if [ "$1" == "CONNECT" ]
               then
               # on memorise  quel moment une connexion a ete activee et on previent Isu que la connexion est active
               echo -en "*rem\nprocess:mtsanywhere on\n" >/dev/tcp/127.0.0.1/8000
               $uboot_environment_set MtsAnywhere $(date +%s)
            else
               # en cas de reconnexion automatique, on efface au contraire la memorisation pour ne pas repeter le reconnexion a l'infini
               $uboot_environment_set MtsAnywhere
            fi
            
            if [ "$Media" == wlan ]
               # En cas de connexion via wifi, on force autoconnect de faon  ne pas perdre la connexion SAA si le rseau "bafouille"
               then
               nmcli c modify "$(nmcli c | grep -o "JDSU WIFI")" connection.autoconnect yes connection.autoconnect-priority 10
               fi
   
            # si il n'y a pas deja un serveur x11vnc actif, alors on le lance (sans password)  et on l'arrete quand la connexion ssh tombe
            # Le test est plus complexe  cause du 4000v2 dans lequel Isu lance /etc/init.d/x11vnc connections pour connaitre le nombre de
            # connexions: ce process l n'est pas le serveur vnc...
            ( (
            if [ "$(ps ax | grep x11vnc | grep -v "grep\|init.d")" == "" ]
               then
   
               $vnc_server
               sleep 1
               X11vnc_Pid=$(ps ax | grep x11vnc | grep -v "grep\|init.d" | head -n 1 | awk '{ print $1 }')
               # on efface le fichier Type afin de forcer un restart en cas de changement du menu "Remote Screen"
               # pour etre capable de detecter ce cas
               # ou le fichier /var/run/x11vnc.pid dans le cas du 4000v2
               rm -f $vnc_id
    
               while [ "$($uboot_environment_get MtsAnywhere)" != "" ] || [ -d /proc/$Ssh_Pid ]
                  do
                  sleep 10
                  done
              
               # il ne faut pas arreter le serveur x11vnc dans le cas ou l'utilisateur l'aurait active apres coup dans le menu  
               if [ "$X11vnc_Pid" == "$(ps ax | grep x11vnc | grep -v "grep\|init.d" | head -n 1 | awk '{ print $1 }')" ]
                  then
                  killall x11vnc 2>/dev/null
                  rm -f /tmp/VNC_Etat.txt
               fi
            fi
            ) & ) &
            
            # EPT 5671, on surveille s'il y a un changement de rseau pendant que SAA est actif: si cela arrive on previent avec un warning que la connexion est perdue
            # et on dconnecte 
            ( (
            if [ "$Ssh_Pid" != "$Prev_Ssh_Pid" ]
               then
               Wait_Before_Restart_Connection=0
               while [ "$($uboot_environment_get MtsAnywhere)" != "" ]  
                  do 
                  if [ -d /proc/$Ssh_Pid ]
                     then
                     CurrentMedia=$(route | grep default | head -n1 | awk '{print $8}' | sed "s/[0-9]//g")
                     if [ "$CurrentMedia" != "$Media" -a "$CurrentMedia" != "" ]
                        then
                        rm -f /tmp/param_mts*
                        kill $(ps aux | grep ssh | grep MAW_Connection | grep param_mts | tr -s " " | cut -d " " -f 2)
                        $uboot_environment_set MtsAnywhere
                        echo "*rem;proc:mtsanywhere off" | nc -w2 127.0.0.1 8000
                        if [ "$1" == "CONNECT" ] && [ "$IS_OTU" == "no" ]
                           then
                           echo -en "*rem\nprocess:warning \"\",\"SmartAcces connection lost\nDefault network route is no more the one used for connection\", STOP, 1,\"OK\",\"\",\"Press OK to continue\"\n" >/dev/tcp/127.0.0.1/8000
                        fi   
                     fi
                     sleep 10
                  else
                     # Appel serveur pour voir si la session est toujours active
                     Session_Ended=$($ssh -i /root/.ssh/kpriv_mts -o StrictHostKeyChecking=no -o UserKnownHostsFile=/dev/null  -o "ProxyCommand=$basedir/ssh-proxy.sh -s $ssh $ViaProxy %h %p" MAW_Authentication@$SP_SSH1 -p $PortUsed AskConnectionMTS CHECKSESSIONFROMMTS $MagicNumber)
                     if [ "$Session_Ended" = "SESSIONISDEAD" ]
                        then
                        rm -f /tmp/param_mts*
                        # Si ce n'est pas un arret explicite de connexion on previent avec un warning que la session est termine
                        # Pas de warning bien sur en cas de reconnexion automatique car on est deja en etat OFF d'un point de vue IHM
                        if [ "$($uboot_environment_get MtsAnywhere)" != "" ]
                           then
                           $uboot_environment_set MtsAnywhere
                           echo "*rem;proc:mtsanywhere off" | nc -w2 127.0.0.1 8000
                           if [ "$IS_OTU" == "no" ]
                              then
                              echo -en "*rem\nprocess:warning \"\",\"SmartAcces connection stopped\nthe link to server dropped due to end of session\", STOP, 1,\"OK\",\"\",\"Press OK to continue\"\n" >/dev/tcp/127.0.0.1/8000
                           fi
                        fi
                     else
                        sleep $Wait_Before_Restart_Connection
                        echo "relancer et tester ssh"
                        $ssh -i /tmp/param_mts -o StrictHostKeyChecking=no  -o ExitOnForwardFailure=yes -o UserKnownHostsFile=/dev/null -o "ProxyCommand=$basedir/ssh-proxy.sh -s $ssh $ViaProxy %h %p" MAW_Connection@$ServerIp $RemoteForwardPorts $LocalForwardPorts -p $PortUsed -f $Max_sleep >/dev/null 2>/tmp/MAW_Connection
                        RetCode=$?
                        echo RETCODE:$RetCode    
                        if [ "$RetCode" != 0 ]
                           then
                           # chec, on attend avant de faire une nouvelle tentative 
                           Wait_Before_Restart_Connection=60
                        else
                           # tout semble bien se passer mais on verifie quand mme que le tunnel est tabli (par exemple il n'y a pas de retour d'erreur si  un port forwarding choue)
                           Ssh_Pid=$(ps ax | grep ssh | grep MAW_Connection | grep param_mts |  head -n 1 | awk '{ print $1 }')
                           if [ "$Ssh_Pid" != "" ]
                              then
                              # succs, on reset le temps d'attente
                              Wait_Before_Restart_Connection=0
                           fi
                        fi  
                     fi
                  fi
               done   
            fi 
            ) & ) &
         else
            if [ "$1" == "CONNECT" ] && [ "$IS_OTU" == "no" ]
               then
               if [ "$(grep 'forwarding failed' /tmp/MAW_Connection)" != "" ]
                  then
                  # affichage warning indiquant qu'il faut attendre que les ports se librent sur le serveur
                  echo -en "*rem\nprocess:warning \"\",\"Server ports not available\nRetry in some minutes\", WARNING, 0,\"\",\"\",\"Hit any key to continue\"\n" >/dev/tcp/127.0.0.1/8000
               else
                  # affichage warning indiquant echec connexion 
                  echo -en "*rem\nprocess:warning \"\",\"Connection failed\", ERROR, 0,\"\",\"\",\"Hit any key to continue\"\n" >/dev/tcp/127.0.0.1/8000
               fi
            fi
         fi # [ "$Ssh_Pid" != "" ]
      fi # [ "$RetCode" != 0 ]

      #cat /tmp/param_mts
   else
      echo $RetCode
      echo RETCODE:$RetCode  
      if [ "$1" == "CONNECT" ] && [ "$IS_OTU" == "no" ]
         then
         # affichage warning indiquant echec connexion 
         Warning_Connection_Failed
      fi 
   fi
else
   Disconnect
   rm -f  /tmp/anywhere.nbr
fi
