import QtQuick 1.1
import libfo 1.0
import "Viavi_Colors.js" as VColor

Rectangle {
   id: container
   
   color: VColor.cViaviColorLightGray2
       
  Rectangle {
      id: loadWizard
      width: 650
      height: 100
      radius: 20
      color: VColor.cViaviColorLogoPurple

      anchors.horizontalCenter: parent.horizontalCenter
      anchors.bottom: parent.verticalCenter
      anchors.bottomMargin: 30

      Text {
		  color: VColor.cViaviColorWhite
		  anchors.fill: parent
		  text: windows_manager.txtTestAuto
		  horizontalAlignment: Text.AlignHCenter
		  verticalAlignment:  Text.AlignVCenter
		  font.pixelSize: 30
      }
      
      MouseArea {
	  anchors.fill: parent
		  onClicked: {
		    windows_manager.Close_Config_Mode_Windows(true);
		  }
      }
  }
  
  /* Separator */
  Rectangle {
    width: 300
    height: 6
    
    radius: 3
    
    color: VColor.cViaviColorGray
    
    anchors.centerIn: parent
  }
   
  Rectangle {
      id: loadConfig
      width: 650
      height: 100
      radius: 20
      color: VColor.cViaviColorLightBlue

      anchors.horizontalCenter: parent.horizontalCenter
      anchors.top: parent.verticalCenter
      anchors.topMargin: 30

      Text {
		  color: VColor.cViaviColorWhite
		  anchors.fill: parent
		  text: windows_manager.txtLoadSmartConfig
		  horizontalAlignment: Text.AlignHCenter
		  verticalAlignment:  Text.AlignVCenter
		  font.pixelSize: 30
      }
      
      MouseArea {
	  anchors.fill: parent
		  onClicked: {
		    windows_manager.Close_Config_Mode_Windows(false);
		  }
      }
  }

   Text {
       color: VColor.cViaviColorBlack
       anchors.top: parent.top
       anchors.right: parent.right
       anchors.margins: 10
       text: windows_manager.txtWizardFilename
       horizontalAlignment: Text.AlignRight
       verticalAlignment:  Text.AlignVCenter
       font.pixelSize: 20
   }
}
