<?php
// *********************************************************
// NOTICE: All rights reserved. This material contains the
// trade secrets and confidential information of VIAVI Solutions
// which embody substantial creative effort,
// ideas and expressions. No part of this material may be
// reproduced or transmitted in any form or by any means,
// electronic, mechanical, optical or otherwise, including
// photocopying and recording or in connection with any
// information storage or retrieval system, without
// specific written permission from VIAVI Solutions
// Copyright JDSU 2017. All rights reserved.
// *********************************************************
namespace app\database\patch;

use app\util\SMTLogger;

use app\database\SMTSmartOtuDB;

use app\database\SMTSqlPatch;

/**
 * Datatabase patch to add autotest generic file name
 * Database version 1
 * Patch number 6
 *
 * @author Sylvain Desplat
 */
class SMTSql01p0007 extends SMTSqlPatch
{  
//patches:
	const SQL_ADD_SYSTEM_ALARM_ADDITIONAL_INFO=
	"ALTER TABLE system_alarm ADD otu_additional_info TEXT default \"\"";
    
    
    function __construct()
    {
        SMTLogger::getInstance()->trace( sprintf("Execute patch %s.", __CLASS__ ), SMTLogger::INFO );
        
    	//retrieve patch version
        $className = basename(__FILE__, '.php');
        preg_match_all('!\d+!', $className, $matches);
        
        $this->dbVersion = $matches[0][0];
        $this->dbPatch = $matches[0][1];
    }
    
    /**
     * @return SMTSql01p0007
     */    
    public static function getInstance()
    {
        return new SMTSql01p0007();
    }
    
    /**
     * Add smartOTU system_configuration table.
     *
     * @see \app\database\SMTSqlPatch::execute()
     */    
    public function execute( SMTSmartOtuDB $db )
    {    
    	$success = $db->execWithTrace(self::SQL_ADD_SYSTEM_ALARM_ADDITIONAL_INFO, SMTLogger::INFO );
    	self::handleExecutePatchError($db, self::SQL_ADD_SYSTEM_ALARM_ADDITIONAL_INFO, $success, __FILE__, __METHOD__, __LINE__ ); 
    	
	    $success = $this->addPatchTrace($db, 'Add database system alarm additional info');
	    self::handleExecutePatchError($db, SMTSqlPatch::SQL_TRACE_DATABASE_PATCH, $success, __FILE__, __METHOD__, __LINE__ );    	
    }
}
?>