#!/usr/bin/env python3
# -*- coding:utf-8 -*-
#
# This script monitor the reset-ip button.
# When this button is pressed the CFG1 network config is apply and a flag is set.
# If the script is still running after 5 sec (long press on ip-reset button will initiate a HW reset)
# the flag is removed.

from jdsu.mts import ScpiAccess, bootutils
from time import sleep
import logging
import logging.handlers
import subprocess
import shutil
import os.path

FILE_TO_REMOVED= [ "/acterna/storage/share/ssu.conf",
                   "/acterna/storage/isu/config/isu.conf",
                   "/acterna/storage/fo/results/otdr/",
                   "/acterna/storage/fo/configs/otdr/",
                   "/acterna/storage/fo/configs/file_setup_common.fo_cfg",
                   "/acterna/storage/fo/configs/color_setup_ascii.fo_cfg"
                   ]

# configure logging
log = logging.getLogger()
handler = logging.handlers.SysLogHandler(address='/dev/log')
formatter = logging.Formatter('reset-ip-monitor: %(message)s')
handler.setFormatter(formatter)
log.addHandler(handler)

# First check if there is a factory default in progress
env = bootutils.Bootenv()
if "FactoryDefault" in env.keys() and env.FactoryDefault == "YES":
    env.FactoryDefault = ""
    logging.critical("Restoring default configuration due to ip reset long press")
    # restore default configuration
    for file_to_delete in FILE_TO_REMOVED:
        if os.path.isdir(file_to_delete):
            shutil.rmtree(file_to_delete, ignore_errors=True)
        elif os.path.exists(file_to_delete):
            os.remove(file_to_delete)

# Loop for ever
while True:
    with open("/dev/resetip") as fp:
        result = fp.read()  # Blocking call, return when the button is pressed
        logging.critical("Reset IP button pressed: applying CFG1")
        # reset ip to default (can be user customized by licence)
        try:
            u = ScpiAccess.ScpiAccess("127.0.0.1", "8000")
            u.connect()
            u.SendCommand('ISU:DFT "ETH_IP0,ETH_SUBNET0,ETH_GATEWAY0,ETH_DNS0,ETH_EXT_DNS_B0,ETH_EXT_DNS_C0,ETH_DOMAIN0,ETH_SITE0,ETH_MODE"')
            u.SendCommand("SYSTEM:ETHERNET:RESTART")
            u.disconnect()
        except:
            logging.critical("Failed to apply CFG1")

        # Raise the flag for a long press
        env = bootutils.Bootenv()
        env.FactoryDefault = "YES"
        subprocess.check_output(["sync"])

        # wait for more than 5 secs, if we are still alive ti means it was a short press
        sleep(6)

        # Still alive
        env.FactoryDefault = ""
