# coding: utf-8 
# coding: utf-8 
# machine: eotdrv2

ver='05-12-2018'

from importlib import reload
from jdsu.evm import *          # dans /usr/lib/python3.5/jdsu/evm contient O()... , print_info....
from jdsu.diag import *
from time import time, sleep
from jdsu.mts.uts_bdt import UtsBdt
from math import log
import csv
import traceback
import collections
from pathlib import Path
from .eotdrv2_regs import *

gain={  #gain hardware entre valeurs mesurees et entrees ADC
            "adc_vin":1/(1+4.64+10),   #R2+R4+R5=1K+4.64K+10K
            "adc_vcc_apd":0.99/100,    #0.99%
            "adc_temp_ana":9e-3,    #9mV/deg + 454mV-318mV
            "adc_det_shield":1,
            "adc_vtec":0.1,
            "adc_meas_v_ana":1,
            "adc_meas_vee_laser":9.54978/100,  #9.54978%
            "adc_meas_ilas":3.61*3320/13320*2.2/3,  #(V/A) *** division par 3 car sommateur IL1+IL2+Il3
            "adc_itec":0.21,
            "adc_vctn":4640.0/(4640+6810+147)            }

offset={#offset en V
            "adc_vin":0,
            "adc_vcc_apd":0, 
            "adc_temp_ana":0.5*100/110-5.0*10/157,    
            "adc_det_shield":0,
            "adc_vtec":0,
            "adc_meas_v_ana":0,
            "adc_meas_vee_laser":0,
            "adc_meas_ilas":0,
            "adc_itec":0,
            "adc_vctn":0    }

R25=10e3
B=3900
Rfb=43.2e3
Rx=10e3
R=10e3+6.8e3
Vref=2.5

def setColor(color=''): #31=rose 32=vert 33=jaune 34=violet
    print("\033[1;"+str(color)+"m",end='')
        
def print_error(a):#red=31
    print("\033[1;31m",end='')
    print(a,end='')
    print("\033[1;m")
    
def print_info(a):#blue=36
    print("\033[1;34m",end='')
    print(a,end='')
    print("\033[1;m")

class Otdr_Acq_Exception(Exception):
    CONST_EXCEPTION_TIMEOUT_PLL = -1
    CONST_EXCEPTION_TIMEOUT_START_ACQ = -2
    CONST_EXCEPTION_TIMEOUT_ACQ = -3
    pass

    def __init__(self, except_no):
        self.except_no = except_no

    def __str__(self):
        if self.except_no == self.CONST_EXCEPTION_TIMEOUT_PLL:
            return "OTDR Exception: PLL Lock Timeout"
        elif self.except_no == self.CONST_EXCEPTION_TIMEOUT_START_ACQ:
            return "OTDR Exception: Timeout Start Acquisition"
        elif self.except_no == self.CONST_EXCEPTION_TIMEOUT_ACQ:
            return "OTDR Exception: Timeout Acquisition"
        else:
            return "OTDR Exception: Unknown"

class Otdr_Acq(object):
    ARRAY_VERIF_RAMAN = None

    def get_array_raman(self):
        if self.ARRAY_VERIF_RAMAN is None:
            self.ARRAY_VERIF_RAMAN =  [ \
                                    ['GAIN_1K',   16384, int(CONST("raman.gain_1k.dac16384.value",20730300)),  int(CONST("raman.gain_1k.dac16384.tolerance",5)),  float(CONST("raman.gain_1k.dac16384.noise",0.5))], \
                                    ['GAIN_1K',   32768, int(CONST("raman.gain_1k.dac32768.value",20724200)),  int(CONST("raman.gain_1k.dac32768.tolerance",5)),  float(CONST("raman.gain_1k.dac32768.noise",0.5))], \
                                    ['GAIN_1K',   49152, int(CONST("raman.gain_1k.dac49152.value",20719000)),  int(CONST("raman.gain_1k.dac49152.tolerance",5)),  float(CONST("raman.gain_1k.dac49152.noise",0.5))], \
                                    ['GAIN_4K64', 16384, int(CONST("raman.gain_4k.dac16384.value",20711900)),  int(CONST("raman.gain_4k.dac16384.tolerance",5)),  float(CONST("raman.gain_4k.dac16384.noise",1))], \
                                    ['GAIN_4K64', 32768, int(CONST("raman.gain_4k.dac32768.value",20684500)),  int(CONST("raman.gain_4k.dac32768.tolerance",5)),  float(CONST("raman.gain_4k.dac32768.noise",1))], \
                                    ['GAIN_4K64', 49152, int(CONST("raman.gain_4k.dac49152.value",20657000)),  int(CONST("raman.gain_4k.dac49152.tolerance",5)),  float(CONST("raman.gain_4k.dac49152.noise",1))], \
                                    ['GAIN_17K8', 16384, int(CONST("raman.gain_17k.dac16384.value",20635500)), int(CONST("raman.gain_17k.dac16384.tolerance",10)), float(CONST("raman.gain_17k.dac16384.noise",5))], \
                                    ['GAIN_17K8', 32768, int(CONST("raman.gain_17k.dac32768.value",20531000)), int(CONST("raman.gain_17k.dac32768.tolerance",10)), float(CONST("raman.gain_17k.dac32768.noise",5))], \
                                    ['GAIN_17K8', 49152, int(CONST("raman.gain_17k.dac49152.value",20427300)), int(CONST("raman.gain_17k.dac49152.tolerance",10)), float(CONST("raman.gain_17k.dac49152.noise",5))], \
                                    ['GAIN_68K',  16384, int(CONST("raman.gain_68k.dac16384.value",20355600)), int(CONST("raman.gain_68k.dac16384.tolerance",10)), float(CONST("raman.gain_68k.dac16384.noise",10))], \
                                    ['GAIN_68K',  32768, int(CONST("raman.gain_68k.dac32768.value",19974600)), int(CONST("raman.gain_68k.dac32768.tolerance",10)), float(CONST("raman.gain_68k.dac32768.noise",10))], \
                                    ['GAIN_68K',  49152, int(CONST("raman.gain_68k.dac49152.value",19593900)), int(CONST("raman.gain_68k.dac49152.tolerance",10)), float(CONST("raman.gain_68k.dac49152.noise",10))], \
                                    ['GAIN_1M',       0, int(CONST("raman.gain_1m.dac0.value",     20720600)), int(CONST("raman.gain_1m.dac0.tolerance",10)),  float(CONST("raman.gain_1m.dac0.noise",50))], \
                                    ['GAIN_1M',   16384, int(CONST("raman.gain_1m.dac16384.value",14783000)),  int(CONST("raman.gain_1m.dac16384.tolerance",10)),  float(CONST("raman.gain_1m.dac16384.noise",50))]]
        return self.ARRAY_VERIF_RAMAN

    def __init__(self):
        self.utsbdt = UtsBdt("/dev/bdt_pws1")
        self.CONST_GAINS = collections.OrderedDict()
        self.CONST_GAINS.update({'GAIN_1K': 0x0})
        self.CONST_GAINS.update({'GAIN_4K64': 0x1})
        self.CONST_GAINS.update({'GAIN_17K8': 0x2})
        self.CONST_GAINS.update({'GAIN_68K': 0x3})
        self.CONST_GAINS.update({'GAIN_1M': 0x4})
        # set ADC ouput mode in Offset binary instead of 2 complement
        sysfs_write("/sys/platform/adcbdt/address", 0x14)
        sysfs_write("/sys/platform/adcbdt/value",   0x00)   
        sysfs_write("/sys/platform/adcbdt/address", 0xFF)
        sysfs_write("/sys/platform/adcbdt/value", 0x1)

    def StartAcq(self,laser_enable):
        self.utsbdt.rw_register(UtsBdt.WRITE, REG_MISC,  0xFFFFFFFF, 0)
        timeout = time() + 1
        while ( ( self.utsbdt.rw_register(UtsBdt.READ, REG_MISC,  0, 0)  & REG_MISC_PLL_LOCKED ) != REG_MISC_PLL_LOCKED ):
            if (time() > timeout):
                raise Otdr_Acq_Exception(Otdr_Acq_Exception.CONST_EXCEPTION_TIMEOUT_PLL)
        self.utsbdt.rw_register(UtsBdt.WRITE, REG_MISC, REG_MISC_BDT_ON | REG_MISC_CLEAR_IRQ,     REG_MISC_BDT_ON | REG_MISC_CLEAR_IRQ)
        if laser_enable:
            self.utsbdt.rw_register(UtsBdt.WRITE, REG_MISC, REG_MISC_LASER_ON| REG_MISC_CLEAR_IRQ,  REG_MISC_LASER_ON)
        else:
            self.utsbdt.rw_register(UtsBdt.WRITE, REG_MISC, REG_MISC_LASER_ON| REG_MISC_CLEAR_IRQ,  0)
            
        self.utsbdt.rw_register(UtsBdt.WRITE, REG_MISC, REG_MISC_START_MEAS | REG_MISC_ENABLE_IRQ, REG_MISC_START_MEAS | REG_MISC_ENABLE_IRQ)

        timeout = time() + 2
        while ( (not self.IsMeasInProgress()) and not self.IsIrqEndMeasureRised()):
            sleep(0.2)
            if (time() > timeout):
                raise Otdr_Acq_Exception(Otdr_Acq_Exception.CONST_EXCEPTION_TIMEOUT_START_ACQ)


    def IsMeasInProgress(self):
        return (self.utsbdt.rw_register(UtsBdt.READ, REG_MISC,  0, 0) & REG_MISC_MEAS_IN_PROGRESS ) == REG_MISC_MEAS_IN_PROGRESS

    def IsIrqEndMeasureRised(self):
        return ( self.utsbdt.rw_register(UtsBdt.READ, REG_MISC,  0, 0) & REG_MISC_IRQ_BDT ) == REG_MISC_IRQ_BDT

    def IsLaserInProgress(self):
        return ( self.utsbdt.rw_register(UtsBdt.READ, REG_MISC,  0, 0)  & REG_MISC_LASER_IN_PROGRESS ) == REG_MISC_LASER_IN_PROGRESS

    def StartAndPoolAcq(self,laser_enable):
        self.StartAcq(laser_enable)    
    # WAIT END MEASURE
        timeout = time() + 32   #permet 100kpts @3µs, 20kpts@10µs, 10kpts@20µs
        while ( self.IsMeasInProgress()  ):
            if (time() > timeout):
                raise Otdr_Acq_Exception(Otdr_Acq_Exception.CONST_EXCEPTION_TIMEOUT_ACQ)
        self.utsbdt.rw_register(UtsBdt.WRITE, REG_MISC, REG_MISC_CLEAR_IRQ, REG_MISC_CLEAR_IRQ)
        self.utsbdt.rw_register(UtsBdt.WRITE, REG_MISC, REG_MISC_CLEAR_IRQ, 0)
        return 0
        

    def StartAndPoolAcqAndMeasI(self,laser_enable):
        ilas=[]
        self.StartAcq(laser_enable)    
        # WAIT END MEASURE
        timeout = time() + 62
        while ( self.IsMeasInProgress() ):
            if (time() > timeout):
                raise Otdr_Acq_Exception(Otdr_Acq_Exception.CONST_EXCEPTION_TIMEOUT_ACQ)
            if ( self.IsLaserInProgress() ):
                ilas.append(XADC('adc_meas_ilas'))
        self.utsbdt.rw_register(UtsBdt.WRITE, REG_MISC, REG_MISC_CLEAR_IRQ, REG_MISC_CLEAR_IRQ)
        self.utsbdt.rw_register(UtsBdt.WRITE, REG_MISC, REG_MISC_CLEAR_IRQ, 0)
        # Compute Ilas
        moy=0.0
        for el in ilas:
            moy+=el
        moy/=len(ilas)
        #~ dumpListinFile(ilas)
        return(moy)

    def ConfigAcqBIST(self,teeth,avg,pulse,laser):
        self.utsbdt.rw_register(UtsBdt.WRITE, REG_TEETH_NUMBER,     0xFFFFFFFF, teeth)
        self.utsbdt.rw_register(UtsBdt.WRITE, REG_XOFFSET_DURATION, 0xFFFFFFFF, 300)
        self.utsbdt.rw_register(UtsBdt.WRITE, REG_MASQ_DURATION, 0xFFFFFFFF, 0)
        self.utsbdt.rw_register(UtsBdt.WRITE, REG_WAIT_DURATION,    0xFFFFFFFF, 0)
        self.utsbdt.rw_register(UtsBdt.WRITE, REG_NOISE_DURATION,   0xFFFFFFFF, 0)
        self.utsbdt.rw_register(UtsBdt.WRITE, REG_AVERAGE_NUMBER,   0xFFFFFFFF, avg)
        self.utsbdt.rw_register(UtsBdt.WRITE, REG_RAMP_INCR,        0xFFFFFFFF, 0)
        self.utsbdt.rw_register(UtsBdt.WRITE, REG_RAMP_RESET_VAL,   0xFFFFFFFF, 0)
        self.utsbdt.rw_register(UtsBdt.WRITE, REG_COMB_NUMBER,      0xFFFFFFFF, 1)
        self.utsbdt.rw_register(UtsBdt.WRITE, REG_COMB_INCR,        0xFFFFFFFF, 0)
        self.utsbdt.rw_register(UtsBdt.WRITE, REG_CRUNCH_NUMBER,    0xFFFFFFFF, 0)
        self.utsbdt.rw_register(UtsBdt.WRITE, REG_LASER_WIDTH_ENT,  0xFFFFFFFF, pulse)
        self.utsbdt.rw_register(UtsBdt.WRITE, REG_LASER_WIDTH_DEC,  0xFFFFFFFF, 0)
        self.utsbdt.rw_register(UtsBdt.WRITE, REG_LASER_ENABLE,     0xFFFFFFFF, laser)
        self.utsbdt.rw_register(UtsBdt.WRITE, REG_OFFSET_CONTINU,   0xFFFFFFFF, 0)
        recurrence=max(teeth+310,pulse*100) # pour respecter le 1% sur le laser
        #~ print("recurrence=%d"%recurrence)
        self.utsbdt.rw_register(UtsBdt.WRITE, REG_PRIME_RECUR,     0xFFFFFFFF, recurrence)
        return 0

    def StartModulationSource(self, freq):
        self.utsbdt.rw_register(UtsBdt.WRITE, REG_MISC,  0xFFFFFFFF, 0)
        self.utsbdt.rw_register(UtsBdt.WRITE, REG_LASER_FREQ,     0xFFFFFFFF, freq)
        return 0


    def DumpAcq(self, sample):
        handle = open("/dev/bdt_pws1", "rb")
        for i in range(0,sample):
            data = handle.read(4)
            datab = bytearray(data)
            val = datab[0] + datab[1]*0x100 + datab[2]*0x10000 + datab[3]*0x1000000
            print("%d:%x"%(i,val))
        return 0

    def AvgAcq(self, sample):
        self.avg = 0
        self.min_acq = 0xFFFFFFFF
        self.max_acq = 0
        handle = open("/dev/bdt_pws1", "rb")
        sleep(0.2)
        for i in range(0,sample+1):
            data = handle.read(4)
            if i > 300: #skip first point
                datab = bytearray(data)
                val = datab[0] + datab[1]*0x100 + datab[2]*0x10000 + datab[3]*0x1000000
                if  val < self.min_acq:
                    self.min_acq = val
                if  val > self.max_acq:
                    self.max_acq = val
                self.avg = self.avg + val
        self.avg = self.avg / (sample-300)
        return self.avg


    def VerifBufferAcq(self, sample, average, expvalue):
        err = 0
        handle = open("/dev/bdt_pws1", "rb")
        exp = average * expvalue
        for i in range(0,sample):
            data = handle.read(4)
            if i > 0:   #skip first point
                datab = bytearray(data)
                val = datab[0] + datab[1]*0x100 + datab[2]*0x10000 + datab[3]*0x1000000
                if val != exp:
                    print_error("# unexpected value in acquisition buffer index=%d , value = %d, exp = %d" %(i, val, expvalue))
                    err = err + 1
        return err

    def DumpAcq(self, sample):
        err = 0
        handle = open("/dev/bdt_pws1", "rb")
        for i in range(0,sample):
            data = handle.read(4)
            if i > 0:   #skip first point
                datab = bytearray(data)
                val = datab[0] + datab[1]*0x100 + datab[2]*0x10000 + datab[3]*0x1000000
                print_info("%d: 0x%08x"%(i,val))
        return

    def getBufferNoise(self, sample):
        handle = open("/dev/bdt_pws1", "rb")
        noise = 0
        for i in range(0,sample):
            data = handle.read(4)
            if i > 0:   #skip first point
                datab = bytearray(data)
                val = datab[0] + datab[1]*0x100 + datab[2]*0x10000 + datab[3]*0x1000000
                if val > noise:
                    noise = val
        return noise

    def setConsigneRaman(self,consigne):
        self.utsbdt.rw_register(UtsBdt.WRITE, REG_DAC_CONSIGNE_RAMAN, 0x000FFFF, consigne)
        sleep(0.1)
        return 0

    def setGain(self, gain):
        err = -1
        self.utsbdt.rw_register(UtsBdt.WRITE, REG_HARDWARE_CFG, 0x0000007, gain)
        sleep(0.1)
        return 0

    def enableAPD(self, enable):
        if enable:
            self.utsbdt.rw_register(UtsBdt.WRITE, REG_HARDWARE_CFG, 0x0000018, 0x10)
        else:
            self.utsbdt.rw_register(UtsBdt.WRITE, REG_HARDWARE_CFG, 0x0000018, 0)
        sleep(0.5)
        return 0

    def loopOnGainAndRaman(self):
        first_acq_skipped = False
        csvfile = open('dump_gain_raman.csv','w')
        csvwriter = csv.writer(csvfile, dialect='excel')
        csvwriter.writerow(['Gain APD','Consigne Raman','Acquisition Average','Acquisition Min','Acquisition Max'])
        self.ConfigAcqBIST(2000,10000,0,0)
        for gain in self.CONST_GAINS:
            self.setGain(self.CONST_GAINS[gain])
            consigne = 0
            print("# Gain = %s"%(gain))
            while consigne < 65536:
                self.setConsigneRaman(consigne)
                if not first_acq_skipped:
                    self.StartAndPoolAcq(False)
                    first_acq_skipped = True
                self.StartAndPoolAcq(False)
                self.DumpAcq(10)
                self.AvgAcq(1000)
                csvwriter.writerow([gain,consigne,self.avg,self.min_acq,self.max_acq])
                consigne = consigne + 4096
        csvfile.close()
        print_ok("# Log Gain/raman finished; file =  dump_gain_raman.csv")
        return 0


    def verifOnGainAndRaman(self):
        err = 0
        first_acq_skipped = False
        self.ConfigAcqBIST(2000,10000,0,0)
        for consigne in self.get_array_raman():
            self.setGain(self.CONST_GAINS[consigne[0]])
            self.setConsigneRaman(consigne[1])
            print("# Gain:%s, Dac Raman=%d" % (consigne[0],consigne[1] ) ,end=' : ',flush=True)
            if not first_acq_skipped:
                self.StartAndPoolAcq(False)
                first_acq_skipped = True
            self.StartAndPoolAcq(False)
            self.AvgAcq(1000)
            ecart=( abs(self.avg - consigne[2]) / self.avg ) * 100
            noise = (( self.max_acq - self.min_acq) / self.avg ) * 100
            if ecart >  consigne[3]:
                print('%+.3f%% Noise=%.2f'%(ecart,noise))
                print_error("# Gain:%s, Dac Raman=%d, avg value = %f  not in [ %f +/- %d%%]" % (consigne[0],consigne[1],self.avg, consigne[2], consigne[3] ) )
                err = err + 1
            else:
                print_ok('%+.3f%% Noise=%.2f'%(ecart,noise))
            if noise >  consigne[4]:
                print_error("# Gain:%s, Noise=%f %%  > %f %%" % (consigne[0], noise , consigne[4] ) )
                err = err + 1
        return err
        
    def dump_regs(self):
        print("REG_TEETH_NUMBER       %08x" % self.utsbdt.rw_register(UtsBdt.READ, REG_TEETH_NUMBER, 0, 0) )
        print("REG_XOFFSET_DURATION   %08x" % self.utsbdt.rw_register(UtsBdt.READ, REG_XOFFSET_DURATION, 0, 0) )
        print("REG_MASQ_DURATION      %08x" % self.utsbdt.rw_register(UtsBdt.READ, REG_MASQ_DURATION, 0, 0) )
        print("REG_WAIT_DURATION      %08x" % self.utsbdt.rw_register(UtsBdt.READ, REG_WAIT_DURATION, 0, 0) )
        print("REG_NOISE_DURATION     %08x" % self.utsbdt.rw_register(UtsBdt.READ, REG_NOISE_DURATION, 0, 0) )
        print("REG_AVERAGE_NUMBER     %08x" % self.utsbdt.rw_register(UtsBdt.READ, REG_AVERAGE_NUMBER, 0, 0) )
        print("REG_RAMP_INCR          %08x" % self.utsbdt.rw_register(UtsBdt.READ, REG_RAMP_INCR, 0, 0) )
        print("REG_RAMP_RESET_VAL     %08x" % self.utsbdt.rw_register(UtsBdt.READ, REG_RAMP_RESET_VAL, 0, 0) )
        print("REG_COMB_NUMBER        %08x" % self.utsbdt.rw_register(UtsBdt.READ, REG_COMB_NUMBER, 0, 0) )
        print("REG_COMB_INCR          %08x" % self.utsbdt.rw_register(UtsBdt.READ, REG_COMB_INCR, 0, 0) )
        print("REG_CRUNCH_NUMBER      %08x" % self.utsbdt.rw_register(UtsBdt.READ, REG_CRUNCH_NUMBER, 0, 0) )
        print("REG_LPDDR_ADDR_OFFSET  %08x" % self.utsbdt.rw_register(UtsBdt.READ, REG_LPDDR_ADDR_OFFSET, 0, 0) )
        print("REG_LASER_WIDTH_ENT    %08x" % self.utsbdt.rw_register(UtsBdt.READ, REG_LASER_WIDTH_ENT, 0, 0) )
        print("REG_LASER_WIDTH_DEC    %08x" % self.utsbdt.rw_register(UtsBdt.READ, REG_LASER_WIDTH_DEC, 0, 0) )
        print("REG_LASER_ENABLE       %08x" % self.utsbdt.rw_register(UtsBdt.READ, REG_LASER_ENABLE, 0, 0) )
        print("REG_OFFSET_CONTINU     %08x" % self.utsbdt.rw_register(UtsBdt.READ, REG_OFFSET_CONTINU, 0, 0) )
        print("REG_MISC               %08x" % self.utsbdt.rw_register(UtsBdt.READ, REG_MISC, 0, 0) )
        print("REG_HARDWARE_CFG       %08x" % self.utsbdt.rw_register(UtsBdt.READ, REG_HARDWARE_CFG, 0, 0) )
        print("REG_TOTAL_TEETH_NB_CAL %08x" % self.utsbdt.rw_register(UtsBdt.READ, REG_TOTAL_TEETH_NB_CAL, 0, 0) )
        print("REG_FORCE_COMB         %08x" % self.utsbdt.rw_register(UtsBdt.READ, REG_FORCE_COMB, 0, 0) )
        print("REG_FSM                %08x" % self.utsbdt.rw_register(UtsBdt.READ, REG_FSM, 0, 0) )
        print("REG_COUNT_SYNC         %08x" % self.utsbdt.rw_register(UtsBdt.READ, REG_COUNT_SYNC, 0, 0) )
        print("REG_PRIME_RECUR        %08x" % self.utsbdt.rw_register(UtsBdt.READ, REG_PRIME_RECUR, 0, 0) )
        print("REG_DATA_LOG           %08x" % self.utsbdt.rw_register(UtsBdt.READ, REG_DATA_LOG, 0, 0) )
        print("REG_DAC_VCC_APD        %08x" % self.utsbdt.rw_register(UtsBdt.READ, REG_DAC_VCC_APD, 0, 0) )
        print("REG_DAC_CONSIGNE_RAMAN %08x" % self.utsbdt.rw_register(UtsBdt.READ, REG_DAC_CONSIGNE_RAMAN, 0, 0) )
        print("REG_DAC_CONSIGNE_LASER %08x" % self.utsbdt.rw_register(UtsBdt.READ, REG_DAC_CONSIGNE_LASER, 0, 0) )
        print("REG_DAC_CONSIGNE_TEC   %08x" % self.utsbdt.rw_register(UtsBdt.READ, REG_DAC_CONSIGNE_TEC, 0, 0) )
        print("REG_DAC_CONSIGNE_TEC_A %08x" % self.utsbdt.rw_register(UtsBdt.READ, REG_DAC_CONSIGNE_TEC_AUTO, 0, 0) )
        print("REG_PID_Kp             %08x" % self.utsbdt.rw_register(UtsBdt.READ, REG_PID_Kp, 0, 0) )
        print("REG_PID_Ki             %08x" % self.utsbdt.rw_register(UtsBdt.READ, REG_PID_Ki, 0, 0) )
        print("REG_PID_Kd             %08x" % self.utsbdt.rw_register(UtsBdt.READ, REG_PID_Kd, 0, 0) )
        print("REG_PID_P_DEBUG        %08x" % self.utsbdt.rw_register(UtsBdt.READ, REG_PID_P_DEBUG, 0, 0) )
        print("REG_PID_I_DEBUG        %08x" % self.utsbdt.rw_register(UtsBdt.READ, REG_PID_I_DEBUG, 0, 0) )
        print("REG_PID_D_DEBUG        %08x" % self.utsbdt.rw_register(UtsBdt.READ, REG_PID_D_DEBUG, 0, 0) )
        print("REG_PID_LOG            %08x" % self.utsbdt.rw_register(UtsBdt.READ, REG_PID_LOG, 0, 0) )
        print("REG_PID_STATUS         %08x" % self.utsbdt.rw_register(UtsBdt.READ, REG_PID_STATUS, 0, 0) )
        print("REG_MEASI_AVG_RAW      %08x" % self.utsbdt.rw_register(UtsBdt.READ, REG_MEASI_AVG_RAW, 0, 0) )
        print("REG_MEASI_AVG_DUTY     %08x" % self.utsbdt.rw_register(UtsBdt.READ, REG_MEASI_AVG_DUTY, 0, 0) )

    def write_regs(self,adr,mask,val):
        self.utsbdt.rw_register(UtsBdt.WRITE, adr, mask, val)




class helice:
    def __init__(self):
        self.indice=0
        self.liste=["\\","|","/","-"]
    def run(self):
        self.indice+=1
        if self.indice>3 : self.indice=0
        return self.liste[self.indice]

def setPowerAna(val=1):
    if val==0:
        with open("/sys/platform/powersupply/en_tec",'w') as f:    #Disable TEC
            f.write("0")   
    with open("/sys/platform/powersupply/en_sync_psu_digital",'w') as f:    #sync 
        f.write("1")   
    with open("/sys/platform/powersupply/en_pwr_ana",'w') as f:    #Power Ana
        f.write(str(val))   
def setLowITEC(val=1):
    with open("/sys/platform/powersupply/low_i_tec",'w') as f:    #Power Ana
        f.write(str(val))   
def getLowITEC():
    a=open("/sys/platform/powersupply/low_i_tec",'r').read()
    return(int(a,base=0))
def computeShield(value):
    if value>0.8:
        Vshield_state='Shields are missing !'
    else:
        if value>0.7 :
            Vshield_state='Shield bottom is missing !!!'
        else:
            if value>0.6 :
                Vshield_state='Shield top is missing !!!'
            else:
                if value>0.5 :
                    Vshield_state='Shields OK'
                else:
                    Vshield_state='Error on adc_det_shield'
    return(Vshield_state)

def computeVana(value):
    if value>0.515:
        Vana_state='VEE_ana HS !'
    else:
        if value<0.01 :
            Vana_state='VCC_ana & VEE_ana & VCC_1V8 HS!!!'
        else:
            if value<0.35 :
                Vana_state='VCC_ana HS !'
            else:
                if value<0.475:
                    Vana_state='VCC_ana & VEE_ana HS !'
                else:
                    Vana_state='VCC_ana & VEE_ana & VCC_1V8 OK'    
    return(Vana_state)

def computeTemp(Out1):
    try:
        Rth = Rfb /( 2*Out1/Vref + Rfb/R -1 ) -Rx
        Temp = B / (log(Rth) - log(R25) + B/298.15) -273.15    
    except:
        Temp=-99.0
    #~ print("Out1=%f   Rth=%f   Temp=%f"%(Out1,Rth,Temp))
    return(Temp)
    
def XADC(channels=None,repeat=0.5,avgnb=1):
    '''si repeat==None alors retourne valeur et channels doit etre une chaine (utilisé pour recordXADC)
    sinon channels peut etre soit une chaine soit un tupple de chaines'''
    if repeat==None:
        channel=channels
        raw=0
        for i in range(avgnb):
            raw+=str2int(open("/sys/platform/"+channel+"/raw",'r').read())
        value=(raw/1000.0/avgnb-offset[channel])/gain[channel]
        if channel=='adc_vctn':
            value=computeTemp(value)
        return(value)        
    
    if type(channels)!=tuple:
        channels=(channels,)  # il nous faudra un tuple à parcourir
    
    #Analyse des channels passés en parametres
    channelsOK=True
    for channel in channels:
        if channel not in gain.keys():
            channelsOK=False
    
    if channelsOK:
        #On affiche uniquement les voies demandées
        h=helice()
        while(1):
            print("%s"%h.run(),end='')
            for channel in channels:
                #~ value2=float(open("/sys/platform/"+channel+"/value",'r').read())
                raw=0
                for i in range(avgnb):
                    raw+=str2int(open("/sys/platform/"+channel+"/raw",'r').read())
                value=(raw/1000.0/avgnb-offset[channel])/gain[channel]
                if channel=='adc_vctn':
                    value=computeTemp(value)
                print("%6.3f"%(value),end=' | ')
            print("",end='\r',flush=True)
            sleep(repeat)
        
    else:   # On affiche toutes les voies
        Vana_state=''
        Vshield_state=''
        setColor(34)#violet
        print("%20s = %11s, %5s, %5s"%('channel','raw','python','driver')) 
        setColor()
        for name in sorted(gain.keys()):
            chaine=open("/sys/platform/"+name+"/raw",'r').read()
            raw=str2int(chaine)
            valFromRaw=(raw/1000.0-offset[name])/gain[name]#raw/1000 car le driver retourne en mV
            value=float(open("/sys/platform/"+name+"/value",'r').read())
            if name=='adc_vctn':
                valFromRaw=computeTemp(valFromRaw)
                value=computeTemp(value)
            print("%20s = %11s, %6.2f, %6.2f"%(name,chaine.strip(),valFromRaw,value)) 
            if name=='adc_meas_v_ana':
                Vana_state=computeVana(value)
            if name=='adc_det_shield':
                Vshield_state=computeShield(value)
        if 'OK' in Vana_state:
            setColor(32)#vert
        else:
            setColor(31)#rose
        print(Vana_state)
        setColor()
        
        if 'OK' in Vshield_state:
            setColor(32)#vert
        else:
            setColor(31)#rose
        print(Vshield_state)
        setColor()
        
def str2int(chaine):
    if int(chaine,base=0)>  0x7FFFFFFF : #bit de poids fort=1 donc nb negatif
        raw=int(chaine,base=0)-0x100000000
    else: # nb positif
        raw=int(chaine,base=0) #la valeur raw est en hexa
    return(raw)
    
def setVAPD(volts):
    otdr=Otdr_Acq()
    consigne=int(  (volts - 15.358) *65536/85.362 )
    otdr.utsbdt.rw_register(UtsBdt.WRITE, REG_DAC_VCC_APD,     0xFFFFFFFF, consigne)
    print("%d=%Xh"%(consigne,int(consigne)))
    
def setVEE_LASER(volts):
    otdr=Otdr_Acq()
    consigne=int(float(volts)/10*65536)
    otdr.utsbdt.rw_register(UtsBdt.WRITE, REG_DAC_CONSIGNE_LASER,     0xFFFFFFFF, consigne)
    print("%d=%Xh"%(consigne,int(consigne)))

def getVEE_LASER(verbose=False):
    otdr=Otdr_Acq()
    reg=otdr.utsbdt.rw_register(UtsBdt.READ, REG_DAC_CONSIGNE_LASER,     0, 0)
    volts=reg/65536*10
    if verbose:
        print("%Xh=%.2fV"%(reg,volts))
    return(volts)

def getDAC_LASER(surveillance=False,delay=0.5):
    otdr=Otdr_Acq()
    if surveillance:
        h=helice()
        while(1):
            reg=otdr.utsbdt.rw_register(UtsBdt.READ, REG_DAC_CONSIGNE_LASER,     0, 0)
            print("%sDAC_LAS = %d"%(h.run(),reg),end='\r')
            sleep(delay)
    else:
        reg=otdr.utsbdt.rw_register(UtsBdt.READ, REG_DAC_CONSIGNE_LASER,     0, 0)
        if reg<65535:
            return(reg)
        else:
            print('Ramp activated :',end='')
            reg2=otdr.utsbdt.rw_register(UtsBdt.READ, REG_DAC_CONSIGNE_LAS_DELTA,     0, 0)
            minVal=reg2>>16
            maxVal=reg2&0xffff
            print('%d to %d'%(minVal,maxVal))
            return(reg-65536)

def swingDAC_LASER(Delta=1000,demiperiod=1):
    '''
    Mesure sur Laser 1625DFB pour versionB : 126mA/V apres le coude 
    Mesure sur Laser 1625DFB pour versionB : 0.0187mA/DAC apres le coude 
    Donc pour une variation de 50mA max on limite a 0.4V (Delta=+/-0.2V)
    Donc pour une variation de 50mA max on limite a 2600 (Delta=+/-1300)
    '''
    if ( Delta>1300 or Delta<0 ):
        print("Delta < 1300 !!!!")
        return(-1)
        
    milieu=getDAC_LASER()
    haut=milieu+Delta
    bas=milieu-Delta
    
    delais=50e-3
    inc=int(2*Delta*delais/demiperiod)
    
    print(bas,haut,inc)

    otdr=Otdr_Acq()
    val=milieu
    t0=time()
    while 1:
        val+=inc
        if ( val > haut ):
            val=haut
            inc*=-1
            demiperiod=time()-t0
            t0=time()
            print(' demi-periode=%0.2fs'%demiperiod,end='',flush=True)
        elif (val < bas ):
            val=bas
            inc*=-1
            demiperiod=time()-t0
            t0=time()
            print(' demi-periode=%0.2fs'%demiperiod,end='',flush=True)
        print('\r%d'%val,end='',flush=True)
        otdr.utsbdt.rw_register(UtsBdt.WRITE, REG_DAC_CONSIGNE_LASER,     0xFFFFFFFF, val)
        sleep(delais)
    

def setRaman(volts):
    otdr=Otdr_Acq()
    consigne=int(float(volts)/2.5*65535)
    otdr.utsbdt.rw_register(UtsBdt.WRITE, REG_DAC_CONSIGNE_RAMAN,     0xFFFFFFFF, consigne)
    print("%d=%Xh"%(consigne,int(consigne)))

def setTempTEC(T=35,wait=True,verbose=False,withInit=True):
    '''
    T=temp en °C
    T=0 pour desactiver le controleur de Peltier
    '''
    from math import exp

    if T==0:
        with open("/sys/platform/powersupply/en_tec",'w') as f:    #Enable TEC
            f.write("0")   
            print("EN_TEC = 0")
    else:
        otdr=Otdr_Acq()
        Rth = R25 * exp(B*(1/(T+273.15) - 1/298.15))
        Out1 = ((Rfb/(Rth +Rx))-(Rfb/R)+1)*Vref/2
        consigne=int(Out1/2.5*65535)
        otdr.utsbdt.rw_register(UtsBdt.WRITE, REG_DAC_CONSIGNE_TEC,     0xFFFFFFFF, consigne)
        if verbose : print("Out1=%fV => %d=%Xh"%(Out1,consigne,int(consigne)))
        if withInit:
            with open("/sys/platform/powersupply/en_tec",'w') as f:    #Enable TEC
                f.write("1")
        if wait:
            t0=time()
            nbOK=0
            while(time()-t0<10):#timeout de 10s
                sleep(0.1)
                if getTempGood():
                    print("TempGood = 1",end='\r')
                    if nbOK==0 :#front montant sur temp ok
                        t1=time()
                    nbOK+=1
                    if nbOK>5:# tempGood durant 500ms
                        break
                else:
                    print("TempGood = 0",end='\r')
                    nbOK=0
                    
            if nbOK>5:
                print("Temperature regulee au bout de %.1fs"%(t1-t0))
            else:
                print("Impossible de reguler la temperature !")

def switchTempTEC(T1,T2,delay):
    etat=['!!','OK']
    if T1>70 or T1<-20 or T2>70 or T2<-20:
        print("-20 < Temp < 70 !!!!")
        return(-1)
    else:
        while 1:

            setTempTEC(T1,wait=False)
            chaine0="TEC consigne=%3.1f"%T1
            t0=time()
            while(time()-t0<delay):
                meas=XADC('adc_vctn',None)
                print('%s mesure=%3.2f %s'%(chaine0,meas,etat[getTempGood()]),end='\r',flush=True)
                sleep(10e-3)

            setTempTEC(T2,wait=False)
            chaine0="TEC consigne=%3.1f"%T2
            t0=time()
            while(time()-t0<delay):
                meas=XADC('adc_vctn',None)
                print('%s mesure=%3.2f %s'%(chaine0,meas,etat[getTempGood()]),end='\r',flush=True)
                sleep(10e-3)

def getTempGood():
    a=open("/sys/platform/powersupply/tmpgd_tec",'r').read()
    return(int(a,base=0))

def swingTempTEC(T1,T2,delay=0.04,inc=0.2,waitTmpGD=False):
        if T1>70 or T1<-20 or T2>70 or T2<-20:
            print("-20 < Temp < 70 !!!!")
            return(-1)
        else:
            print("delay=%.2f inc=%.2f"%(delay,inc))
            T=T1
            t0=time()
            demiperiod=0.0
            setTempTEC(T,wait=False,withInit=True)
            while 1:
                setTempTEC(T,wait=False,withInit=False)
                print("\rTempTEC=%3.1f"%T,end='',flush=True)
                sleep(delay)
                if getTempGood():
                    TempNotgood='*'
                else:
                    TempNotgood='!'
                print(TempNotgood,end=' ',flush=True)
                if waitTmpGD:
                    while(not getTempGood()):
                        sleep(delay)
                T+=inc
                if (T>=T2 or T<=T1):
                    inc*=-1
                    demiperiod=time()-t0
                    t0=time()
                    print('demi-periode=%0.2fs'%demiperiod,end='',flush=True)

def setStandByAmpli(state):
    with open("/sys/platform/powersupply/standby_ampli",'w') as f:    #StandbyAmpli
        f.write(str(state))
        
def recordXADC(channels,duree=None,avgnb=1):
    rep="/var/lib/ftp/"
    x=''
    y={}

    if (duree!=None and duree<60):
        nbParSec=15 # vitesse max
    else:
        nbParSec=10
    tempo=1.0/nbParSec
    
    #verif liste channels    
    if type(channels)!=tuple:
        channels=(channels,)  # il nous faudra un tuple à parcourir
    
    for channel in channels:
        if channel not in gain.keys():
            print("%s not in channel list"%channel)
            return
        else:
            y[channel]=''
            
    # ******************ancienne fonction*******************************
    #~ # enregistrement dans des listes
    open('/tmp/record_running', 'a').close()
    if duree==None:
        print("%d points par sec (effacer le fichier /tmp/record_running pour stopper)"%(nbParSec))
    else:
        print("%d points par sec pendant %ds = %d points"%(nbParSec,duree,duree*nbParSec))
    debut=debut0=time()
    i=0
    values={}
    while ((duree==None and os.path.isfile('/tmp/record_running')) or (duree!=None and time()-debut0<duree)):
    #~ for i in range(1,duree*nbParSec+1):
        i+=1
        x+=str(time()-debut0)+','
        for channel in channels:
            values[channel]=XADC(channel,repeat=None,avgnb=avgnb)
            y[channel]+=str(values[channel])+','
        sleep(tempo)
        if time()-debut > 1:
            print('\r%d'%(i),end=' ')
            print(values,end=' ',flush=True)
            debut=time()
    fin=time()

    #ecriture dans des fichiers
    for channel in channels:    
        file=rep+channel
        with open(file,'w') as f: 
            f.write(x)
            f.write('\n')
            f.write(y[channel])
            print("\r%d datas recorded in %.1fsecs in %s"%(i,fin-debut0,file))
            
    #affichage pour fenetre plot sur tkinter
    for channel in channels:
        print(channel,end=',')
    print()            
    
    # *********************nouvelle fonction ***********************************
    # cette fct enregistre les données en collone (comme ss xls, et necessite alors de changer la fct plot sous tkinter
    #~ print("%d points par sec "%(nbParSec))
    #~ #ouverture des fichiers
    #~ f={}
    #~ for channel in channels:    
        #~ file=rep+channel
        #~ f[channel]=open(file,'w')
    #~ open('/tmp/record_running', 'a').close()
    
    #~ debut=debut0=time()    
    #~ while ((duree==None and os.path.isfile('/tmp/record_running')) or (duree!=None and time()-debut0<duree)):
        #~ x=time()-debut0
        #~ for channel in channels:
            #~ val=XADC(channel,repeat=None)
            #~ f[channel].write('%f,%f\n'%(x,val))
        #~ sleep(tempo)
        #~ if time()-debut > 1:
            #~ print('\r (val=%6.3f)'%(val),end=' ',flush=True)
            #~ debut=time()
    #~ #Fermeture fichiers
    #~ for channel in channels:    
        #~ f[channel].close()
        #~ print(channel,end=',')
    #~ print()  

            
def stopRecord():
    from os import remove
    try:
        remove('/tmp/record_running')
        print('XADC record stopped')
    except:
        print('was not recording')
        

def dumpAcqFile(sample, filename="acq.csv",skip=0):
    handle = open("/dev/bdt_pws1", "rb")
    directory=r"/var/lib/ftp/"
    if filename[-4:]=='.csv':
        fileName=filename
    else:
        fileName=filename+'.csv'
    if Path(directory+fileName).is_file():
        fileName0=fileName[:-4]
        for i in range(100):
            fileName=fileName0+'_'+str(i)+'.csv'
            if not Path(directory+fileName).is_file():
                break
    with open(directory+fileName,'w') as f:
        for i in range(0,sample):
            data = handle.read(4)
            if i > skip:   #skip first point
                datab = bytearray(data)
                val = datab[0] + datab[1]*0x100 + datab[2]*0x10000 + datab[3]*0x1000000
                f.write(str(val))
                f.write('\n')
    print("'%s' written in %s"%(fileName,directory))

def dumpListinFile(liste, filename="/var/lib/ftp/xadc.csv"):
    with open(filename,'w') as f:
        for el in liste:
            f.write(str(el))
            f.write('\n')
    print("%s written"%filename)

#~ @DIAG("Test APD presence",depends=["analog_powersupply",  "adc", "dac_ht"])
def t_apd(head='',points=2000,avg=5000,augmentation=1.5,gain='GAIN_4K64'):
    '''
    Command must be: t_apd <head> where <head> is 1625DFB|1650FP
    '''
    if head.upper() not in ("1625DFB","1650FP"):
        print_error("Command must be: t_apd(head,avg=500,augmentation=1.5)")
        print_error("<head> is 1625DFB|1650FP")
        return(-1)

    if (head.upper()=="1625DFB"):
        ht = int(CONST("vapd.1625dfb.min",60)) #60
        ht_max = int(CONST("vapd.1625dfb.max",90))#95
    else:
        ht = int(CONST("vapd.1650FP.min",35))
        ht_max = int(CONST("vapd.1650FP.max",60))

    noise_decol = False
    apd_detected = False
    otdr = Otdr_Acq()
    otdr.setConsigneRaman(0)

    print_info("# Enable APD")
    otdr.enableAPD(True)
    setVAPD(20)
    sleep(1)

    print_info("# First acq")

    otdr.setGain(otdr.CONST_GAINS[gain])
    print_info("# %s"%gain)

    otdr.ConfigAcqBIST(points*5,avg,0, 0 )#Pour le niveau initial on fait 5x plus de points
    otdr.StartAndPoolAcq(False)
    otdr.AvgAcq(points)
    initial_noise = (( otdr.max_acq - otdr.min_acq) / otdr.avg ) * 100
    initial_offset = otdr.avg
    target_noise = initial_noise*augmentation
    target_offset = initial_offset*augmentation
    print_info("* Initial Noise = %.3e => Target Noise = %.3e (Avg=%d)" %(initial_noise,target_noise,otdr.avg))
    dumpAcqFile(points*5,skip=300,)

    otdr.ConfigAcqBIST(points,avg,0, 0 )
    inc_ht = 0.5
    val_detected= 0

    while (ht < ht_max) and (noise_decol == False):
        ht += inc_ht
        if ht < val_detected:
            print_error("Niveau de bruit pas regulier")
            setVAPD(20)
            return
        setVAPD(ht)
        sleep(60e-3)#temps d'établissement VAPD 
        otdr.StartAndPoolAcq(False)
        #~ noise = otdr.getBufferNoise(avg)
        otdr.AvgAcq(points)
        noise = (( otdr.max_acq - otdr.min_acq) / otdr.avg ) * 100
        print("# HT = %5.2f   Vapd=%5.2f => Noise *%.2f (Avg=%d)" %(ht,sysfs_read("/sys/platform/adc_vcc_apd/value"),noise/initial_noise,otdr.avg),end='\r',flush=True)
        if not apd_detected :#la 1ère fois
            if (noise > target_noise or otdr.avg>target_offset):
                apd_detected = True
                val_detected=ht-inc_ht
                print_info("\n# APD detected")
                #~ inc_ht = -0.1# on redescend doucement
                ht -= inc_ht #retour au point precedent
                inc_ht = 0.1# on monte doucement
                dumpAcqFile(2000,skip=300)
        else:#recherche fine
            #~ if (noise < target_noise):
            if (noise > target_noise or otdr.avg>target_offset):
                noise_decol = True
                sleep(0.5) #temps de stabilisation mesure ADC
                print_info("# DAC_APD=%.2fV   ADC_Vapd=%5.2fV"%(ht,sysfs_read("/sys/platform/adc_vcc_apd/value")))
                setVAPD(ht-2)
    otdr.enableAPD(False)
    dumpAcqFile(2000,skip=300)
    if not apd_detected:
        print_error("\n# APD not detected !")
        setVAPD(20)
    return noise_decol

#~ @DIAG("Test Acquisition",depends=["analog_powersupply",  "analog_powersupply","dac_las", "adc", "dac_ht"])
def real_acquisition(cmd=''):
    '''
    real_acquisition 20000 100000 48 2 3 2.2 42.5 # VEE_LASER=2.2V pour 250mA
    real_acquisition 20000 10 48 2 3 2.2 42.5 # VEE_LASER=2.2V pour 250mA
    '''
    try:
        (teeth, duration, pulse, laser, gain, vee_laser,vapd) = cmd.split()
        #~ (command,teeth, duration, pulse, laser, gain, vee_laser,vapd) = cmd.split()
        #~ print(cmd)
    except:
        print_error("# Command must be: real_acqusition <teeth> <duration> <pulse> <laser> <gain> <vee_laser> <vapd>")
        return False
    Teeth=int(teeth)
    Pulse=int(pulse)
    Duration=float(duration)
    Laser=int(laser)

    print_info("Pulse=%g Gain=%d APD=%.1fV VEElas=%.1fV Range=%dkm"%(int(pulse)*6.25e-9,int(gain),float(vapd),float(vee_laser),int(teeth)*6.25/10000))
    
    chaine="%dns-G%d-%.1fV-%.1fV-%dkm-%dsec"%(int(pulse)*6.25,int(gain),float(vapd),float(vee_laser),int(teeth)*6.25/10000,Duration)
    
    if('n' in input(chaine+" OK? (y/n)").lower()):
        return("Abort")
        
    #Reglages
    setStandByAmpli(0)
    setVAPD(float(vapd))
    setVEE_LASER(float(vee_laser))
    otdr = Otdr_Acq()
    otdr.write_regs(REG_HARDWARE_CFG,0x7,int(gain))
    otdr.setConsigneRaman(0)
    sleep(0.5)
    Recurrence=max(Teeth+310,Pulse*100) 
    Avg=int(Duration/(Recurrence*6.25e-9)) #duration(sec), Recurrence(pts)
    
    #Tire et acquisition
    otdr.utsbdt.rw_register(UtsBdt.WRITE, REG_MISC, REG_MISC_EN_CUMUL, 0)#cumul disabled
    t0=time()
    while Avg>65535:
        print("Avg=%d"%Avg,end=',',flush=True)
        otdr.utsbdt.rw_register(UtsBdt.WRITE, REG_MISC, REG_MISC_EN_CUMUL, REG_MISC_EN_CUMUL)#cumul enabled
        otdr.ConfigAcqBIST(Teeth,65535,Pulse,Laser)
        otdr.StartAndPoolAcqAndMeasI(True)
        Avg-=65535
    #dernieres mesures
    print_info("Avg=%d"%Avg)
    otdr.ConfigAcqBIST(Teeth,Avg,Pulse,Laser)
    ilas=otdr.StartAndPoolAcqAndMeasI(True)
    print_info("%.2fsec"%(time()-t0))
    #Fin
    print_info('Ilas=%.3fA'%ilas)
    otdr.utsbdt.rw_register(UtsBdt.WRITE, REG_MISC, REG_MISC_EN_CUMUL, 0)#cumul disabled
    dumpAcqFile(Teeth+300,filename=chaine)
    setVAPD(20)
    setVEE_LASER(0)
    setStandByAmpli(1)
    
#~ def LAS_IN_PROGRESS(otdr):
    #~ reg=otdr.utsbdt.rw_register(UtsBdt.READ, REG_MISC,  0, 0)
    #~ return(reg>>21 &1)

def surv_REG_MISC(bitNb=None,delay=200e-3):
    '''
    Pour surveiller le bit21 (22ème) LAS_IN_PROGRESS :
    surv_REG_MISC(21,delay=10e-3)
    '''
    otdr=Otdr_Acq()
    nb0=nb1=0
    h=helice()
    while(1):
        reg=otdr.utsbdt.rw_register(UtsBdt.READ, REG_MISC,  0, 0)
        
        if bitNb==None:#On affiche le registre complet
            print("%sREG_MISC = 0x%X"%(h.run(),reg),end='\r')
            
        else:#On affiche uniquement le bit demandé
            bit=reg>>bitNb &1
            if bit==0 :
                nb0+=1
            else:
                nb1+=1
            print("%sBit%d = %d (nb0=%6d, nb1=%6d)"%(h.run(),bitNb,bit,nb0,nb1),end='\r')
        sleep(delay)

def getLaserWidth(verbose=True):
    otdr=Otdr_Acq()
    LW_ENT=otdr.utsbdt.rw_register(UtsBdt.READ, REG_LASER_WIDTH_ENT,  0, 0)
    LW_DEC=otdr.utsbdt.rw_register(UtsBdt.READ, REG_LASER_WIDTH_DEC,  0, 0)
    if verbose:
        print('LW_ENT=%s *6.25ns'%LW_ENT)
        print('LW_DEC=%s *1.5625ns'%LW_DEC)
    if LW_DEC==0x1 : value=LW_ENT*6.25+1.5625
    elif LW_DEC==0x3 : value=LW_ENT*6.25+3.125
    elif LW_DEC==0x7 : value=LW_ENT*6.25+4.6875
    elif LW_DEC==0xF : value=LW_ENT*6.25+6.25
    else : value=LW_ENT*6.25
    return(value)

def setLaserWidth(LW_ENT,LW_DEC):
    otdr=Otdr_Acq()
    otdr.utsbdt.rw_register(UtsBdt.WRITE, REG_LASER_WIDTH_ENT,  0xFFF, LW_ENT)
    otdr.utsbdt.rw_register(UtsBdt.WRITE, REG_LASER_WIDTH_DEC,  0xFFF, LW_DEC)
    print('Pulse width = %.4fns'%getLaserWidth(False))

def setAD9634_Register(address,value):
    open("/sys/platform/adcbdt/address",'w').write(str(address))
    open("/sys/platform/adcbdt/value",'w').write(str(value))
    open("/sys/platform/adcbdt/address",'w').write('0xFF')
    open("/sys/platform/adcbdt/value",'w').write('0x1')
    print('0x%x = %s'%(address,get_AD9634_Register(address)))
        
def getAD9634_Register(address):
    open("/sys/platform/adcbdt/address",'w').write(str(address))
    return(open("/sys/platform/adcbdt/value",'r').read())
def startRampeILAS(las_min,las_max):
    otdr=Otdr_Acq()
    otdr.utsbdt.rw_register(UtsBdt.WRITE, REG_DAC_CONSIGNE_LASER, 0x00010000, 0x00010000 )#activation du bit auto
    otdr.utsbdt.rw_register(UtsBdt.WRITE, REG_DAC_CONSIGNE_LAS_DELTA, 0xFFFFFFFF, (int(las_min) << 16) | int(las_max) )
def stopRamplas():
    otdr=Otdr_Acq()
    otdr.utsbdt.rw_register(UtsBdt.WRITE, REG_DAC_CONSIGNE_LASER, 0x00010000, 0x00000000 )#desactivation du bit auto
    val=getDAC_LASER()
    print('DAC_LAS= %d = 0x%X'%(val,val))
    
def PID_readConfig(otdr=None):
    if otdr==None:
        otdr=Otdr_Acq()
    kp_reg=otdr.utsbdt.rw_register(UtsBdt.READ, REG_PID_Kp,  0, 0)
    Kp=kp_reg&0x0000FFFF
    Decal=(kp_reg&0x00FF0000)>>16
    KpDiv=1<<Decal
    Status_reg=otdr.utsbdt.rw_register(UtsBdt.READ, REG_PID_STATUS,  0, 0)
    EnablePID=(Status_reg&0x1)
    ki_reg=otdr.utsbdt.rw_register(UtsBdt.READ, REG_PID_Ki,  0, 0)
    Ki=ki_reg&0x0000FFFF
    Decal=(ki_reg&0x00FF0000)>>16
    KiDiv=1<<Decal
    kd_reg=otdr.utsbdt.rw_register(UtsBdt.READ, REG_PID_Kd,  0, 0)
    Kd=kd_reg&0x0000FFFF
    Decal=(kd_reg&0x00FF0000)>>16
    KdDiv=1<<Decal
    print("PIDnum_enable=%d (Kp=%d / %d, Ki=%d / %d, Kd=%d / %d)"%(EnablePID,Kp,KpDiv,Ki,KiDiv,Kd,KdDiv))
    
def PID_enable(enable=True,verbose=True):
    otdr=Otdr_Acq()
    if enable:
        otdr.utsbdt.rw_register(UtsBdt.WRITE, REG_PID_STATUS, 0x3, 0x1 )#sans toucher aux bits de poids fort (bit enable & bit reset fifo)
    else:
        otdr.utsbdt.rw_register(UtsBdt.WRITE, REG_PID_STATUS, 0x3, 0x2 )#sans toucher aux bits de poids fort
    if verbose:
        PID_readConfig(otdr)    
        
def PID_set(Kp=None,KpDecal=None,Ki=None,KiDecal=None,Kd=None,KdDecal=None):
    otdr=Otdr_Acq()
    if Kp==None and Ki==None and Kd==None and KpDecal==None and KiDecal==None and KdDecal==None:
        Kp=512
        Ki=5
        Kd=2048
        KpDecal=10
        KiDecal=10
        KdDecal=10
    if Kp!=None:
        otdr.utsbdt.rw_register(UtsBdt.WRITE, REG_PID_Kp, 0x0000FFFF, Kp )
    if Ki!=None:
        otdr.utsbdt.rw_register(UtsBdt.WRITE, REG_PID_Ki, 0x0000FFFF, Ki )
    if Kd!=None:
        otdr.utsbdt.rw_register(UtsBdt.WRITE, REG_PID_Kd, 0x0000FFFF, Kd )
    if KpDecal!=None:
        otdr.utsbdt.rw_register(UtsBdt.WRITE, REG_PID_Kp, 0x00FF0000, KpDecal<<16 )#sans toucher au bit de poids fort (enable PID num)
    if KiDecal!=None:
        otdr.utsbdt.rw_register(UtsBdt.WRITE, REG_PID_Ki, 0x00FF0000, KiDecal<<16 )#sans toucher au bit de poids fort (enable PID num)
    if KdDecal!=None:
        otdr.utsbdt.rw_register(UtsBdt.WRITE, REG_PID_Kd, 0x00FF0000, KdDecal<<16 )#sans toucher au bit de poids fort (enable PID num)
    PID_enable(1)
    #~ setTempTEC(25,wait=False)

def PID_status():
    otdr=Otdr_Acq()
    Status_reg=otdr.utsbdt.rw_register(UtsBdt.READ, REG_PID_STATUS,  0, 0)    
    tec_auto = 0
    while 1:
        Log_reg=otdr.utsbdt.rw_register(UtsBdt.READ, REG_PID_LOG,  0, 0)
        val=otdr.utsbdt.rw_register(UtsBdt.READ, REG_DAC_CONSIGNE_TEC,  0, 0)
        tec_auto = (val&0x10000)>>16
        DAC=(Log_reg&0xffff0000)>>16
        ADC=(Log_reg&0xffff)
        Status_reg=otdr.utsbdt.rw_register(UtsBdt.READ, REG_PID_STATUS,  0, 0)    
        overf=(Status_reg&0x80000000)>>31 
        underf=(Status_reg&0x40000000)>>30 
        print('DAC=0x%04X ADC=0x%04X AUTO=%d O=%d U=%d'%(DAC,ADC,tec_auto,overf,underf))

def PID_readRegs(repeat=False):
    otdr=Otdr_Acq()
    val=otdr.utsbdt.rw_register(UtsBdt.READ, REG_DAC_CONSIGNE_TEC,  0, 0) 
    print('Consigne=0x%04X'%(val))
    while 1:
        val_p=otdr.utsbdt.rw_register(UtsBdt.READ, REG_PID_P_DEBUG,  0, 0) 
        val_i=otdr.utsbdt.rw_register(UtsBdt.READ, REG_PID_I_DEBUG,  0, 0) 
        val_d=otdr.utsbdt.rw_register(UtsBdt.READ, REG_PID_D_DEBUG,  0, 0) 
        print('P=0x%08X I=0x%08X D=0x%08X'%(val_p, val_i,val_d),end=' ')
        Log_reg=otdr.utsbdt.rw_register(UtsBdt.READ, REG_PID_LOG,  0, 0)
        DAC=(Log_reg&0xffff0000)>>16
        ADC=(Log_reg&0xffff)
        print('DAC=0x%04X ADC=0x%04X'%(DAC, ADC),end='\r',flush=True)
        #~ temp = computeTemp(ADC/65536/gain['adc_vctn'])
        #~ print('Temperature = %6.3f'%(temp))
        if not repeat:
            print()
            break
        sleep(0.25)

def getMeasIavg(otdr=None,debug=False,capacitor=300e-12):
    if otdr==None:
        otdr=Otdr_Acq()

    R302=10
    Gain_U69=1+9900*(1/464+1/1000)
    R648=10000
    R324=3320
        
    veelas=XADC('adc_meas_vee_laser',repeat=None)
    rkm=otdr.utsbdt.rw_register(UtsBdt.READ, REG_PRIME_RECUR,  0, 0)*6.25 #ns
    raw=otdr.utsbdt.rw_register(UtsBdt.READ, REG_MEASI_AVG_RAW,  0, 0)
    dutyCycle=otdr.utsbdt.rw_register(UtsBdt.READ, REG_MEASI_AVG_DUTY,  0, 0)/2**26
    dutyCycle=getLaserWidth(0)/rkm #autre methode
    try:
        iavg=raw/R302/Gain_U69*(R324+R648)/R324/65536
        iavg-=capacitor*veelas/(rkm*1.e-9) #compensation des pertes par commutation dans capa trans pulseur
        ilas=iavg/dutyCycle
    except:
        ilas=0.0
    
    if debug:
        return(dutyCycle,raw,ilas)
    else:
        return(ilas)

def survMeasIavg():
    h=helice()
    otdr=Otdr_Acq()
    while 1:
        dutyCycle,raw,ilas=getMeasIavg(otdr,True)
        print('%s Raw=0x%04X DutyCycle=%f%% ILAS=%5.3fA   \r'%(h.run(),raw,dutyCycle*100,ilas),end='',flush=True)
        sleep(0.1)
    
def getHWrev():
    return(open("/sys/platform/hwrev/value",'r').read())
