from .ioctlutil import *
import fcntl

_UTS_BDT_IO_MAGIC = 0xD3
# define BDT_CONF_ACQ    _IOWR(cUTS_BDT_IO_MAGIC, 0, tBdt_Conf_Acq)
_BDT_RW_REGISTER = IOWR(_UTS_BDT_IO_MAGIC, 1, "IILL")
# define BDT_CHOOSE_OTDR   _IOWR(cUTS_BDT_IO_MAGIC, 2, tHw_Module_Position)
# define BDT_START_ACQ       _IO(cUTS_BDT_IO_MAGIC, 3)
# define BDT_WAIT_ACQ           _IO(cUTS_BDT_IO_MAGIC, 4)
# define BDT_DUMP_ACQ           _IOWR(cUTS_BDT_IO_MAGIC, 5, tBdt_Dump_Acq)
# define BDT_CHOOSE_OSA    _IOWR(cUTS_BDT_IO_MAGIC, 6, tHw_Module_Position)
# define BDT_GET_SPI_POSITION   _IOWR(cUTS_BDT_IO_MAGIC, 7, tScan_Position)
_BDT_GET_VERSION = IOR(_UTS_BDT_IO_MAGIC, 8, 4)
# define BDT_LOCK_LVDS_PLL      _IO(cUTS_BDT_IO_MAGIC, 9)
# define BDT_GET_BUFFER         _IOWR(cUTS_BDT_IO_MAGIC, 10, tBdt_Buffer)
# define BDT_GET_DRIVER_VERSION _IOR(cUTS_BDT_IO_MAGIC, 11, float *)


class _Bdt_Rw_Register(ctypes.Structure):
    _fields_ = [
        ('RW_Flag', ctypes.c_int),
        ('Address', ctypes.c_uint),
        ('Mask',    ctypes.c_ulong),
        ('Data',    ctypes.c_ulong)
        ]


class NotImplemented(Exception):
    pass


class UtsBdt(object):
    '''
    Class to use IOCTL from driver pci-bdt
    '''
    READ = 1
    WRITE = 0

    def __init__(self, device):
        self.__dev = device
        self.__fd = None

    def open(self):
        if self.__fd is None:
            self.__fd = open(self.__dev, "rb")

    def close(self):
        if self.__fd is not None:
            self.__fd.close()
            self.__fd = None

    def rw_register(self, rw, addr, mask, data):
        if rw == self.READ:
            mask = 0xFFFFFFFF
        arg = _Bdt_Rw_Register()
        arg.RW_Flag = rw
        arg.Address = addr
        arg.Mask = mask
        arg.Data = data
        if self.__fd is not None:
            fcntl.ioctl(self.__fd, _BDT_RW_REGISTER, arg)
        else:
            with open(self.__dev, "rb") as f:
                fcntl.ioctl(f, _BDT_RW_REGISTER, arg)
        return arg.Data

    def get_buffer(self):
        raise NotImplemented()

    def dump_acq(self):
        raise NotImplemented()

    def lock_lvds_pll(self):
        raise NotImplemented()

    def get_version(self):
        vers = ctypes.c_uint()
        with open(self.__dev, "rb") as f:
            fcntl.ioctl(f, _BDT_GET_VERSION, vers)
        return vers.value

    def read(self, size):
        data = None
        if self.__fd is not None:
            data = self.__fd.read(size)
        else:
            with open(self.__dev, "rb") as f:
                data = f.read(size)
        return data
