import bz2, os, sys, base64, traceback, hashlib, subprocess, linecache, time, socket, threading
from lxml import etree
import urllib.request as urlreq
from urllib.error import HTTPError, URLError
import importlib
import jdsu.mts as mts

def PrintException():
    exc_type, exc_obj, tb = sys.exc_info()
    f = tb.tb_frame
    lineno = tb.tb_lineno
    filename = f.f_code.co_filename
    linecache.checkcache(filename)
    line = linecache.getline(filename, lineno, f.f_globals)
    print('EXCEPTION IN ({}, LINE {} "{}"): {}'.format(filename, lineno, line.strip(), exc_obj))
    traceback.print_exception(exc_type, exc_obj, tb, limit=5, file=sys.stdout)

def get_hooks(xmlrelease):
    h = None
    hooks = xmlrelease.xpath("hooks")
    if len(hooks) > 0:
        hk = bz2.decompress(base64.b64decode(hooks[0].text.encode("ASCII")))
        os.system("rm -fr /tmp/hook")
        os.system("mkdir /tmp/hook")
        sys.path.append("/tmp/hook")
        out = open("/tmp/hook/hook.py", "w")
        hooksrc = hk.decode("ASCII")
        hooksrc = hooksrc.replace("except Exception, err:","except Exception as err:")
        hooksrc = hooksrc.replace("except subprocess.CalledProcessError, err:","except subprocess.CalledProcessError as err:")
        hooksrc = hooksrc.replace("print err","print(err)")
        out.write(hooksrc)
        out.close()
        h = __import__("hook")
    return h

def run_hook(hook, name):
    print("Run hook %s" % name)
    if hook is None:
        return True
    try:
        if name in list(hook.__dict__.keys()):
            function = hook.__dict__[name]
            return function()
    except Exception as err:
        PrintException()
        return False
    print("No hook %s exists" % name)
    return True

def split_url(url):
    u = url.split(":")
    index = int(u[0])
    url = ":".join(u[1:])
    return (url, index)


def check_release(url, proxy):
    res = False
    (xmlrelease, valid) = get_release_xml(url, proxy)
    if not valid:
        return False
    try:
        hook = get_hooks(xmlrelease)
        res = pre_check()
        if res:
            res = run_hook(hook, 'pre_install_check')

    except Exception as err:
        print("Check release failed")
        PrintException()
    return res

def get_user_agent():
    if len(get_user_agent.user_agent) < 5:
        platform = "unknown"
        serialnb = "00001"
        version  = "00000"

        try:
            platform = os.environ["CFG_PLATFORM_FRIENDLY_NAME"].replace(" ","_")
        except:
            try:
                with open("/etc/platform.conf") as fp:
                    for line in fp:
                        if "CFG_PLATFORM_FRIENDLY_NAME" in line:
                            platform = line.split("=")[1].strip().strip("\"").replace(" ","_")
            except:
                pass

        try:
            with open("/proc/device-tree/board/serial-number") as snb:
                serialnb = snb.read().strip()
            # Add prefix if prefix is set
            with open("/cal/board_info.bin", "rb") as calfile:
                cal = calfile.read(0x120)
                if cal[0x10D] != 0:
                    serialnb = cal[0x10D:0x111].decode("ascii") + serialnb
        except:
            pass

        try:
            tree = etree.parse("/etc/release/current.xml")
            version = tree.xpath("//release/@name")[0]
        except:
            pass

        result = ["BaseId"]
        result.append("SID00000000")
        result.append(platform)
        result.append(serialnb)
        result.append(version)
        result.append("INFO")

        get_user_agent.user_agent = "_".join(result)
    return get_user_agent.user_agent
get_user_agent.user_agent = ""

def get_release_xml(url, proxy):
    (release, slot) = split_url(url)
    release_file = None
    valid = True
    if "http://" in release:
        # Download XML file
        if proxy is not None and proxy.strip() != "DIRECT":
            print("Enable proxy %s" % proxy)
            proxy_handler = urlreq.ProxyHandler({'http': proxy})
        else:
            print("Disable proxy")
            proxy_handler = urlreq.ProxyHandler({})
        opener = urlreq.build_opener(proxy_handler)
        opener.addheaders = [('User-Agent', get_user_agent())]
        urlreq.install_opener(opener)

        # Check mymirror.php
        base_url = release.replace("http://", "").split("/")[0]
        mymirror_url = "http://%s/mymirror.php" % (base_url)
        req = urlreq.Request(mymirror_url)
        try:
            mirror = urlreq.urlopen(req).read().decode('ascii')
            release = release.replace(base_url, mirror)
            url = url.replace(base_url, mirror)
            print("Release with mirror: %s" % release)
        except HTTPError:
            pass

        release_file = "/var/volatile/release.xml"
        req = urlreq.Request(release)
        try:
            with open(release_file, "wb") as local_file:
                f = urlreq.urlopen(req)
                local_file.write(f.read())
        except HTTPError as e:
            print("HTTP Error:%s %s"%(e.code, release))
            PrintException()
            return None, None
        except URLError as e:
            print("URL Error: %s %s"%(e.reason, release))
            PrintException()
            return None, None

        # Download signature
        if not os.path.exists("/etc/release/no_check"):
            req = urlreq.Request(release + ".sig")
            try:
                with open(release_file + ".sig", "wb") as local_file:
                    f = urlreq.urlopen(req)
                    local_file.write(f.read())
            except HTTPError as e:
                print("HTTP Error:%s %s"%(e.code, release))
                PrintException()
                valid = False
            except URLError as e:
                print("URL Error:%s %s"%(e.reason, release))
                PrintException()
                valid = False
    else:  # USB Media
        release_file = release

    # Check signature
    if not os.path.exists("/etc/release/no_check"):
        try:
            print(subprocess.check_output(["gpg", "--verify", release_file + ".sig", release_file]))
        except Exception as e:
            print("BAD SIGNATURE %s" % str(e))
            PrintException()
            valid = False
    xmlrelease = ReleaseXML(release_file, url)

    # Check machine
    release_machine = xmlrelease.xpath("/root/release/@device",True)[0].strip()
    real_machine = mts.getMachineName()
    if release_machine != real_machine:
        print("Release for %s not for %s" % (release_machine, real_machine))
        valid = False

    if valid:
        try:
            hook = get_hooks(xmlrelease)
            run_hook(hook, 'inspect_hook')
        except Exception:
            pass

    # Check all restriction provide by the current version
    filters = os.listdir("/etc/release/filters")
    sys.path.append(os.path.abspath("/etc/release/filters"))
    for filter in filters:
        if(filter.endswith(".py")):
            print("FIND FILTER: %s"%filter)
            try:
                ft = __import__(filter.replace(".py",""))
                importlib.reload(ft)
                if not ft.filter(xmlrelease):
                    print("Filter %s forbid this installation"%filter.replace(".py",""))
                    valid = False
            except Exception as err:
                print("Filter %s ERROR: %s"%(filter.replace(".py",""), err))
                pass

    return (xmlrelease, valid)


# Use for compatibility with release < FS 8.41 (python2 release-manager)
def pre_check():
    class DelayMsg(threading.Thread):
        def __init__(self, msg):
            threading.Thread.__init__(self)
            self.msg = msg

        def run(self):
            time.sleep(0.1)
            s = socket.socket(socket.AF_INET, socket.SOCK_STREAM)
            s.connect(("127.0.0.1", 8000))
            s.send(b"*rem\n")
            umsg = "proc:warning \"Upgrade\",\"%s\",WARN,1,\"Ok\",\"\",\"Click Ok to exit\"\n"%self.msg
            s.send(umsg.encode('utf-8'))
            s.close()

    df = subprocess.Popen(["df", "/user/disk"], stdout=subprocess.PIPE)
    output = df.communicate()[0].decode("utf-8")
    available = int(output.split("\n")[1].split()[3])
    if available < 15360:
        d = DelayMsg("Not enough space available on user Disk")
        d.start()
        return False
    # Avoid bug in wifi upgrade
    for f in os.listdir("/etc/rc4.d"):
        if "NetworkManager" in f:
            os.unlink("/etc/rc4.d/%s"%f)
    return True



def md5(fname):
    hash_md5 = hashlib.md5()
    with open(fname, "rb") as f:
        for chunk in iter(lambda: f.read(4096), b""):
            hash_md5.update(chunk)
    return hash_md5.hexdigest()


class ReleaseXML(object):
    def __init__(self, release_file, url):
        self.__root = etree.parse(release_file)
        self.__url = url
        if url is not None:
            (self.__release, self.__slot) = split_url(url)
            self.__root.xpath("/root")[0].attrib['url'] = url
        else:
            url = self.__root.xpath("/root/@url")[0]
            (self.__release, self.__slot) = split_url(url)

    def xpath(self, path, direct = False):
        if direct:
            return self.__root.xpath(path)
        return self.__root.xpath("/root/release/%s"%path)

    def url(self):
        return self.__url

    def save(self, fname):
        with open(fname, "w") as f:
            f.write(etree.tostring(self.__root).decode("utf-8"))

    def serialize(self):
        return (etree.tostring(self.__root))

    def remote(self):
        (release, slot) = split_url(self.__url)
        return ("http://" in release)

    def xml_apply_to_product(self):
        return self.__root.xpath("/root/release/@device")[0] == mts.getMachineName()


def current_release_xml():
    if not os.path.isfile("/etc/release/current.xml"):
        return None
    return ReleaseXML("/etc/release/current.xml", None)



def show_diff(url, proxy):
    def padd(v):
        t = v.split(".")
        t[0] = "%05i" % int(t[0])
        return ".".join(t)

    tmp = []
    current_xml = current_release_xml()
    (dist_xml, valid) = get_release_xml(url, proxy)

    if current_xml is None:
        for dist_item in dist_xml.xpath("content/item"):
            d = dist_item.attrib["date"].split("-")
            d.reverse()
            tmp.append("ISU: RPM     : \"%-20s\" > %15s %s" % (
                dist_item.attrib["name"], dist_item.attrib["version"].replace("V", ""), "/".join(d)))
        for dist_provide in dist_xml.xpath("content/provide"):
            d = dist_provide.attrib["date"].split("-")
            d.reverse()
            tmp.append("ISU: RELEASE : \"0\" ! %15s %s" % (dist_provide.attrib["version"].replace("V", ""), "/".join(d)))

    else:
        for dist_item in dist_xml.xpath("content/item"):
            ritem = current_xml.xpath("content/item[@name='%s']" % dist_item.attrib["name"])
            d = dist_item.attrib["date"].split("-")
            d.reverse()
            if len(ritem) == 0:
                tmp.append("ISU: RPM     : \"%-20s\" > %15s %s" % (
                    dist_item.attrib["name"], dist_item.attrib["version"].replace("V", ""), "/".join(d)))
                continue
            current_item = ritem[0]
            if padd(current_item.attrib["version"].replace("V", "")) > padd(dist_item.attrib["version"].replace("V", "")):
                tmp.append("ISU: RPM     : \"%-20s\" < %15s %s" % (
                    dist_item.attrib["name"], dist_item.attrib["version"].replace("V", ""), "/".join(d)))
            elif padd(current_item.attrib["version"].replace("V", "")) < padd(dist_item.attrib["version"].replace("V", "")):
                tmp.append("ISU: RPM     : \"%-20s\" > %15s %s" % (
                    dist_item.attrib["name"], dist_item.attrib["version"].replace("V", ""), "/".join(d)))
            elif current_item.attrib["date"] > dist_item.attrib["date"]:
                tmp.append("ISU: RPM     : \"%-20s\" < %15s %s" % (
                    dist_item.attrib["name"], dist_item.attrib["version"].replace("V", ""), "/".join(d)))
            elif current_item.attrib["date"] < dist_item.attrib["date"]:
                tmp.append("ISU: RPM     : \"%-20s\" > %15s %s" % (
                    dist_item.attrib["name"], dist_item.attrib["version"].replace("V", ""), "/".join(d)))
            else:
                tmp.append("ISU: RPM     : \"%-20s\" = %15s %s" % (
                    dist_item.attrib["name"], dist_item.attrib["version"].replace("V", ""), "/".join(d)))

        for current_provide in current_xml.xpath("content/provide"):
            dist_provide = dist_xml.xpath("content/provide[@name='%s']" % current_provide.attrib["name"])[0]
            d = dist_provide.attrib["date"].split("-")
            d.reverse()
            if int(current_provide.attrib["version"]) != int(dist_provide.attrib["version"]):
                tmp.append("ISU: RELEASE : \"%-20s\" ! %15s %s" % (
                    dist_provide.attrib["name"], dist_provide.attrib["version"].replace("V", ""), "/".join(d)))
            else:
                tmp.append("ISU: RELEASE : \"%-20s\" = %15s %s" % (
                    dist_provide.attrib["name"], dist_provide.attrib["version"].replace("V", ""), "/".join(d)))
    if not valid:
        tmp.append("ISU: RPM     : \"Corrupted Media !!!\"")

    order = ["Boo", "Lin", "Fil", "Ins", "Mic", "Fib"]
    order_list = []
    for i in order:
        item = None
        for s in tmp:
            if s.startswith("ISU: RPM     : \"%s" % i):
                item = s
                break
        if item is not None:
            order_list.append(item)
            tmp.remove(item)
    for rest in tmp:
        order_list.append(rest)
    return "\n".join(order_list)


def show_highlighted(url, proxy):
    if url == "current":
        xml = current_release_xml()
        valid = True
    else:
        (xml, valid) = get_release_xml(url, proxy)
    tmp = []
    if not valid:
        return "ERROR"

    for item in xml.xpath("content/item"):
        d = item.attrib["date"].split("-")
        d.reverse()
        tmp.append("ISU: RPM     : \"%-20s\" = %15s %s" % (
            item.attrib["name"], item.attrib["version"].replace("V", ""), "/".join(d)))

    for provide in xml.xpath("content/provide"):
        d = provide.attrib["date"].split("-")
        d.reverse()
        tmp.append("ISU: RELEASE : \"%-20s\" - %15s %s" % (
            provide.attrib["name"], provide.attrib["version"].replace("V", ""), "/".join(d)))
    tmp.append("OK")
    return "\n".join(tmp)
