import re, urllib.request
from jdsu.evm import *


@COMMAND("env", {"print": {}, "get": {}, "set": {}, "load": {}})
def env_command(cmd):
    envlist = __builtins__["environment"].keys()
    for key in envlist:
        k = str(key)
        env_command.parameters["get"][k] = {}
        env_command.parameters["set"][k] = {}
    options = list(env_command.parameters.keys())
    params = cmd.split()[1:]
    name = cmd.split()[0]
    if len(params) == 0:
        print_help(">"+name+" ("+"|".join(options)+")")
        return
    if len(params) == 1:
            if params[0] == "help":
                print_help(">"+name+" ("+"|".join(options)+")")
                return
    if params[0] not in options:
        print_error("SyntaxError "+params[0])
        print_help(">"+name+" ("+"|".join(options)+")")
        return

    if params[0] == "print":
        if len(params) != 1:
            print_error("SyntaxError")
            print_help(">env print")
        else:
            for key in envlist:
                print_ok(key+":"+"_"*(60-len(key))+str(env(key)))

    if params[0] == "get":
        if len(params) != 2:
            print_error("SyntaxError")
            print_help(">env get PATTERN")
        else:
            expr = re.compile(("^" + params[1] + "$").replace("*", ".*"))
            for key in envlist:
                if(expr.match(key)):
                    print_ok(key+":"+"_"*(60-len(key))+str(env(key)))

    if params[0] == "set":
        if len(params) == 3:
            command = params[1]
            value = params[2]
            print_ok("### Set "+command+" = "+value)
            __builtins__["environment"](command, value.strip())
        elif len(params) == 2:
            command = params[1]
            __builtins__["environment"].delete(command)
        else:
            print_error("SyntaxError")
            print_help(">set VARNAME VALUES")

    if params[0] == "load":
        if len(params) != 2:
            print_error("SyntaxError")
            print_help(">env load <url>")
            return
        f = urllib.request.urlopen(params[1])
        data = f.read().decode(encoding='UTF-8')
        for i in data.split("\n"):
            item = i.strip()
            if len(item.strip()) < 3:
                continue
            if item.startswith("#"):
                continue
            if "=" not in item:
                print_error("Error in: %s"%item)
                continue
            tab = item.split("=")
            __builtins__["environment"](tab[0].strip(), tab[1].strip())
