import os
import imp
from . import O, E


class DynamicModule(object):
    LoadedModule = {}

    def __init__(self, name):
        self.LoadedModule[name] = self
        self.__name = name
        self.__module = __import__(self.__name,
                                   fromlist=self.__name.split(".")[-1])
        self.__mtime = os.path.getmtime(self.__module.__file__)
        if('initialize' in self.__module.__dict__):
            self.__module.__dict__['initialize'](E())

    def function(self, funcname):
        return self.__module.__dict__[funcname]

    def reload(self):
        if self.__mtime != os.path.getmtime(self.__module.__file__):
            try:
                imp.reload(self.__module)
            except:
                O().print_error("##!!! Error in "+self.__name)
            self.__mtime = os.path.getmtime(self.__module.__file__)
            O().print_ok("## Reload("+self.__name+")")


def get_dynamic_module(name):
    if name in DynamicModule.LoadedModule:
        return DynamicModule.LoadedModule[name]
    else:
        return DynamicModule(name)
