#!/bin/sh

STATUS=0

Input_File="$1"
Temp_Dir="/otu/release/tmp"
File_To_Check="release.xml"
File_Count=0

rm -Rf "$Temp_Dir"/*
tar xf "$Input_File" -C "$Temp_Dir"
STATUS=`echo $?`

if [[ $STATUS -eq 0 ]]; then
    cd "$Temp_Dir"
    /usr/bin/gpg --import "/usr/share/secrelease/viavi.gpg"
    /usr/bin/gpg --verify "$File_To_Check.sig" "$File_To_Check"
    STATUS=`echo $?`
fi

if [[ $STATUS -eq 0 ]]; then
    File_To_Check=""
    for File in * 
    do
    echo $File
    echo "${File#*.}"
    if [[ -f "$File" ]]; then
        ((File_Count++))        
        [[ "${File#*.}" == "tar.gz" ]] && { File_To_Check="$File"; }
    fi
    done
fi

[[ $File_Count -gt 5 ]] && { STATUS=1; }

if [[ $STATUS -eq 0 ]]; then
    /usr/bin/gpg --import "/usr/share/secrelease/viavi.gpg"
    /usr/bin/gpg --verify "$File_To_Check.sig" "$File_To_Check"
    STATUS=`echo $?`
fi

rm -Rf "$Temp_Dir"/*

exit $STATUS
