#!/usr/bin/env python3
# -*- coding:utf-8 -*-

from socketserver import UDPServer, BaseRequestHandler
from threading import Thread
import logging
import syslog
from time import sleep
import socket
from jdsu.mts import ScpiAccess


class MyUDPHandler(BaseRequestHandler):
    def __init__(self, request, client_address, server):
        BaseRequestHandler.__init__(self, request, client_address, server)
        return

    def handle(self):
        data = self.request[0].strip()
        datas = data.decode('utf8').split(' ', 1)
        if len(datas) != 2:
            return
        hostname, cmd = tuple(datas)
        if hostname == "all" or hostname == socket.gethostname():
            if cmd == 'cfg1':
                u = ScpiAccess.ScpiAccess("127.0.0.1", "8000")
                u.connect()
                u.SendCommand('ISU:DFT "ETH_IP0,ETH_SUBNET0,ETH_GATEWAY0,ETH_DNS0,ETH_EXT_DNS_B0,ETH_EXT_DNS_C0,ETH_DOMAIN0,ETH_SITE0,ETH_MODE"')
                u.SendCommand("SYSTEM:ETHERNET:RESTART")
                sleep(0.1)
                u.disconnect()
                syslog.syslog("Config is now cfg1")
            elif cmd == 'dhcp':
                u = ScpiAccess.ScpiAccess("127.0.0.1", "8000")
                u.connect()
                u.SendCommand("SYSTEM:ETHERNET:MODE DHCP")
                u.SendCommand("SYSTEM:ETHERNET:RESTART")
                sleep(0.1)
                u.disconnect()
                syslog.syslog("Config is now dhcp")
            elif cmd == 'jdsu':
                u = ScpiAccess.ScpiAccess("127.0.0.1", "8000")
                u.connect()
                u.SendCommand("SYSTEM:ETHERNET:IPADDRESS CFG2,192,168,0,200")
                u.SendCommand("SYSTEM:ETHERNET:IPGATEWAY CFG2,192,168,0,253")
                u.SendCommand("SYSTEM:ETHERNET:IPMASK CFG2,255,255,255,0")
                u.SendCommand("SYSTEM:ETHERNET:DNS CFG2,1,127,0,0,1")
                u.SendCommand("SYSTEM: ETHERNET:DOMAINNAME CFG2, '"'ds.jdsu.net'"'")
                u.SendCommand("SYSTEM:ETHERNET:MODE CFG2")
                sleep(0.1)
                u.disconnect()
                syslog.syslog("Config is now jdsu")
            else:
                syslog.syslog(syslog.LOG_WARNING, "Unknown command received {}".format(cmd))


class LocaliserServer(UDPServer):
    def __init__(self, params):
        UDPServer.__init__(self, params, MyUDPHandler)
        self.allow_reuse_address = True
        self.daemon_threads = True
        logging.info("Listening to {}:{}".format(params[0], params[1]))

if __name__ == '__main__':
    ip_address = ''
    port = 8127
    server_add = (ip_address, port)

    syslog.syslog("Server is going to start")
    server = UDPServer(server_add, MyUDPHandler)
    server_thread = Thread(target=server.serve_forever)
    server_thread.start()

    syslog.syslog("Server is running")

    # Wait 5 minutes
    try:
        sleep(5*60)
    except KeyboardInterrupt:
        print("Stopped by user")

    # stop server
    server.shutdown()
    syslog.syslog("Server is now stopped")

    server_thread.join()

    exit(0)
