#!/usr/bin/env python3

import socket
from netifaces import interfaces, ifaddresses, AF_INET
from json import dumps as json_dump
from time import sleep


while True:
    ip_address = ''
    broadcast_address = ''
    # find out the broadcast address for usb3g or bnep
    for itf in interfaces():
        if (itf.startswith('bnep') or itf.startswith('usb3g')) and AF_INET in ifaddresses(itf):
            ip_address = ifaddresses(itf)[AF_INET][0]['addr']
            broadcast_address = ifaddresses(itf)[AF_INET][0]['broadcast']

    # If an address is found send the udp broadcast
    if ip_address != '' and broadcast_address != '':
        sock = socket.socket(socket.AF_INET, socket.SOCK_DGRAM)
        sock.setsockopt(socket.SOL_SOCKET, socket.SO_BROADCAST, 1)
        data = {"version": 1,
                "hostname": socket.gethostname(),
                "address": ip_address
                }

        print("Sending broadcast udp msg", bytes(json_dump(data), 'utf-8'), broadcast_address)
        sock.sendto(bytes(json_dump(data), 'utf-8'), (broadcast_address, 8042))

    sleep(5)
