#!/bin/sh
### BEGIN INIT INFO
# Provides:          hostname
# Required-Start:
# Required-Stop:
# Default-Start:     S
# Default-Stop:
# Short-Description: Set hostname based on /etc/hostname
### END INIT INFO


IS_OTU_MODE="NO"
# serial-number is filled by u-boot
DTB_SN=$(cat /proc/device-tree/board/serial-number)

if [ -f /etc/init.d/otu_functions ] ; then
	source /etc/init.d/otu_functions
	is_cotu_hw
	if [ $? -eq 1 ] ; then
		IS_OTU_MODE="YES"
	fi
fi

# If we have no OTU HW do not use the /etc/hostname file because it's eotdrv2 product
if [[ "$IS_OTU_MODE" == "NO" && -f /etc/hostname ]] ; then
	rm -rf /etc/hostname
fi

# if /etc/hostname exist use this file to force the hostname
if test -s /etc/hostname
then
	hostname $(cat /etc/hostname)
else
	if [ "$IS_OTU_MODE" == "NO" ] ; then
		hostname base-$(cat /proc/device-tree/model | sed "s/mts//g")-$DTB_SN
	else
		hostname otu-5000-$DTB_SN
	fi
fi

# if there is no /etc/hosts file, create a default file (usually it is done by Isu... but for otu it is not!!!)
 if ! [ -f /etc/hosts ]
 then
    echo "# Loopback address" > /etc/hosts
    echo "127.0.0.1       localhost.localdomain localhost" >> /etc/hosts
    echo "::1     localhost6.localdomain6 localhost6" >> /etc/hosts
    echo "127.0.0.1     $(hostname)" >> /etc/hosts
 fi

if [ -d /etc/NetworkManager ]
then
	CONF_FILE="/etc/NetworkManager/NetworkManager.conf"
	echo "[main]" > $CONF_FILE
	echo "plugins=keyfile" >> $CONF_FILE
	echo "" >> $CONF_FILE
	echo "[keyfile]" >> $CONF_FILE
	echo "hostname="$(hostname) >> $CONF_FILE
	echo "unmanaged-devices=interface-name:eth1;interface-name:eth2;interface-name:eth3;interface-name:usb0" >> $CONF_FILE
fi
