import QtQuick 1.1

Item {
    id: classicQwertyKeyboard

    property bool upperKey: false;

    property int columnSpacing: 5
    property int lineSpacing: 14
    property int buttonHeight: 56

    property string shiftText: "\u21E7"
    property string capslockText: "\u21EA"
    property string entertext:"\u2BA0"
    property string clrText: "\u2421"
    property string spaceText: "Space"
    property string bspText: "\u2B05"
    property string cancelText: "\u00D7"
    property string changeText: "\u21C4"
    property string rightArrow: "\u2192"
    property string leftArrow: "\u2190"
// For Start & End of string buttons need
//    property string rightArrow: "\u2B72" // Move to end
//    property string leftArrow: "\u2B70" // Move to start

    Column {
        anchors.fill: parent
        spacing: lineSpacing
        Row {
            spacing: columnSpacing
            VirtualKeyboardButton { textDisplay: upperKey ? "!" : "1";  }
            VirtualKeyboardButton { textDisplay: upperKey ? "@" : "2";  }
            VirtualKeyboardButton { textDisplay: upperKey ? "#" : "3";  }
            VirtualKeyboardButton { textDisplay: upperKey ? "$" : "4";  }
            VirtualKeyboardButton { textDisplay: upperKey ? "%" : "5";  }
            VirtualKeyboardButton { textDisplay: upperKey ? "^" : "6";  }
            VirtualKeyboardButton { textDisplay: upperKey ? "&" : "7";  }
            VirtualKeyboardButton { textDisplay: upperKey ? "*" : "8";  }
            VirtualKeyboardButton { textDisplay: upperKey ? "(" : "9";  } 
            VirtualKeyboardButton { textDisplay: upperKey ? ")" : "0";  }
            VirtualKeyboardButton { textDisplay: upperKey ? "_" : "-";  }
            
        }
        Row {
            spacing: columnSpacing
            VirtualKeyboardButton { textDisplay: upperKey ? "Q" : "q";  }
            VirtualKeyboardButton { textDisplay: upperKey ? "W" : "w";  }
            VirtualKeyboardButton { textDisplay: upperKey ? "E" : "e";  }
            VirtualKeyboardButton { textDisplay: upperKey ? "R" : "r";  }
            VirtualKeyboardButton { textDisplay: upperKey ? "T" : "t";  }
            VirtualKeyboardButton { textDisplay: upperKey ? "Y" : "y";  }
            VirtualKeyboardButton { textDisplay: upperKey ? "U" : "u";  }
            VirtualKeyboardButton { textDisplay: upperKey ? "I" : "i";  }
            VirtualKeyboardButton { textDisplay: upperKey ? "O" : "o";  }
            VirtualKeyboardButton { textDisplay: upperKey ? "P" : "p";  }
            VirtualKeyboardButton { textDisplay: upperKey ? "?" : "/";  }
            
        }
        Row {
            spacing: columnSpacing
            Item { width: 30; height: parent.height; }
            VirtualKeyboardButton { textDisplay: upperKey ? "A" : "a";  }
            VirtualKeyboardButton { textDisplay: upperKey ? "S" : "s";  }
            VirtualKeyboardButton { textDisplay: upperKey ? "D" : "d";  }
            VirtualKeyboardButton { textDisplay: upperKey ? "F" : "f";  }
            VirtualKeyboardButton { textDisplay: upperKey ? "G" : "g";  }
            VirtualKeyboardButton { textDisplay: upperKey ? "H" : "h";  }
            VirtualKeyboardButton { textDisplay: upperKey ? "J" : "j";  }
            VirtualKeyboardButton { textDisplay: upperKey ? "K" : "k";  }
            VirtualKeyboardButton { textDisplay: upperKey ? "L" : "l";  }
            VirtualKeyboardButton { textDisplay: upperKey ? ":" : ";";  }
        }
        Row {
            spacing: columnSpacing
            // VirtualKeyboardButton { textDisplay: upperKey ? capslockText : shiftText; }
            Item { width: 60; height: parent.height; }
            VirtualKeyboardButton { textDisplay: upperKey ? "Z" : "z";  }
            VirtualKeyboardButton { textDisplay: upperKey ? "X" : "x";  }
            VirtualKeyboardButton { textDisplay: upperKey ? "C" : "c";  }
            VirtualKeyboardButton { textDisplay: upperKey ? "V" : "v";  }
            VirtualKeyboardButton { textDisplay: upperKey ? "B" : "b";  }
            VirtualKeyboardButton { textDisplay: upperKey ? "N" : "n";  }
            VirtualKeyboardButton { textDisplay: upperKey ? "M" : "m";  }
            VirtualKeyboardButton { textDisplay: upperKey ? "," : ".";  }
        }
        Row {
            spacing: columnSpacing
            VirtualKeyboardButton { textDisplay: upperKey ? capslockText : shiftText; }
            Item { width: 20; height: parent.height; }
            //Item { width: 80; height: parent.height; }
            VirtualKeyboardButton { textDisplay: leftArrow;  }
            VirtualKeyboardButton { textDisplay:""; textSend: spaceText; width: 400; height: buttonHeight }    // SpaceBar
            VirtualKeyboardButton { textDisplay: rightArrow;  }
            Item { width: lineSpacing; height: parent.height; }
        }
    }
}
