import QtQuick 1.1
import "Viavi_Colors.js" as VColor

Rectangle {
    id: container
    color: VColor.cViaviColorLightGray2

    width: 320
    height: 410
    
    radius: 5
    
    border.width: 3
    border.color: "darkgrey"

    // 'Public' properties
    property int maxChars: 10
    property int minChars: 1
    property string titleText: ""
    property string initialText: ""

    property string minValue: "0.000"
    property string maxValue: "50000.000"
    
    property string mintext:"Min"
    property string maxtext:"Max"
    property string meastext:windows_manager.txtMeasure

    property string entertext:"\u23CE"
    property string clrText: "\u2421"
    property string bspText: "\u2B05"
    property string cancelText: "\u1F5D9"

    property int labelHeight: 30
    property int txtSize: 18
    property int columnSpacing: 5
    property int lineSpacing: 8
    property int buttonHeight: 56
    property int buttonWidth: 58 
    
    property bool dotIsAllowed: true
    property bool measIsVisible: false
    property bool measIsAllowed: false

    property alias input: textInput
    
    property bool validationAllowed: false
    
    property string pathClearIcon: "/acterna/storage/look-and-feel/generic/Wizard_Icon_Clear.png"
    property string pathCancelIcon: "/acterna/storage/look-and-feel/generic/Wizard_Icon_Cancel.png"
    property string pathOkIcon: "/acterna/storage/look-and-feel/generic/Wizard_Icon_Enter.png"
    
    // Signals
    signal editText(string txtOutput, bool validation);
    
    signal btnOkClicked();
    signal btnCancelClicked();
    signal btnMeasClicked();
    
    onBtnOkClicked: {
        var len = input.text.length
        validationAllowed = false;
        if (len < maxChars && len >= minChars ) {
            if (parseFloat(initialText) > parseFloat(maxValue))
            {
                validationAllowed = false;
            }
            else if(parseFloat(initialText) < parseFloat(minValue))
            {
                validationAllowed = false;
            }
            else
            {
                validationAllowed = true;
            }
        }
        else
        {
            validationAllowed = false;
        }
        editText(textInput.text, validationAllowed);  	
        close()
    }

    onBtnCancelClicked: {
      	validationAllowed = false;
    	editText(textInput.text, validationAllowed);   
        close()
    }
    
    onBtnMeasClicked: {
    	setup_data.launchCableSelection.Wizard_Meas_Launch_Cable_Info();
    	close();
    }

    function close() {
        container.visible = false
    }

    // Callbacks
    function addText(text) {

        if (text == entertext) {
            return  // Do Nothing
        }
        else if (text == cancelText) {
            return  // Do Nothing
        }
        else if (text == meastext) {
            return  // Do Nothing        	
        }

        var pos = input.cursorPosition
        var len = input.text.length

        switch (text) {
	case mintext:
	    initialText = minValue
	    break;
	case maxtext:
	    initialText = maxValue
	    break;
   case clrText:
       initialText = ""
       break;
   case bspText:
       if (len > 0 && pos > 0) {
          initialText = initialText.slice(0, pos - 1) + initialText.slice(pos, len)
          textInput.cursorPosition = pos - 1 < 0 ? 0 : pos -1
       }
      break;
	case ".":
	    if ( initialText.indexOf(".") == (-1) )
	    {
		initialText = initialText.slice(0, pos) + text + initialText.slice(pos, len)
		textInput.cursorPosition = pos + text.length
	    }
	    break;
        default:
	    initialText = initialText.slice(0, pos) + text + initialText.slice(pos, len)
	    
      if (len < maxChars && len >= minChars ) {
                if (parseFloat(initialText) > parseFloat(maxValue))
		{
		  initialText = maxValue
		}
		else if(parseFloat(initialText) < parseFloat(minValue))
		{
		  initialText = minValue
		}
            }
            
            textInput.cursorPosition = pos + text.length
        }
    }

    Rectangle  {
        id: titleKeyBoard
        width: parent.width - 40
        height: labelHeight
        anchors.rightMargin: 15
        anchors.right: parent.right
        anchors.leftMargin: 15
        anchors.left: parent.left
        anchors.top: parent.top
        anchors.topMargin: 10
//        border.color: "grey"
//        border.width: 2
		color: parent.color

        Text {
            id: txtTitleKeyboard
            text: titleText
            anchors.topMargin: 4
            anchors.fill: parent
            font.pixelSize: txtSize
            horizontalAlignment: Text.AlignHCenter
            clip: true
        }
    }

    Rectangle  {
        id: labelText
        width: parent.width - 40
        height: labelHeight
        anchors.rightMargin: 15
        anchors.right: parent.right
        anchors.leftMargin: 15
        anchors.left: parent.left
        anchors.top: titleKeyBoard.bottom
//        anchors.topMargin: 10
        border.color: "red"
        border.width: 2
        radius: 3

        TextInput {
            id: textInput
            text: container.initialText
            anchors.fill: parent
            anchors.topMargin: 4
            anchors.leftMargin: 8
            font.pixelSize: txtSize
            horizontalAlignment: Text.AlignLeft
            cursorVisible: true
            focus: true
            clip: true
        }
    }

    Column {
        id: colAlpha
        y: 87
        anchors.left: labelText.left
        anchors.top: labelText.bottom
        anchors.topMargin: 7
        spacing: lineSpacing
        Row {
            spacing: columnSpacing
            VirtualKeyboardButton { textDisplay: mintext; width: buttonWidth }
            VirtualKeyboardButton { textDisplay: "."; width: buttonWidth; isEnabled: dotIsAllowed }
            VirtualKeyboardButton { textDisplay: maxtext; width: buttonWidth }
        }
        Row {
            spacing: columnSpacing
            VirtualKeyboardButton { textDisplay: "7"; width: buttonWidth }
            VirtualKeyboardButton { textDisplay: "8"; width: buttonWidth }
            VirtualKeyboardButton { textDisplay: "9"; width: buttonWidth }
        }
        Row {
            spacing: columnSpacing
            VirtualKeyboardButton { textDisplay: "4"; width: buttonWidth }
            VirtualKeyboardButton { textDisplay: "5"; width: buttonWidth }
            VirtualKeyboardButton { textDisplay: "6"; width: buttonWidth }
        }
        Row {
            spacing: columnSpacing
            VirtualKeyboardButton { textDisplay: "1"; width: buttonWidth }
            VirtualKeyboardButton { textDisplay: "2"; width: buttonWidth }
            VirtualKeyboardButton { textDisplay: "3"; width: buttonWidth }
        }
        Row {
            spacing: columnSpacing
            Item { width: buttonWidth; height: parent.height; visible: !measIsVisible}
            VirtualKeyboardButton { textDisplay: "0"; width: buttonWidth }
            VirtualKeyboardButton { textDisplay:meastext; actionClick.onClicked: btnMeasClicked(); 
            			width: 2*buttonWidth + columnSpacing; height: buttonWidth; visible: measIsVisible; isEnabled: measIsAllowed}
        }
    }

    Column {
        id: colBeta
        y: 87
        anchors.right: titleKeyBoard.right
        anchors.top: labelText.bottom
        anchors.topMargin: 7
        spacing: lineSpacing

        VirtualKeyboardButton { textDisplay:bspText; buttonReleaseColor: VColor.cViaviColorMediumGray; txtSize: 35; width: buttonWidth }
        VirtualKeyboardButton { textDisplay:clrText; pathIcon:pathClearIcon ; buttonReleaseColor: VColor.cViaviColorMediumGray; width: buttonWidth }
        Item { width: buttonWidth; height: buttonHeight }
        VirtualKeyboardButton { pathIcon:pathCancelIcon; buttonReleaseColor: VColor.cViaviColorMediumGray; actionClick.onClicked: btnCancelClicked(); width: buttonWidth }
        VirtualKeyboardButton { pathIcon:pathOkIcon; buttonReleaseColor: VColor.cViaviColorMediumGray; actionClick.onClicked: btnOkClicked(); width: buttonWidth  }
    }
}

