import QtQuick 1.1
import "Viavi_Colors.js" as VColor
import libjobmgr 1.0

Rectangle {
    id: testPlanPanel
    width: jobInfoPanel.width
    color: VColor.cViaviColorDarkGray
    anchors.horizontalCenter: parent.horizontalCenter
    anchors.top: testPlanHeader.bottom
    anchors.topMargin: 3
    visible: isJobTestPlanPanelOn
    height: isJobTestPlanPanelOn ? testPlanList.height : 0
    
    property bool isEditable: true // TBD Probably don't want to condition Launch & Skip buttons to whether or not the Job is active (same as 5800v2)
    
    clip: true
    
    Column {
        id: testPlanList
    	width: testPlanPanel.width
    	
    	Repeater {
        	model: Job_Mgr.testPlanModel
        
	        Component {
	            id: testPlanLine
	            
	            Row {
	                id: testPlanRow
	                spacing: lineSpacing // actualy both horizontal and vertical spacing .... ? (perhaps more horizontal spacing along the Row)
	                height: lineHeight * 1.5
	
	                Rectangle {
	                    id: testPlanName
	                    color: VColor.cViaviColorLightGray2
	                    width: 180
	                    height: parent.height
	                    
	                    Image { // The icon metaphor
	                        id: functionMetaphor
	                        height: 32
	                        width: 32
	                        smooth: true;
	                        fillMode: Image.PreserveAspectFit
	                        anchors.verticalCenter: parent.verticalCenter
	                        anchors.left: parent.left
	                        anchors.leftMargin: 3
	                        source: testPlanIcon
	                        }
	                    Text {
	                        id: testPlanText
	                        anchors.verticalCenter: parent.verticalCenter
	                        anchors.fill: parent
	                        color: VColor.cViaviRealBlack
	                        text: testPlanFnName
	                        font.bold: true
	                        font.pointSize: 12
	                        horizontalAlignment: Text.AlignHCenter
	                        verticalAlignment: Text.AlignVCenter
	                        font.family: "DejaVu LGC SansCondensed"
	                        }
	                    }
	
	                Rectangle {
	                    id: testPlanContent
	                    color: VColor.cViaviColorWhite
	                    width: testPlanPanel.width - testPlanName.width
	                    height: parent.height
	
	                    Rectangle {
	                        id: launchButton
	                        radius:3
	                        anchors.left: testPlanContent.left
	                        anchors.leftMargin: 10
	                        anchors.verticalCenter: parent.verticalCenter
	                        width: 80
	                        height: parent.height - 12
	                        color: ( mouse_Area_Launch.containsMouse ) ? VColor.cViaviColorLightBlue : VColor.cViaviColorLogoPurple
	
	                        Text {
	                            id: textLaunch
	                            text: jobManagerTranslation.txtJobLaunch
	                            color: VColor.cViaviColorWhite
	                            font.bold: true
	                            font.pointSize: 12
	                            horizontalAlignment: Text.AlignHCenter
	                            verticalAlignment: Text.AlignVCenter
	                            anchors.fill: parent
	                            }
	
	                        MouseArea {
	                            id: mouse_Area_Launch
	                            anchors.fill: parent
	                            enabled: testPlanPanel.isEditable
	
	                            onClicked: {
	                                console.log("[Qml] Launch the Planned Test for index:", index );
	                                saveContentPos();
	                                
	                                if( backgroundJobMgr.jobState == 0 )
		                                {
		                                popUpWarningActivation.currentIndex = index;
		                                popUpWarningActivation.visible = true;
		                                }
	                                else
		                                {
		                                Job_Mgr.testPlanModel.launch_Test( index );
		                                }
	                                }
	                            }
	                        }
	                        
		                    Rectangle {
		                        id: testPlanRefInfo
		                        anchors.left: launchButton.right
		                        anchors.leftMargin: 10
		                        anchors.verticalCenter: parent.verticalCenter
		                        height: parent.height
		                        width: (skipButton.x - testPlanRefInfo.anchors.leftMargin - testPlanRefInfo.x)
		                        color: "transparent"
		                        clip: true
		                        
		                        Column {
		                            id: refInfoList 
		                        	anchors.left: parent.left
		                        	anchors.right: parent.right
		                        	anchors.verticalCenter: parent.verticalCenter
		                        	
	                    			Repeater {
	                        			model: testRefInfo
		                        
		                        		Rectangle {
		                        			width: testPlanRefInfo.width
					                        height: lineHeight * 0.75
					                        color: "transparent"
					                        
					                        Text {
					                            text: modelData
					                            color: VColor.cViaviRealBlack
					                            font.pointSize: 10
					                            width: parent.width
					                            elide: Text.ElideMiddle
					                            verticalAlignment: Text.AlignVCenter
					                            anchors.verticalCenter: parent.verticalCenter
					                            }
				                            }
		                        		}
	                        		}
	                    		}
	
	                    Rectangle {
	                        id: skipButton
	                        
	                        opacity: (testHasSkipButton) ? 1 : 0
	                        radius:3
	                        anchors.right: parent.right
	                        anchors.rightMargin: 110
	                        anchors.verticalCenter: parent.verticalCenter
	                        width: 80
	                        height: parent.height - 12
	                        color: ( mouse_Area_Skip.containsMouse ) ? VColor.cViaviColorLightBlue : VColor.cViaviColorLogoPurple
	
	                        Text {
	                            id: textSkip
	                            text: jobManagerTranslation.txtJobSkip
	                            color: VColor.cViaviColorWhite
	                            font.bold: true
	                            font.pointSize: 12
	                            horizontalAlignment: Text.AlignHCenter
	                            verticalAlignment: Text.AlignVCenter
	                            anchors.fill: parent
	                            }
	                        
	                        MouseArea {
	                            id: mouse_Area_Skip
	                            anchors.fill: parent
	                            enabled: testPlanPanel.isEditable
	                            
	                            onClicked: {
	                                console.log("[Qml] Skipping the Planned Test", testPlanFnName, "- index:", index );
	                                saveContentPos();
	                                openSkipWindow( index );
	                                }
	                            }
	                        }
	
	                    Rectangle {
	                        id: testPlanState
	                        anchors.left: skipButton.right
	                        anchors.leftMargin: 10
	                        height: parent.height
	                        width: 100
	                        color: "transparent"
	                        
	                        // display testPlanStatus from Test Plan Model
	                        Text {
	                            id: textStatus
	                            text: testPlanStatus
	                            color: VColor.cViaviRealBlack
	                            font.pointSize: 12
	                            height: parent.height
	                            verticalAlignment: Text.AlignVCenter
	                            anchors.left: parent.left
	                            }
	                            
	                        Image {
		                        source: testPlanIconStatus
		                        anchors.verticalCenter: parent.verticalCenter
		                        anchors.right: parent.right
		                        anchors.rightMargin: 5
		                        }
	                        }
	                    }
	                }
	            } // end Component
	        } // end Repeater
		} // end Column
    }
