import QtQuick 1.1
import "Viavi_Colors.js" as VColor
import libfixsynoptique 1.0

Rectangle {
   id: container
   
   anchors.fill: parent
   
   color: VColor.cViaviColorWhite
   
   Text {
      id: txtLocal
      
      anchors.top: container.top
      anchors.topMargin: 20
      
      anchors.horizontalCenter: mtsLocal.left
      
      font.bold: true
      
      text: fix_synoptique_manager.idLocal
   }
   
   Text {
      id: txtDistant
      
      anchors.top: container.top
      anchors.topMargin: 20
      
      anchors.horizontalCenter: mtsDistant.right
      
      font.bold: true
      
      text: fix_synoptique_manager.idDistant
   }
   
   Image {
      id: mtsLocal
      
      x: 50
      y: 50
      
      fillMode: Image.PreserveAspectFit
      smooth: true
      
      source: "image://pixmaps/" + fix_synoptique_manager.xpmMtsLocal
   }
   
   Rectangle {
      id: containerMtsLocalState
      anchors.bottom: mtsLocal.bottom
      anchors.right: mtsLocal.right
      
      visible: fix_synoptique_manager.xpmMtsLocalState !== "0"
   
      color: VColor.cViaviColorYellow
      
      width: 50
      height: 50
      
      radius: 5
      
      clip: true
   
      Image {
         id: mtsLocalState
         
         anchors.centerIn: parent
         
         fillMode: Image.PreserveAspectFit
         smooth: true
         
         source: "image://pixmaps/" + fix_synoptique_manager.xpmMtsLocalState
      }
   }
   
   Image {
      id: localLaser
      
      x: 15
      y: 83
      
      fillMode: Image.PreserveAspectFit
      smooth: true
      
      source: "image://pixmaps/" + fix_synoptique_manager.xpmLocalLaser
   }
   
   Text {
      id: localLaserMessage
      
      anchors.top: localLaser.bottom
      anchors.topMargin: 10
      
      anchors.horizontalCenter: localLaser.horizontalCenter
      
      font.bold: true
      
      text: fix_synoptique_manager.txtLocalLaser
   }
   
   Image {
      id: mtsDistant
      
      x: 450
      y: 60
      
      fillMode: Image.PreserveAspectFit
      smooth: true
      
      source: "image://pixmaps/" + fix_synoptique_manager.xpmMtsDistant
   }
   
   Image {
      id: mtsDistantStatus
      
      anchors.top: mtsDistant.top
      anchors.left: mtsDistant.left
      
      fillMode: Image.PreserveAspectFit
      smooth: true
      
      source: "image://pixmaps/" + fix_synoptique_manager.xpmMtsDistantStatus
   }
   
   Rectangle {
      anchors.bottom: mtsDistant.bottom
      anchors.right: mtsDistant.right
      
      visible: fix_synoptique_manager.xpmMtsDistantState !== "0"
      
      width: 50
      height: 50
      
      radius: 5
      
      clip: true
      
      color: VColor.cViaviColorYellow
         
      Image {
         id: mtsDistantState
         
         anchors.centerIn: parent
         
         fillMode: Image.PreserveAspectFit
         smooth: true
         
         source: "image://pixmaps/" + fix_synoptique_manager.xpmMtsDistantState
      }
   }
   
   Image {
      id: fiberLink
      
      x: 118
      y: 23
      
      fillMode: Image.PreserveAspectFit
      smooth: true
      
      source: "image://pixmaps/" + fix_synoptique_manager.xpmFiberLink
   }
   
   Image {
      id: testingArrow
      
      anchors.horizontalCenter: container.horizontalCenter
      y: 83
      
      fillMode: Image.PreserveAspectFit
      smooth: true
      
      source: "image://pixmaps/" + fix_synoptique_manager.xpmTestingArrow
   }
   
   Text {
      id: testingMessage
      
      anchors.top: testingArrow.bottom
      anchors.topMargin: 10
      
      anchors.horizontalCenter: testingArrow.horizontalCenter
      
      font.bold: true
      
      text: fix_synoptique_manager.txtTestingMessage
   }
   
   Image {
      id: refFirstConnector
      
      x: 128
      y: 2
      
      fillMode: Image.PreserveAspectFit
      smooth: true
      
      source: "image://pixmaps/" + fix_synoptique_manager.xpmRefFirstConnector
   }
   
   Image {
      id: refMiddleConnector
      
      x: 308
      y: 2
      
      fillMode: Image.PreserveAspectFit
      smooth: true
      
      source: "image://pixmaps/" + fix_synoptique_manager.xpmRefMiddleConnector
   }
   
   Image {
      id: xchangeSetup
      
      x: 330
      anchors.top: containerMtsLocalState.top
      
      fillMode: Image.PreserveAspectFit
      smooth: true
      
      source: "image://pixmaps/" + fix_synoptique_manager.xpmXChangeSetup
      visible: false
      
      MouseArea {
         anchors.fill: parent
         
         onClicked: {
            console.log("!!! TEST XCHANGE SETUP");
         }
      }
   }
}