import QtQuick 1.1
import "Viavi_Colors.js" as VColor
import libfo 1.0

Item {
    id: slm_corp

    Rectangle {
    	id: screen
        width: parent.width
        height: parent.height
        color: "black"
        
        focus: true

        Rectangle {
            id: head
            color: VColor.cViaviColorGray
            height: 40
            width: parent.width
			
      		Rectangle {
      			id: recAllFiber
                   width: parent.width / 2
                   height: head.height - 4
      			color: VColor.cViaviColorLightGray2
                   anchors.right: head.right
                   anchors.verticalCenter: parent.verticalCenter
      			
      			Rectangle {
      				id: recPassFiber
      				color: VColor.cViaviColorGreen
      				height:parent.height
      				width: cable_co_list.Nb_Label_To_Test > 0 ? recAllFiber.width * cable_co_list.Nb_Label_Pass / cable_co_list.Nb_Label_To_Test : 0
      				anchors.left: parent.left
      			}
				
   				Rectangle {
   					id: recFailFiber
   					color: VColor.cViaviColorRed
   					height:parent.height
   					width: cable_co_list.Nb_Label_To_Test > 0 ? recAllFiber.width * cable_co_list.Nb_Label_Fail / cable_co_list.Nb_Label_To_Test : 0
   					anchors.left: recPassFiber.right
   				}
				
   				Text {
   					id: textNumberFiberTested
   	                anchors.horizontalCenter: parent.horizontalCenter
   	                anchors.verticalCenter: parent.verticalCenter
   	                horizontalAlignment: Text.AlignHCenter
   	                verticalAlignment: Text.AlignVCenter
   					text: cable_co_list.Txt_Tested + " " + (cable_co_list.Nb_Label_Pass+cable_co_list.Nb_Label_Fail) + "/" + cable_co_list.Nb_Label_To_Test 
   					color: "white"
   	                font.pixelSize: 24
   	                font.family: "DejaVu LGC SansCondensed"
   				}
			   }

            Image { // The icon metaphor
                id: passedMetaphor
                anchors.left: parent.left
                anchors.leftMargin: 10
                anchors.verticalCenter: parent.verticalCenter
                height: 32
                fillMode: Image.PreserveAspectFit
                source:"/acterna/storage/look-and-feel/generic/Check_32_Enterprise.png"
            }

			Text {
				id: textPassFiber
                anchors.left: passedMetaphor.right
				anchors.leftMargin: 10 //40
                anchors.verticalCenter: parent.verticalCenter
                horizontalAlignment: Text.AlignHCenter
                verticalAlignment: Text.AlignVCenter
                // Dont use italics
                text: cable_co_list.Nb_Label_Pass + " " + cable_co_list.Txt_Pass
				color: "white"
                font.pixelSize: 24
                font.family: "DejaVu LGC SansCondensed"
			}

            Image { // The icon metaphor
                id: failedMetaphor
                anchors.left: textPassFiber.right
                anchors.leftMargin: 20
                anchors.verticalCenter: parent.verticalCenter
                height: 32
                fillMode: Image.PreserveAspectFit
                source:"/acterna/storage/look-and-feel/generic/Cross_32_Enterprise.png"
            }
			
			Text {
				id: textFailFiber
				anchors.left: failedMetaphor.right
                anchors.leftMargin: 10
                anchors.verticalCenter: parent.verticalCenter
                horizontalAlignment: Text.AlignHCenter
                verticalAlignment: Text.AlignVCenter
                text: cable_co_list.Nb_Label_Fail + " " + cable_co_list.Txt_Fail
				color: "white"
                font.pixelSize: 24
                font.family: "DejaVu LGC SansCondensed"
			}
        }

        Item {
        	id: body
            anchors.fill: parent
            anchors.topMargin: head.height
            anchors.bottomMargin: cable_result_information.visible ? cable_result_information.height : 0
            clip: true

            ListView {
                id: label_list

                anchors.fill: parent
                boundsBehavior: Flickable.StopAtBounds
                currentIndex: cable_co_list.Label_Index
                
                highlightMoveSpeed: -1
                highlightMoveDuration: -1
                
                model: cable_co_list.Cable_Label_List
                delegate: Cable_Co_Enterprise_Slm_Line {} 
            }
            
            Cable_Co_Enterprise_MPO {
                visible: (cable_co_list.Label_Index_Open != -1)
                
                parent: label_list.currentItem
                
                anchors.top: parent != undefined ? parent.top : undefined
                anchors.topMargin: 50
                anchors.horizontalCenter: parent != undefined ? parent.horizontalCenter : undefined
                
                groupe_size: cable_co_list.MPO_Size
                fiber_start_index: cable_co_list.Cable_Co_Get_First_Index_Of_Label(label_list.currentIndex)
            }
        }
        
        Cable_Co_Result_Informations {
            id: cable_result_information
   
            height: 3*48
            width: parent.width
            visible: cable_co_list.Result_Window_Displayed
            
            anchors.bottom: parent.bottom
         }
        
        Keys.onPressed: {
			if (event.key == Qt.Key_Left) {
				if ( cable_co_list.MPO_Size > 1 )
				{
					if ( (cable_co_list.Index % cable_co_list.MPO_Size) > 0) {
						cable_co_list.Index = cable_co_list.Index - 1;
						cable_co_list.Label_Selection_Mode = false;
					}
				}
			} else if (event.key == Qt.Key_Right) {
				if ( cable_co_list.MPO_Size > 1 )
				{
					if ( cable_co_list.Label_Selection_Mode )
						{
						cable_co_list.Label_Selection_Mode = false;
						cable_co_list.Index = cable_co_list.Cable_Co_Get_First_Index_Of_Label(cable_co_list.Label_Index);
						cable_co_list.Label_Index_Open = cable_co_list.Label_Index;
						}
					else if ( (cable_co_list.Index % cable_co_list.MPO_Size) < (cable_co_list.MPO_Size - 1)) 
						{
						cable_co_list.Index = cable_co_list.Index + 1;
						cable_co_list.Label_Index_Open = cable_co_list.Label_Index;
						}
					}
			} else if (event.key == Qt.Key_Up && event.isAutoRepeat == false) {
				if (cable_co_list.Label_Index > 0) {
				    cable_co_list.Label_Selection_Mode = true;
				    cable_co_list.Label_Index = cable_co_list.Label_Index - 1;
				    cable_co_list.Index = cable_co_list.Cable_Co_Get_First_Index_Of_Label(cable_co_list.Label_Index);
				}
			} else if (event.key == Qt.Key_Down && event.isAutoRepeat == false) {
				if ( (cable_co_list.Label_Index + 1) < cable_co_list.Nb_Label ) {
				    cable_co_list.Label_Selection_Mode = true;
				    cable_co_list.Label_Index = cable_co_list.Label_Index + 1;
				    cable_co_list.Index = cable_co_list.Cable_Co_Get_First_Index_Of_Label(cable_co_list.Label_Index);
				}
			} else if (event.key == Qt.Key_Up && event.isAutoRepeat != false) {
				if ( (cable_co_list.Label_Index - 10) > 0) {
				    cable_co_list.Label_Selection_Mode = true;
				    cable_co_list.Label_Index = cable_co_list.Label_Index - 10;
				    cable_co_list.Index = cable_co_list.Cable_Co_Get_First_Index_Of_Label(cable_co_list.Label_Index);
				} else {
					cable_co_list.Label_Selection_Mode = true;
					cable_co_list.Label_Index = 0;
				    cable_co_list.Index = cable_co_list.Cable_Co_Get_First_Index_Of_Label(cable_co_list.Label_Index);
				}
			} else if (event.key == Qt.Key_Down && event.isAutoRepeat != false) {
				if ( (cable_co_list.Label_Index + 10) < cable_co_list.Nb_Label ) {
				    cable_co_list.Label_Selection_Mode = true;
				    cable_co_list.Label_Index = cable_co_list.Label_Index + 10;
				    cable_co_list.Index = cable_co_list.Cable_Co_Get_First_Index_Of_Label(cable_co_list.Label_Index);
				} else {
					cable_co_list.Label_Selection_Mode = true;
					cable_co_list.Label_Index = cable_co_list.Nb_Label-1;
				    cable_co_list.Index = cable_co_list.Cable_Co_Get_First_Index_Of_Label(cable_co_list.Label_Index);
				}
			} else if (event.key == Qt.Key_Return) {
				cable_co_list.Label_Index_Open = ( cable_co_list.Label_Index != cable_co_list.Label_Index_Open ? cable_co_list.Label_Index : -1 );
				cable_co_list.Label_Selection_Mode = true;	
				cable_co_list.Index = cable_co_list.Cable_Co_Get_First_Index_Of_Label(cable_co_list.Label_Index);
			}
		}
    }
}
