﻿<?php
require_once 'app/SMTApplication.php';
require_once 'app/admin/SMTLanguage.php';
require_once 'app/admin/SMTUserUtil.php';
require_once 'app/view/SMTLoginPage.php';
require_once 'app/view/SMTAppPage.php';

ob_start();
echo('<!DOCTYPE html>');

$errorLoginMessage = '';
$user = NULL;
$app = NULL;
$gwtCodesvr = NULL;

try 
{
    //restore application context
    $app = new app\SMTApplication;
    $app->init( FALSE );
    
    //retrieve login settings if user submitted the form:
    $loginFormSubmitted = $app->getContext()->getHttpRequest()->postExists( "login" );
    $login = $app->getContext()->getHttpRequest()->postSafeData( "login" );
    $password_sha_256 = $app->getContext()->getHttpRequest()->postSafeData( "password" );
    $password_encoded = $app->getContext()->getHttpRequest()->postSafeData( "smt" );
    $gwtCodesvr = $app->getContext()->getHttpRequest()->postSafeData( "gwt.codesvr" );
    if ($gwtCodesvr == NULL)
    {
        $gwtCodesvr = $app->getContext()->getHttpRequest()->getSafeData( "gwt.codesvr" );
    }
    $target = $app->getContext()->getHttpRequest()->postSafeData('target');
    if ( $target == NULL )
    {
        $target = $app->getContext()->getHttpRequest()->getSafeData('target');
    }
    
    //$user is NULL if the form was not yet submitted
    $user = $app->getContext()->getUser();
    
    if ( $loginFormSubmitted && !isset( $user ) )
    {
		//test if user exists
		$user = app\admin\SMTUserUtil::authenticate( $app->getContext(), $login, $password_sha_256, $password_encoded);
    }        
}
catch( \Exception $e)
{
    $errorLoginMessage= $e->getMessage();
}

//If user is authentified
if ( isset( $user ) )
{    
    //we are logged in, redirect to main hostpage 
    //(Always redirect after POST to avoid warning with data that must be re-sent from browser.)
    $url = "app.php";
    if ( $gwtCodesvr !== NULL)
    {
        $url= $url."?gwt.codesvr=".$gwtCodesvr;
    }    
    
    if ( $target !== NULL)
    {
    	$url= $url."#".$target;
    }
    
    $app->getContext()->getHttpResponse()->redirect($url);
}
//form not submitted, stay on login page
else
{
    //stay on login page
	$page = new app\view\SMTLoginPage( $app->getContext(), $errorLoginMessage );
	$app->getContext()->getHttpResponse()->send( $page, FALSE );
	//reset session variables
	$app->getContext()->closeSession();
}
ob_end_flush();
?>
