<?php
namespace app\util\upload;

use app\serviceshelper\maintenance\SMTCertificate;

require_once('SMTUpload.php');

use app\util\SMTLogger;
use app\services\maintenance\SMTUploadStatusDto;
use app\util\upload\SMTUploadStatus;
use app\util\SMTUtil;


/**
 * Begining of upload script
 * 
 */
//2mn script timeout
set_time_limit(120);

$noUploadRunning = SMTUploadStatus::checkNoUploadRunning();

if ( $noUploadRunning == TRUE )
{
	$certificateType = isset($_POST["certificate_type"]) ? $_POST["certificate_type"] : null;
	
	switch ($certificateType)
	{
		case SMTCertificate::SSL_KEY:
			$checkCertificate = 'checkKeyCertificate';
			break;
		case SMTCertificate::SSL_CERT:
			$checkCertificate = 'checkCertificate';
			break;
		case SMTCertificate::SSL_CHAIN_CERT:
			$checkCertificate = 'checkChainCertificate';
			break;
		default:
			$checkCertificate = FALSE;
			break;
	}
	
	$uploadStatus = upload_file( SMTUtil::SMARTOTU_TEMP_DIR, $checkCertificate);

    
    if ( $uploadStatus->getUploadErrorStatus() == SMTUploadStatusDto::NO_ERROR )
    {
        SMTLogger::getInstance()->trace( sprintf("Upload of certificate %s complete...", $uploadStatus->getFileName()), SMTLogger::PINFO);

        
        //copy certificate to its target directory
        try 
        {
            SMTCertificate::copySslCertificate($uploadStatus->getFileName(), $certificateType);
        }
        catch ( \Exception $e )
        {
            $uploadStatus->setUploadErrorStatus( SMTUploadStatusDto::COPY_FAILED );
            $uploadStatus->setProgress( SMTUploadStatusDto::NO_UPLOAD );
        }
    }
}
else
{
    $uploadStatus = new SMTUploadStatusDto();
    $uploadStatus->setProgress( SMTUploadStatusDto::NO_UPLOAD );
    $uploadStatus->setUploadErrorStatus( SMTUploadStatusDto::UPLOAD_ALREADY_RUNNING );
    SMTLogger::getInstance()->trace("Upload already running...", SMTLogger::ERROR);
    
    // add error code 401 in case of upload failure
    @header('Cache-Control: no-cache, must-revalidate', true, 401 ); 
}

$response = buildJsonResponse( $uploadStatus );

die( $response );

?>