<?php
// *********************************************************
// NOTICE: All rights reserved. This material contains the
// trade secrets and confidential information of JDSU
// which embody substantial creative effort,
// ideas and expressions. No part of this material may be
// reproduced or transmitted in any form or by any means,
// electronic, mechanical, optical or otherwise, including
// photocopying and recording or in connection with any
// information storage or retrieval system, without
// specific written permission from JDSU
// Copyright JDSU 2012. All rights reserved.
// *********************************************************
namespace app\util;

use app\util\SMTDto;

/**
 * Status dto used with OTU for alarms, activity acknowledgment
 * 
 * @author sdesplat
 */
class SMTStatusDto extends SMTDto
{
    const OK = 'OK';
    const KO = 'KO';
    
    /**
     * The role name 
     * 
     * @var string
     */
    protected $status = self::OK;
        
    /**
     * The status value: OK or KO
     * 
     * @param string $roleName
     * 
     * @return whether the rolename is equivalent to the given one;
     */
    public function getStatus()
    {
        return $this->status;
    }
    
    /**
     * Set status to OK
     */
    public function setStatusOK()
    {
        $this->status = self::OK;
    }

    /**
     * Set status to KO
     */
    public function setStatusKO()
    {
    	$this->status = self::KO;
    }
    
    /**
     * Serialize as Json data the role object.<br> 
     * 
     * @return $objectProperties the object properties serialized as a Json string.
     */
    function getJsonData()
    {
    	$objectProperties = get_object_vars( $this );
        $this->serializeObjectAsJsonData( $objectProperties );
    	return $objectProperties;
    }
    
    /**
     * Returns Dto class name.
     *
     * @return string the dtop class name
     */
    function getDtoClassName()
    {
    	return get_class();
    }        
}

?>