<?php
// *********************************************************
// NOTICE: All rights reserved. This material contains the
// trade secrets and confidential information of JDSU
// which embody substantial creative effort,
// ideas and expressions. No part of this material may be
// reproduced or transmitted in any form or by any means,
// electronic, mechanical, optical or otherwise, including
// photocopying and recording or in connection with any
// information storage or retrieval system, without
// specific written permission from JDSU
// Copyright JDSU 2012. All rights reserved.
// *********************************************************
namespace app\util;

/**
 * Invalid value exceptions
 * 
 * @author Sylvain Desplat
 */
class SMTInvalidValueException extends SMTException
{       
    const INVALID_VALUE = "INVALID_VALUE";
    
    /**
     * The name of the parameter with the invalid value 
     * @var string
     */
    protected $parameterName = "";
    
    /**
     * The invalid value of the parameter
     * @var string
     */
    protected $parameterValue = "";
    
    /**
     *
     * @param string $code string error code
     * @param string $message detailed message
     * @param string $parameterName The name of the parameter with the invalid value 
     * @param string $parameterValue The invalid value of the parameter
     */    
    function __construct( $code = NULL, $message = NULL, $parameterName = NULL, $parameterValue = NULL )
    {
    	parent::__construct( $code, $this->buildMessage( $code, $parameterName, $parameterValue ) );
    }        

    /**
     * Get error codes label for tracing without error codes.
     * @param string $code The exception error code (SMTSocketException)
     *
     * @return string
     */
    public function getErrorLabel()
    {
    	return $this->getErrorCode();
    }    
    
    /**
     * Build exception message from given parameters
     * @param string $code string error code
     * @param string $parameterName The name of the parameter with the invalid value 
     * @param string $parameterValue The invalid value of the parameter     
     * @return string the status message.
     */
    private function buildMessage( $code = NULL, $parameterName = NULL, $parameterValue = NULL )
    {
        ($parameterName != NULL) ? $this->parameterName = $parameterName: $this->parameterName = "";
        ($parameterValue != NULL) ? $this->parameterValue = $parameterValue: $this->parameterValue = "";
        return $this->decodeMessage( $code );
    }
    
    /**
     * Translates status code. If the code is not found, returns an empty string.
     *
     * @param string $code The status code to translate
     *
     * @return string the status message.
     */
    public function decodeMessage( $code )
    {
    	$message = sprintf( MSG_INVALID_VALUE_EXCEPTION, "" );
    
    	switch( $code )
    	{
    	    case self::INVALID_VALUE:
    	    	$message = sprintf( MSG_INVALID_VALUE_EXCEPTION, $this->parameterName .": ". $this->parameterValue ) ;
    	    	break;  	    	    	    	
	    	default:
	    		break;
    	}
    	return $message;
    }
}

?>