<?php
// *********************************************************
// NOTICE: All rights reserved. This material contains the
// trade secrets and confidential information of JDSU
// which embody substantial creative effort,
// ideas and expressions. No part of this material may be
// reproduced or transmitted in any form or by any means,
// electronic, mechanical, optical or otherwise, including
// photocopying and recording or in connection with any
// information storage or retrieval system, without
// specific written permission from JDSU
// Copyright JDSU 2012. All rights reserved.
// *********************************************************
namespace app\util;

/**
 * I/O exceptions
 * 
 * @author Sylvain Desplat
 *
 */
class SMTIOException extends SMTException
{       
    const COPY_FAILURE = "COPY_FAILURE";
    const FILE_NOT_FOUND = "FILE_NOT_FOUND";
    const COULD_NOT_ACQUIRE_LOCK = "COULD_NOT_ACQUIRE_LOCK";
    const COULD_NOT_CREATE_FILE = "COULD_NOT_CREATE_FILE";
    const COULD_NOT_CREATE_SNAPSHOT = "COULD_NOT_CREATE_SNAPSHOT";
    const COULD_NOT_CREATE_BACKUP = "COULD_NOT_CREATE_BACKUP";
    const NO_BACKUP_FOUND = "NO_BACKUP_FOUND";
    const INVALID_FILE = "INVALID_FILE";
    
    /**
     *
     * @param string $code error code
     * @param string $message detailed message
     */    
    function __construct( $code = NULL, $message = NULL )
    {
    	parent::__construct( $code, $message );
    }
    
    /**
     * Get error codes label for tracing without error codes.
     *
     * @return string
     */
    public function getErrorLabel()
    {
    	return $this->getErrorCode();
    }
        
    /**
     * Translates status code. If the code is not found, returns an empty string.
     *
     * @param string $code The status code to translate
     *
     * @return string the status message or an empty string if the status couldn't be found.
     */
    public function decodeMessage( $code )
    {
    	$message = MSG_IO_EXCEPTION.$code;
    
    	switch( $code )
    	{
    	    case self::COPY_FAILURE:
    	    	$message = MSG_ERROR_COPY_FAILED;
    	    	break;
	    	case self::FILE_NOT_FOUND:
	    		$message = MSG_ERROR_FILE_NOT_FOUND;
	    		break;    	    	
	    	case self::COULD_NOT_ACQUIRE_LOCK:
	    	    $message = MSG_ERROR_COULD_NOT_ACQUIRE_LOCK;
	    	    break;    	    	
    	    case self::COULD_NOT_CREATE_FILE:
    	    	$message = MSG_ERROR_COULD_NOT_CREATE_FILE;
    	    	break;
	    	case self::COULD_NOT_CREATE_SNAPSHOT:
	    		$message = MSG_ERROR_COULD_NOT_CREATE_SNAPSHOT;
	    		break;    	    	
    		case self::COULD_NOT_CREATE_BACKUP:
    			$message = MSG_ERROR_COULD_NOT_CREATE_BACKUP;
    			break;	    		
    		case self::NO_BACKUP_FOUND:
    		    $message = MSG_ERROR_NO_BACKUP_FOUND;
    		    break;	 
    		case self::INVALID_FILE:
    		    $message = MSG_ERROR_INVALID_FILE;
	    	default:
	    		break;
    	}
    	return $message;
    }
}

?>