<?php
// *********************************************************
// NOTICE: All rights reserved. This material contains the
// trade secrets and confidential information of JDSU
// which embody substantial creative effort,
// ideas and expressions. No part of this material may be
// reproduced or transmitted in any form or by any means,
// electronic, mechanical, optical or otherwise, including
// photocopying and recording or in connection with any
// information storage or retrieval system, without
// specific written permission from JDSU
// Copyright JDSU 2012. All rights reserved.
// *********************************************************
namespace app\util;

use app\error\SMTRestException;

/**
 * Base SmartOTU exception
 * 
 * @author Sylvain Desplat
 *
 */
abstract class SMTException extends \Exception
{    
    protected $detailedMessage = NULL;
    
    /**
     * Custom string error code
     * 
     * @var string
     */
    protected $errorCode = NULL;
    
    /**
     * 
     * @param string $code error code embedded in a string or string label error code
     * @param string $detailedMessage (Optional) detailed message
     * @param integer $htmlCode the html optional error code. If not set uses SMTRestException::INTERNAL_SERVER_ERROR
     */
    function __construct( $code, $detailedMessage = NULL, $htmlCode = SMTRestException::INTERNAL_SERVER_ERROR )
    {
    	parent::__construct(  $this->decodeMessage($code), $htmlCode );
    	$this->errorCode = $code;
    	$this->detailedMessage = ($detailedMessage != NULL )? $detailedMessage : "";
    }
    
    /**
     * Custom exception string error code
     * 
     * @return string
     */
    public final function getErrorCode()
    {
        return $this->errorCode;
    }
    
    /**
     * Get error codes label for tracing without error codes.
     * 
     *
     * @return the error codes label.
     */
    abstract public function getErrorLabel();
    
    public function getDetailedMessage() 
    {
        return $this->detailedMessage;
    }
    
    /**
     * Translates exception error code in int or string format (translates integer $code or string $otuCode given in constructor)
     * 
     * @param $code string or integer, the exception error code 
     * 
     * @return string the exception message
     */
    abstract public function decodeMessage( $code );
}

?>