<?php
// *********************************************************
// NOTICE: All rights reserved. This material contains the
// trade secrets and confidential information of JDSU
// which embody substantial creative effort,
// ideas and expressions. No part of this material may be
// reproduced or transmitted in any form or by any means,
// electronic, mechanical, optical or otherwise, including
// photocopying and recording or in connection with any
// information storage or retrieval system, without
// specific written permission from JDSU
// Copyright JDSU 2012. All rights reserved.
// *********************************************************
namespace app\sharedmemory;

use app\util\SMTIDto;

/**
 * Interface to implement to save/recovery DTOs from shared and persistent memory
 * 
 * @author Sylvain Desplat
 *
 */
interface SMTIMemorySupport extends SMTIDto
{
    const SMTIMEMORY_SUPPORT_FULL_QUALIFIED_NAME = "app\sharedmemory\SMTIMemorySupport";
        
    /**
     * Default timeout for data stored in APC memory cache.
     * 
     * @var int
     */
    const DEFAULT_TIMEOUT_SEC = 600; 
    
    /**
     * Returns the object id
     *
     * @return  string $id
     */    
    function getId();
    
    /**
     * Save Dto in shared memory
     * 
     * @throws SMTAPCMemoryException
     */
    function save();

    /**
     * Delete Dto from shared memory
     *
     * @throws SMTAPCMemoryException
     */    
    function delete();    
    
    /**
     * Whether the dto stored in APC memory is obsolete and should be purged.
     *
     *
     * @return boolean Whether the dto stored in APC memory is obsolete and should be purged.
     */
    public function isObsolete();    
    
    /**
     * Returns the timestamp of the last APC memory access (used to handle obsolescence of dtos in cache)
     * @see isObsolete()
     * @return number Timestamp of the last APC memory access (used to handle obsolescence of dtos in cache)
     */
    public function getLastAccess();

    /**
     * Update Timestamp of the last APC memory access (used to handle obsolescence of dtos in cache)
     * @see isObsolete()
     * 
     */    
    public function touchAccess();
}
?>