<?php
// *********************************************************
// NOTICE: All rights reserved. This material contains the
// trade secrets and confidential information of JDSU
// which embody substantial creative effort,
// ideas and expressions. No part of this material may be
// reproduced or transmitted in any form or by any means,
// electronic, mechanical, optical or otherwise, including
// photocopying and recording or in connection with any
// information storage or retrieval system, without
// specific written permission from JDSU
// Copyright JDSU 2012. All rights reserved.
// *********************************************************
namespace app\sharedmemory;

use app\util\SMTException;

/**
 * APC shared and persistent memory module exception
 * 
 * @author Sylvain Desplat
 *
 */
class SMTAPCMemoryException extends SMTException
{
    const ERROR_READING_APC = "ERROR_READING_APC";
    const ERROR_WRITING_APC = "ERROR_WRITING_APC";
    
    /**
     *
     * @param string $code integer error code
     * @param string $message detailed message
     */    
    function __construct( $code = NULL, $message = NULL )
    {
    	parent::__construct( $code, $message );
    }
    
    /**
     * Get error codes label for tracing without error codes.
     * @param string $code The exception error code (SMTSocketException)
     *
     * @return string
     */
    public function getErrorLabel()
    {
    	return $this->getErrorCode();
    }
    
    /**
     * Translates exception error code
     * 
     * @param string $code The exception error code
     * 
     * @return string the exception message
     */
    public function decodeMessage( $code )
    {
        $errorMessage = self::ERROR_READING_APC;
        
        switch( $code )
        {
            case self::ERROR_READING_APC:
                $errorMessage = MSG_ERROR_READING_APC;
                break;
            case self::ERROR_WRITING_APC:
            	$errorMessage = MSG_ERROR_WRITING_APC;
            	break;          
            default:
                break;
        }
        return $errorMessage;
    }
}

?>