<?php
// *********************************************************
// NOTICE: All rights reserved. This material contains the
// trade secrets and confidential information of JDSU
// which embody substantial creative effort,
// ideas and expressions. No part of this material may be
// reproduced or transmitted in any form or by any means,
// electronic, mechanical, optical or otherwise, including
// photocopying and recording or in connection with any
// information storage or retrieval system, without
// specific written permission from JDSU
// Copyright JDSU 2013. All rights reserved.
// *********************************************************
namespace app\serviceshelper\otdr;


/**
 * Otdr trace type (monitoring reference trace, acquisition trace, last monitoring acquisition trace, alarm trace).
 * 
 * @author Sylvain Desplat
 */
class SMTOtdrTraceType
{
    /**
     * OTU monitoring reference trace type
     * @var string
     */
    const OTU_REFERENCE_TRACE = "OTU_REFERENCE_TRACE";
    /**
     * SmartOTU trace type: otdr acquisition trace stored in SmartOtu session directory
     * @var string
     */
    const SMARTOTU_ACQUISITION_TRACE = "SMARTOTU_ACQUISITION_TRACE";
    /**
     * OTU acquisition trace type: last otdr acquisition trace of the monitoring test stored in Otu directory
     * @var string
     */
    const LAST_TEST_ACQUISITION_TRACE = "LAST_TEST_ACQUISITION_TRACE";
    /**
     * OTU reference trace type
     * @var string
     */
    const REF   = "REF";
    /**
     * OTU alarme trace type
     * @var string
     */    
    const ALARM = "ALARM";
    /**
     * OTU last acquisition trace type
     * @var string
     */    
    const ACQ   = "ACQ";    
    
    /**
     * OTU alarm trace type
     * @var string
     */
    const OTU_ALARM_TRACE = "OTU_ALARM_TRACE";    
    
    /**
     * OTU short acq alarm trace type
     * @var string
     */
    const OTU_SHORTACQ_ALARM_TRACE = "OTU_SHORTACQ_ALARM_TRACE";
}
?>