<?php
// *********************************************************
// NOTICE: All rights reserved. This material contains the
// trade secrets and confidential information of VIAVI Solutions
// which embody substantial creative effort,
// ideas and expressions. No part of this material may be
// reproduced or transmitted in any form or by any means,
// electronic, mechanical, optical or otherwise, including
// photocopying and recording or in connection with any
// information storage or retrieval system, without
// specific written permission from VIAVI Solutions
// Copyright VIAVI Solutions 2019. All rights reserved.
// *********************************************************
namespace app\serviceshelper\otau;


use app\parser\SMTOtuSocket;

use app\parser\SMTOtuApi;
use app\services\setup\SMTRotauDto;

/**
 *
 * @author Sylvain Desplat
 *
 */
class SMTRotauSwitchDet extends SMTMacroSwitch
{    
	/**
	 * Macro switch identifier
	 *
	 * @var string
	 */
	protected $macroSwitchId;
	
	protected $device;
	
	protected $rotauIp;
	
    /**
     * 
     * @param app\parser\SMTOtuSocket $socket
     * @param $macroSwitchId
     */
	function __construct( SMTOtuSocket $socket, $macroSwitchId)
    {
        parent::__construct($socket);
        $this->macroSwitchId = $macroSwitchId;
    }
    
    /**
     * 
     */
    protected function retrieveGlobal()
    {
    	$result = $this->socket->sendReceive( sprintf( SMTOtuApi::CMD_switch_detect_desc, $this->macroSwitchId, parent::GLOB ) );
    	list( $device, $code, $rotauIp ) = explode(',', $result);
    	$this->device = trim($device);
    	$this->rotauIp = trim($rotauIp);
        $this->setSwitchDecoder( parent::GLOB, $code );
    }
    
    /**
     * not applicable
     */
    protected function retrieveInternal()
    {
    	//not applicable
    }
    
    /**
     *
     */
    protected function retrieveSN()
    {
    	$this->serialNumber= $this->socket->sendReceive( sprintf( SMTOtuApi::CMD_get_rotau_sn_det, $this->macroSwitchId ) );
    }

    /**
     *
     * @param $detected boolean Whether the switch is detected or retrieved from configuration
     *
     */
    protected function buildSwitchDto()
    {
    	$osuNumber = 0;
    	
    	//if global switch decoder exists (case of detection), set it in the dto.
    	$decoder = $this->getSwitchDecoder( self::GLOB );
    	if ( $decoder != NULL )
    	{
    		$this->globalSwitchEncodedString = $decoder->getSwitchEncodingString();
    		$osuNumber = $decoder->getOSUCount();

    		$switchDto = new SMTRotauDto();
    		$switchDto->setSerialNumber( $this->serialNumber );
    		$switchDto->setDetected( TRUE );
    		$switchDto->setIndex( $this->macroSwitchId);
    		
    		$switchDto->setInput( $decoder->getIn() );
    		$switchDto->setOutput( $decoder->getOut() );
    		$switchDto->setGlobalSwitchEncodedString($this->globalSwitchEncodedString);
    		$switchDto->setDevice($this->device);
    		$switchDto->setRotauIp($this->rotauIp);
    		
    		array_push($this->switchesDto, $switchDto);
    	}    
    }
    
    /**
     *
     * @var app\services\setup\SMTRotauDto
     */
    public function getRotauSwitchDto()
    {
    	return count($this->switchesDto) > 0 ? $this->switchesDto[0] : null;
    }
    
    /**
     * Retrieve Rotau macro switch Dto
     * 
     * @param SMTOtuSocket $socket 
     * 
     * @return app\services\setup\SMTRotauDto
     */
    static function retrieve( SMTOtuSocket $socket, $macroSwitchId)
    {
    	$macroSwitchConf = new SMTRotauSwitchDet($socket, $macroSwitchId);
        $macroSwitchConf->retrieveGlobal();
        $macroSwitchConf->retrieveSN();
    	$macroSwitchConf->buildSwitchDto( FALSE );
    	
    	return $macroSwitchConf->getRotauSwitchDto();
    }  
}
?>