<?php
// *********************************************************
// NOTICE: All rights reserved. This material contains the
// trade secrets and confidential information of JDSU
// which embody substantial creative effort,
// ideas and expressions. No part of this material may be
// reproduced or transmitted in any form or by any means,
// electronic, mechanical, optical or otherwise, including
// photocopying and recording or in connection with any
// information storage or retrieval system, without
// specific written permission from JDSU
// Copyright JDSU 2014. All rights reserved.
// *********************************************************
namespace app\services\setup;

use app\util\SMTInvalidValueException;

use app\util\SMTUtil;

use app\util\SMTRwDto;

/**
 * SNMP configuration DTO.
 * 
 * @author Sylvain Desplat
 */
class SMTSnmpDto extends SMTRwDto
{
    /**
     *
     * @var string
     */
    const SNMP_DEFAULT_COMMUNITY = "OTU";
    
    /**
     * @var integer
     */
    const SNMP_DEFAULT_PORT = 162;
    
    /**
     * @var integer
     */
    const SNMP_SINGLE_CONFIG_INDEX = 1;
    
    /**
     * @var string
     */    
	protected $manager;
	
	/**
	 * @var string
	 */
	protected $community = self::SNMP_DEFAULT_COMMUNITY;
	
	/**
	 * @var integer
	 */
	protected $port = self::SNMP_DEFAULT_PORT;

	/**
	 * @var string
	 */
	protected $trapMessage;
	
	/**
	 * SNMP index = 1 since there is only one configuration
	 * @var integer
	 */
	protected $index = self::SNMP_SINGLE_CONFIG_INDEX;
	
	/**
	 * @param integer
	 */
	public function setPort( $port )
	{
	    if ( !isset($port) || $port === NULL || !SMTUtil::isInt( $port ) )
	    {
	    	throw new SMTInvalidValueException( SMTInvalidValueException::INVALID_VALUE, NULL, "snmp port", $port );
	    }
	    $this->port = SMTUtil::convertToInt( $port );	    
	}
	
	/**
	 * @return integer
	 */
	public function getPort()
	{
		return $this->port;
	}
	
	/**
	 * @param string
	 */
	public function setManager( $manager )
	{
		$this->manager = $manager;
	}

	/**
	 * @return string
	 */
	public function getManager()
	{
		return $this->manager;
	}

	/**
	 * @param string
	 */
	public function setCommunity( $community )
	{
		$this->community = $community;
	}

	/**
	 * @return string
	 */
	public function getCommunity()
	{
		return $this->community;
	}
	
	/**
	 * @param string
	 */
	public function setTrapMessage( $message )
	{
		$this->trapMessage = $message;
	}
	
	/**
	 * @return string
	 */
	public function getTrapMessage()
	{
		return $this->trapMessage;
	}
	
	/**
	 * @param number
	 */
	public function setIndex( $index )
	{
		if ( !isset($index) || $index === NULL || !SMTUtil::isInt( $index ) )
		{
			throw new SMTInvalidValueException( SMTInvalidValueException::INVALID_VALUE, NULL, "snmp index", $index );
		}
		$this->index = SMTUtil::convertToInt( $index );
	}
	
	/**
	 * @return number
	 */
	public function getIndex()
	{
		return $this->index;
	}
	
	/**
	 * Serialize as Json data the user object.<br>
	 *
	 * @return $objectProperties the object properties serialized as a Json string.
	 */
	function getJsonData()
	{
		$objectProperties = get_object_vars($this);
		$this->serializeObjectAsJsonData( $objectProperties );
		return $objectProperties;
	}

	/**
	 * Returns Dto class name.
	 *
	 * @return string the dtop class name
	 */
	function getDtoClassName()
	{
		return get_class();
	}

	/**
	 * Create the Dto from a Json Dto in an array
	 *
	 * @param array $json_array json data in an array
	 *
	 * @return \app\services\setup\SMTConfEmailDto
	 */
	static function getInstance( array &$json_array )
	{
		return self::forge( get_class(), $json_array );
	}
}

?>