<?php
// *********************************************************
// NOTICE: All rights reserved. This material contains the
// trade secrets and confidential information of JDSU
// which embody substantial creative effort,
// ideas and expressions. No part of this material may be
// reproduced or transmitted in any form or by any means,
// electronic, mechanical, optical or otherwise, including
// photocopying and recording or in connection with any
// information storage or retrieval system, without
// specific written permission from JDSU
// Copyright JDSU 2012. All rights reserved.
// *********************************************************
namespace app\services\setup;

use app\util\SMTUtil;

use app\util\SMTRwDto;

use app\util\SMTInvalidValueException;

/**
 * 
 * @author Sylvain Desplat
 */
class SMTEmailDto extends SMTRwDto
{
	protected $index;
	protected $addressFrom;
	protected $addressTo;
	protected $subject;
    protected $valid;
	
    /**
     * @SMTAttributeInfosAnnotation(classname='app\services\setup\SMTEmailPortFilterDto')
     * @var app\services\setup\SMTEmailPortFilterDto
     */
    protected $portFilter;    
    
	/**
	 * @param boolean
	 */
	public function setValid( $valid )
	{
		$this->valid = $valid;
	}
	
	/**
	 * @return boolean
	 */
	public function isValid()
	{
		return $this->valid;
	}
	
	/**
	 * @param number
	 */	
	public function setIndex( $index )
	{
	    if ( !isset($index) || $index === NULL || !SMTUtil::isInt( $index ) )
	    {
	    	throw new SMTInvalidValueException( SMTInvalidValueException::INVALID_VALUE, NULL, "email index", $index );
	    }
		$this->index = SMTUtil::convertToInt( $index );
	}

	/**
	 * @return number
	 */
	public function getIndex()
	{
		return $this->index;
	}

	/**
	 * @param string
	 */
	public function setAddressFrom( $addressFrom )
	{
		$this->addressFrom = $addressFrom;
	}
	
	/**
	 * @return string
	 */
	public function getAddressTo()
	{
		return $this->addressTo;
	}
	
	/**
	 * @param string
	 */
	public function setAddressTo( $addressTo )
	{
		$this->addressTo = $addressTo;
	}
	
	/**
	 * @return string
	 */
	public function getAddressFrom()
	{
		return $this->addressFrom;
	}
	
	/**
	 * @param string
	 */
	public function setSubject( $subject )
	{
		$this->subject = $subject;
	}
	
	/**
	 * @return string
	 */
	public function getSubject()
	{
		return $this->subject;
	}	
	
	/**
	 *
	 * @param app\services\setup\SMTEmailPortFilterDto $portFilter
	 */
	public function setPortFilter(SMTEmailPortFilterDto $portFilter )
	{
		$this->portFilter = $portFilter;
	}
		
	/**
	 *
	 * @return app\services\setup\SMTEmailPortFilterDto $portFilter
	 */
	public function getPortFilter()
	{
		return $this->portFilter;
	}	
	
	/**
	 * Serialize as Json data the user object.<br>
	 *
	 * @return $objectProperties the object properties serialized as a Json string.
	 */
	function getJsonData()
	{
		$objectProperties = get_object_vars($this);
		$this->serializeObjectAsJsonData( $objectProperties );
		return $objectProperties;
	}

	/**
	 * Returns Dto class name.
	 *
	 * @return string the dtop class name
	 */
	function getDtoClassName()
	{
		return get_class();
	}

	/**
	 * Create the Dto from a Json Dto in an array
	 *
	 * @param array $json_array json data in an array
	 *
	 * @return \app\services\setup\SMTEmailDto
	 */
	static function getInstance( array &$json_array )
	{
		return self::forge( get_class(), $json_array );
	}
}


?>