<?php
// *********************************************************
// NOTICE: All rights reserved. This material contains the
// trade secrets and confidential information of VIAVI Solutions
// which embody substantial creative effort,
// ideas and expressions. No part of this material may be
// reproduced or transmitted in any form or by any means,
// electronic, mechanical, optical or otherwise, including
// photocopying and recording or in connection with any
// information storage or retrieval system, without
// specific written permission from VIAVI Solutions
// Copyright VIAVI Solutions 2017. All rights reserved.
// *********************************************************
namespace app\services\setup;

use app\services\SMTIService;
use app\services\SMTService;
use app\serviceshelper\system\SMTOtu;

/**
 * Service to setup advanced OTU 8000 features (relay, backup route, ...) for ONMSi mode.
 * 
 * @author Sylvain Desplat
 */
class SMTAdvancedOptionalService extends SMTService implements SMTIService
{    
    /**
     * Fetch relays status
     *
     * @url GET /relay/
     * 
     * @access protected
     * @class SMTAccessControl {@requires user}
     */
    function fetchRelayStatus()
    {        
        $relayDto = new SMTRelayDto();
        $otu = new SMTOtu();
        $otu->setContext( $this->getContext() );
        
        try
        {
        	$relayOption = $otu->isRelayOption();
        	$relayDto->setRelayOption($relayOption);
        	if ( $relayOption )
        	{
        		$otu->retrieveRelayStatus($relayDto);
        	}
    	}
    	catch ( \Exception $e )
    	{
    	    $this->handleException($e);
    	}
    
    	return $relayDto->getJsonData();
    }    
    
    /**
     * update relays with given status
     *
     * @url POST /relay/update
     * @access protected
     * @class SMTAccessControl {@requires user}
     */
    function updateRelay( $request_data )
    {
        try 
        {
        	$relay = SMTRelayDto::getInstance( $request_data );
        	
        	$otu = new SMTOtu();
        	$otu->setContext( $this->getContext() );
        	$otu->updateRelay($relay);
    	}
    	catch ( \Exception $e )
    	{
    	    $this->getContext()->traceException($e);
    		$this->handleException($e);
    	}    			
    	return $this->fetchRelayStatus();
    }
    
    /**
     * init relays
     *
     * @url POST /relay/init
     * @access protected
     * @class SMTAccessControl {@requires user}
     */
    function initRelay()
    {
    	try
    	{
    		$otu = new SMTOtu();
    		$otu->setContext( $this->getContext() );
    		$otu->initRelay();
    	}
    	catch ( \Exception $e )
    	{
    		$this->getContext()->traceException($e);
    		$this->handleException($e);
    	}
    	return $this->fetchRelayStatus();
    }
}

?>