<?php
// *********************************************************
// NOTICE: All rights reserved. This material contains the
// trade secrets and confidential information of VIAVI
// which embody substantial creative effort,
// ideas and expressions. No part of this material may be
// reproduced or transmitted in any form or by any means,
// electronic, mechanical, optical or otherwise, including
// photocopying and recording or in connection with any
// information storage or retrieval system, without
// specific written permission from VIAVI
// Copyright VIAVI Solutions 2017. All rights reserved.
// *********************************************************
namespace app\services\security;

use app\admin\SMTOtuType;

use app\admin\SMTUserDto;
use app\services\monitoring\SMTCurrentPortDto;

use app\util\SMTDto;

/**
 * 
 * @author Sylvain Desplat
 */
class SMTInitDto extends SMTDto
{
    /**
     * @SMTAttributeInfosAnnotation(classname='app\admin\SMTUserDto')
     * @var app\admin\SMTUserDto
     */
	protected $user = NULL;
	
    /**
     * @SMTAttributeInfosAnnotation(classname='app\services\monitoring\SMTCurrentPortDto')
     * @var app\services\monitoring\SMTCurrentPortDto
     */
	protected $currentPort = NULL;
	
	/**
	 * The host name otu the OTU
	 * @var string
	 */
	protected $hostName = "";
	
	/**
	 * 
	 * @var boolean is Local mode
	 */
	protected $localMode = FALSE;
	
	/**
	 * @var string Otu type
	 */
	protected $otuType = SMTOtuType::DEFAULT_OTU_TYPE;
	
	/**
	 *
	 * @param string $hostName
	 */
	function setHostName( $hostName)
	{
		$this->hostName = $hostName;
	}
	
	/**
	 *
	 * @param boolean $localMode
	 */
	function setLocalMode( $localMode)
	{
		$this->localMode = $localMode;
	}
	
	/**
	 * OTU type
	 * @param string $type
	 */
	function setOtuType( $type)
	{
		$this->otuType = $type;
	}
	
	/**
	 * @param string $releaseVersion
	 */
	public function setCurrentPort( SMTCurrentPortDto $currentPort )
	{
		$this->currentPort = $currentPort;
	}

	/**
	 * @param string $releaseVersion
	 */
	public function setUser( SMTUserDto $user )
	{
		$this->user = $user;
	}
	
	/**
	 * Serialize as Json data the user object.<br>
	 *
	 * @return $objectProperties the object properties serialized as a Json string.
	 */
	function getJsonData()
	{
		$objectProperties = get_object_vars($this);
		$this->serializeObjectAsJsonData( $objectProperties );
		return $objectProperties;
	}

	/**
	 * Returns Dto class name.
	 *
	 * @return string the dtop class name
	 */
	function getDtoClassName()
	{
		return get_class();
	}
}


?>